# billing
Billing extension for hubs.meeds.io business plans
## Configurability

The following configuration properties are available:

- **`meeds.billing.enabled`**  
  Enables or disables the billing add-on. This is the main property used to activate the add-on.

- **`meeds.billing.secretKey`**  
  Represents the Stripe secret key (private API key) used by the server to authenticate with Stripe.  
  **Required:** If missing, the add-on remains disabled even if `meeds.billing.enabled` is set to `true`.

- **`meeds.billing.webhook.secretKey`**  
  Represents the Stripe webhook secret key.  
  **Required:** Used exclusively to verify that incoming webhook requests come from Stripe.

- **`meeds.billing.spaceTemplateIds`**  
  Defines the list of space template IDs that are considered billable.  
  **Required.**

- **`meeds.billing.spaceTemplate.[templateId].priceId`**  
  Defines the Stripe Price ID (retrieved from the Stripe Dashboard under *Products → Pricing*) associated with the specified billable space template.  
  The Price ID represents the billing plan applied when a space is created from this template. During space creation, the billing service uses this value to create a corresponding Stripe subscription linked to the identified plan.  
  **Required.**

- **`meeds.billing.spaceTemplate.[templateId].trialDays`**  
  Defines the number of trial days for the plan.  
  **Optional.**

- **`meeds.billing.hubBillingReport.job.cron`**  
  Defines the cron expression for scheduling the periodic metred hub billing report job.  
  **Optional:** Defaults to daily execution.
- **`meeds.billing.tieredHubBillingReport.job.cron`**
  Defines the cron expression for scheduling the periodic tiered hub billing report job schedule.  
  **Optional:** Defaults to daily execution.

### Stripe Webhook Configuration

When creating the Stripe destination webhook, the following events must be selected to ensure proper synchronization between Stripe and the billing add-on:

- `customer.subscription.updated`
- `plan.updated`
- `invoice.paid`