/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billig.service;

import com.google.api.client.util.Maps;
import com.stripe.exception.SignatureVerificationException;
import com.stripe.model.Event;
import com.stripe.model.EventDataObjectDeserializer;
import com.stripe.model.Invoice;
import com.stripe.model.Plan;
import com.stripe.model.Subscription;
import com.stripe.net.Webhook;
import io.meeds.billing.model.HubBilling;
import io.meeds.billing.model.HubBillingPlan;
import io.meeds.billing.model.HubBillingSettings;
import io.meeds.billing.service.BillingService;
import io.meeds.billing.service.HubBillingPlanService;
import io.meeds.billing.service.HubSettingService;
import io.meeds.billing.service.WebhookHandlingService;
import io.meeds.billing.utils.Utils;
import java.util.HashMap;
import java.util.Optional;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

@SpringBootTest(classes={WebhookHandlingService.class})
@ExtendWith(value={MockitoExtension.class})
public class WebhookHandlingServiceTest {
    @MockitoBean
    private HubBilling hubBilling;
    @MockitoBean
    HubSettingService hubSettingService;
    @MockitoBean
    private HubBillingPlanService hubBillingPlanService;
    @MockitoBean
    private BillingService billingService;
    @Autowired
    private WebhookHandlingService webhookHandlingService;
    private static final String SIGNATURE = "test-signature";
    private static final String SECRET_KEY = "whsec_test";
    private static final String SUBSCRIPTION_ID = "sub_12345";

    @Test
    public void testHandleSubscriptionUpdatedEvent_success() throws Exception {
        Subscription subscription = new Subscription();
        subscription.setId(SUBSCRIPTION_ID);
        subscription.setStatus("active");
        Event event = (Event)Mockito.mock(Event.class);
        EventDataObjectDeserializer deserializer = (EventDataObjectDeserializer)Mockito.mock(EventDataObjectDeserializer.class);
        Event.Data eventData = (Event.Data)Mockito.mock(Event.Data.class);
        Mockito.when((Object)eventData.getPreviousAttributes()).thenReturn(new HashMap());
        Mockito.when((Object)event.getData()).thenReturn((Object)eventData);
        Mockito.when((Object)event.getType()).thenReturn((Object)"customer.subscription.updated");
        Mockito.when((Object)event.getDataObjectDeserializer()).thenReturn((Object)deserializer);
        Mockito.when((Object)deserializer.getObject()).thenReturn(Optional.of(subscription));
        Mockito.when((Object)this.hubBilling.getWebHookSecretKey()).thenReturn((Object)SECRET_KEY);
        HubBillingSettings hubBillingSettings = (HubBillingSettings)Mockito.mock(HubBillingSettings.class);
        HubBillingPlan hubBillingPlan = (HubBillingPlan)Mockito.mock(HubBillingPlan.class);
        Mockito.when((Object)hubBillingSettings.getHubBillingPlan()).thenReturn((Object)hubBillingPlan);
        Mockito.when((Object)hubBillingPlan.getPlanId()).thenReturn((Object)"planId");
        Plan plan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)plan.getId()).thenReturn((Object)"planId");
        Mockito.when((Object)this.hubSettingService.getSettingsBySubscriptionId(SUBSCRIPTION_ID)).thenReturn((Object)hubBillingSettings);
        try (MockedStatic mockedWebHook = Mockito.mockStatic(Webhook.class);
             MockedStatic mockedUtils = Mockito.mockStatic(Utils.class);){
            mockedWebHook.when(() -> Webhook.constructEvent((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.eq((Object)SIGNATURE)), (String)((String)ArgumentMatchers.eq((Object)SECRET_KEY)))).thenReturn((Object)event);
            mockedUtils.when(() -> Utils.getPlanFromSubscription((Subscription)((Subscription)ArgumentMatchers.any(Subscription.class)))).thenReturn((Object)plan);
            this.webhookHandlingService.handleWebHookEvent("{}", SIGNATURE);
            ((HubSettingService)Mockito.verify((Object)this.hubSettingService, (VerificationMode)Mockito.times((int)1))).updateHuBillingSetting((HubBillingSettings)ArgumentMatchers.any(HubBillingSettings.class), (Subscription)ArgumentMatchers.any(Subscription.class), ArgumentMatchers.anyMap());
        }
    }

    @Test
    void testHandleSubscriptionUpdatedEvent_fail() throws Exception {
        Mockito.when((Object)this.hubBilling.getWebHookSecretKey()).thenReturn((Object)SECRET_KEY);
        try (MockedStatic mocked = Mockito.mockStatic(Webhook.class);){
            mocked.when(() -> Webhook.constructEvent((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.eq((Object)SIGNATURE)), (String)((String)ArgumentMatchers.eq((Object)SECRET_KEY)))).thenThrow(new Throwable[]{new SignatureVerificationException("Invalid signature", SIGNATURE)});
            Assert.assertThrows(SignatureVerificationException.class, () -> this.webhookHandlingService.handleWebHookEvent("{}", SIGNATURE));
            ((HubSettingService)Mockito.verify((Object)this.hubSettingService, (VerificationMode)Mockito.times((int)0))).updateHuBillingSetting((HubBillingSettings)ArgumentMatchers.any(HubBillingSettings.class), (Subscription)ArgumentMatchers.any(Subscription.class), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void testHandleInvoiceUpdatedEvent_success() throws Exception {
        Invoice invoice = (Invoice)Mockito.mock(Invoice.class);
        Invoice.Parent invoiceParent = (Invoice.Parent)Mockito.mock(Invoice.Parent.class);
        Invoice.Parent.SubscriptionDetails subscriptionDetails = (Invoice.Parent.SubscriptionDetails)Mockito.mock(Invoice.Parent.SubscriptionDetails.class);
        Mockito.when((Object)invoice.getParent()).thenReturn((Object)invoiceParent);
        Mockito.when((Object)invoiceParent.getSubscriptionDetails()).thenReturn((Object)subscriptionDetails);
        Mockito.when((Object)invoice.getAmountPaid()).thenReturn((Object)2L);
        Mockito.when((Object)subscriptionDetails.getSubscription()).thenReturn((Object)SUBSCRIPTION_ID);
        Event event = (Event)Mockito.mock(Event.class);
        EventDataObjectDeserializer deserializer = (EventDataObjectDeserializer)Mockito.mock(EventDataObjectDeserializer.class);
        Mockito.when((Object)event.getType()).thenReturn((Object)"invoice.paid");
        Mockito.when((Object)event.getDataObjectDeserializer()).thenReturn((Object)deserializer);
        Mockito.when((Object)deserializer.getObject()).thenReturn(Optional.of(invoice));
        Mockito.when((Object)this.hubBilling.getWebHookSecretKey()).thenReturn((Object)SECRET_KEY);
        HubBillingSettings hubBillingSettings = (HubBillingSettings)Mockito.mock(HubBillingSettings.class);
        Mockito.when((Object)hubBillingSettings.getSubscriptionStatus()).thenReturn((Object)Utils.SubscriptionStatus.TRIALING.name());
        Mockito.when((Object)this.hubSettingService.getSettingsBySubscriptionId(ArgumentMatchers.anyString())).thenReturn((Object)hubBillingSettings);
        Subscription subscription = (Subscription)Mockito.mock(Subscription.class);
        Mockito.when((Object)this.billingService.getSubscription(ArgumentMatchers.anyString())).thenReturn((Object)subscription);
        try (MockedStatic mocked = Mockito.mockStatic(Webhook.class);){
            mocked.when(() -> Webhook.constructEvent((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.eq((Object)SIGNATURE)), (String)((String)ArgumentMatchers.eq((Object)SECRET_KEY)))).thenReturn((Object)event);
            this.webhookHandlingService.handleWebHookEvent("{}", SIGNATURE);
            ((HubSettingService)Mockito.verify((Object)this.hubSettingService, (VerificationMode)Mockito.times((int)1))).updateSettings((HubBillingSettings)ArgumentMatchers.any(HubBillingSettings.class));
        }
    }

    @Test
    public void testHandlePlanUpdatedEvent_success() throws Exception {
        Plan plan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)plan.getId()).thenReturn((Object)"plan_id");
        Mockito.when((Object)plan.getMeter()).thenReturn(null);
        Mockito.when((Object)plan.getProduct()).thenReturn((Object)"product_id");
        HashMap metadata = Maps.newHashMap();
        metadata.put("maxOfUsers", "10");
        Mockito.when((Object)plan.getMetadata()).thenReturn((Object)metadata);
        Event event = (Event)Mockito.mock(Event.class);
        EventDataObjectDeserializer deserializer = (EventDataObjectDeserializer)Mockito.mock(EventDataObjectDeserializer.class);
        Mockito.when((Object)event.getType()).thenReturn((Object)"plan.updated");
        Mockito.when((Object)event.getDataObjectDeserializer()).thenReturn((Object)deserializer);
        Mockito.when((Object)deserializer.getObject()).thenReturn(Optional.of(plan));
        Mockito.when((Object)this.hubBilling.getWebHookSecretKey()).thenReturn((Object)SECRET_KEY);
        HubBillingPlan HubBillingPlan2 = (HubBillingPlan)Mockito.mock(HubBillingPlan.class);
        Mockito.when((Object)this.hubBillingPlanService.getHubBillingPlanByPlanId("plan_id")).thenReturn((Object)HubBillingPlan2);
        try (MockedStatic mocked = Mockito.mockStatic(Webhook.class);){
            mocked.when(() -> Webhook.constructEvent((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.eq((Object)SIGNATURE)), (String)((String)ArgumentMatchers.eq((Object)SECRET_KEY)))).thenReturn((Object)event);
            this.webhookHandlingService.handleWebHookEvent("{}", SIGNATURE);
            ((HubBillingPlanService)Mockito.verify((Object)this.hubBillingPlanService, (VerificationMode)Mockito.times((int)1))).saveHubBillingPlan((HubBillingPlan)ArgumentMatchers.any(HubBillingPlan.class));
        }
    }
}

