/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billig.service;

import io.meeds.billing.service.SubscriptionEmailReminderService;
import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

@SpringBootTest(classes={SubscriptionEmailReminderService.class})
@ExtendWith(value={MockitoExtension.class})
class SubscriptionEmailReminderServiceTest {
    @Autowired
    private SubscriptionEmailReminderService plugin;
    @MockitoBean
    private MailService mailService;
    @MockitoBean
    private OrganizationService organizationService;
    @MockitoBean
    private ResourceBundleService resourceBundleService;
    @MockitoBean
    private BrandingService brandingService;
    @MockitoBean
    private PermanentLinkService permanentLinkService;
    @MockitoBean
    private UserProfileHandler userProfileHandler;
    @MockitoBean
    private User user;
    @MockitoBean
    private UserProfile userProfile;
    @MockitoBean
    private UserHandler userHandler;

    SubscriptionEmailReminderServiceTest() {
    }

    @BeforeEach
    public void init() throws Exception {
        this.plugin.setEmailBodyPath("fake-path.html");
        this.plugin.setEmailBodyTemplate("$SENDER_FULL_NAME wants to remind you that your trial period is ending soon");
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.organizationService.getUserProfileHandler()).thenReturn((Object)this.userProfileHandler);
        Mockito.when((Object)this.userHandler.findUserByName("sender")).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getEmail()).thenReturn((Object)"sender@example.com");
        Mockito.when((Object)this.user.getDisplayName()).thenReturn((Object)"sender sender");
        Mockito.when((Object)this.userProfileHandler.findUserProfileByName("sender")).thenReturn((Object)this.userProfile);
        Mockito.when((Object)this.userHandler.findUserByName("recipient")).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getEmail()).thenReturn((Object)"recipient@example.com");
        Mockito.when((Object)this.user.getDisplayName()).thenReturn((Object)"recipient recipient");
        Mockito.when((Object)this.userProfileHandler.findUserProfileByName("recipient")).thenReturn((Object)this.userProfile);
        Mockito.when((Object)this.userProfile.getAttribute("user.language")).thenReturn((Object)"en");
        Mockito.when((Object)this.resourceBundleService.getSharedString(ArgumentMatchers.anyString(), (Locale)ArgumentMatchers.any())).thenReturn((Object)"TranslatedText");
        Mockito.when((Object)this.brandingService.getCompanyName()).thenReturn((Object)"MyCompany");
        Mockito.when((Object)this.brandingService.getThemeStyle()).thenReturn(Collections.singletonMap("primaryColor", "#123456"));
        Mockito.when((Object)this.permanentLinkService.getPermanentLink((PermanentLinkObject)ArgumentMatchers.any(PermanentLinkObject.class))).thenReturn((Object)"fak-url");
        Session mockSession = Session.getInstance((Properties)new Properties());
        Mockito.when((Object)this.mailService.getMailSession()).thenReturn((Object)mockSession);
        ((MailService)Mockito.doNothing().when((Object)this.mailService)).sendMessage((MimeMessage)ArgumentMatchers.any(MimeMessage.class));
    }

    @Test
    void shouldSendEmailSuccessfully() throws Exception {
        try (MockedStatic commonsUtilsMock = Mockito.mockStatic(CommonsUtils.class);
             MockedStatic linkProviderUtilsMock = Mockito.mockStatic(LinkProviderUtils.class);){
            commonsUtilsMock.when(CommonsUtils::getCurrentDomain).thenReturn((Object)"fake-domain");
            linkProviderUtilsMock.when(() -> LinkProviderUtils.getRedirectUrl((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn((Object)"fake-url");
            linkProviderUtilsMock.when(LinkProviderUtils::getBaseUrl).thenReturn((Object)"fake-url");
            ((MailService)Mockito.doNothing().when((Object)this.mailService)).sendMessage((MimeMessage)ArgumentMatchers.any(MimeMessage.class));
            this.plugin.sendEmailNotification("sender", List.of("recipient"), 123L, "TRIAL_ENDING");
            ((MailService)Mockito.verify((Object)this.mailService, (VerificationMode)Mockito.times((int)1))).sendMessage((MimeMessage)ArgumentMatchers.any(MimeMessage.class));
        }
    }
}

