/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.rest;

import io.meeds.billing.service.WebhookHandlingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/webhooks"})
@Tag(name="webhooks", description="An endpoint to receive stripe webhooks")
public class BillingWebHookRest {
    private static final Log LOG = ExoLogger.getLogger(BillingWebHookRest.class);
    @Autowired
    WebhookHandlingService webhookHandlingService;

    @PostMapping(path={"stripe"})
    @Operation(summary="Stripe Webhook Endpoint", description="Receives and processes webhook events from Stripe.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @ResponseStatus(value=HttpStatus.OK)
    public void stripeEvent(@RequestBody String payload, @RequestHeader(value="Stripe-Signature") String sigHeader) {
        try {
            this.webhookHandlingService.handleWebHookEvent(payload, sigHeader);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            LOG.warn("Received a Stripe webhook event not associated with any hub, Event ignored: {}", new Object[]{objectNotFoundException.getMessage()});
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error while handling Stripe webhook event");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

