/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.service;

import com.stripe.model.Event;
import com.stripe.model.Invoice;
import com.stripe.model.Plan;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.net.Webhook;
import io.meeds.billing.model.HubBilling;
import io.meeds.billing.model.HubBillingPlan;
import io.meeds.billing.model.HubBillingSettings;
import io.meeds.billing.service.BillingService;
import io.meeds.billing.service.HubBillingPlanService;
import io.meeds.billing.service.HubSettingService;
import io.meeds.billing.utils.Utils;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebhookHandlingService {
    private static final Log LOG = ExoLogger.getLogger(WebhookHandlingService.class);
    private static final String CUSTOMER_SUBSCRIPTION_UPDATED_EVENT = "customer.subscription.updated";
    private static final String CUSTOMER_INVOICE_PAYMENT_EVENT = "invoice.paid";
    private static final String PLAN_UPDATED_EVENT = "plan.updated";
    @Autowired
    private HubBilling hubBilling;
    @Autowired
    private HubSettingService hubSettingService;
    @Autowired
    private BillingService billingService;
    @Autowired
    private HubBillingPlanService hubBillingPlanService;

    public void handleWebHookEvent(String payload, String signature) throws Exception {
        Event event = null;
        String webHookSecret = this.hubBilling.getWebHookSecretKey();
        event = Webhook.constructEvent((String)payload, (String)signature, (String)webHookSecret);
        this.processEvent(event);
    }

    private void processEvent(Event event) throws Exception {
        switch (event.getType()) {
            case "customer.subscription.updated": {
                this.processSubscriptionUpdatedEvent(event);
                break;
            }
            case "invoice.paid": {
                this.processInvoicePaymentEvent(event);
                break;
            }
            case "plan.updated": {
                this.processPlanUpdatedEvent(event);
                break;
            }
            default: {
                LOG.warn((Object)("Unknown event type: " + event.getType()));
            }
        }
    }

    private void processSubscriptionUpdatedEvent(Event event) throws ObjectNotFoundException {
        StripeObject stripeObject = event.getDataObjectDeserializer().getObject().orElse(null);
        if (stripeObject instanceof Subscription) {
            String updatedPlanId;
            Subscription subscription = (Subscription)stripeObject;
            HubBillingSettings hubBillingSettings = this.hubSettingService.getSettingsBySubscriptionId(subscription.getId());
            String currentPlanId = hubBillingSettings.getHubBillingPlan().getPlanId();
            boolean planChanged = !StringUtils.equals((CharSequence)currentPlanId, (CharSequence)(updatedPlanId = Utils.getPlanFromSubscription(subscription).getId()));
            this.hubSettingService.updateHuBillingSetting(hubBillingSettings, subscription, event.getData().getPreviousAttributes());
            if (planChanged) {
                this.notifyAdminsOnPlanChange(hubBillingSettings.getSpaceId());
            }
        }
    }

    private void processInvoicePaymentEvent(Event event) throws Exception {
        StripeObject stripeObject = event.getDataObjectDeserializer().getObject().orElse(null);
        if (stripeObject instanceof Invoice) {
            Invoice invoice = (Invoice)stripeObject;
            boolean isTrialInvoice = invoice.getAmountPaid() == 0L;
            String subscriptionId = invoice.getParent().getSubscriptionDetails().getSubscription();
            HubBillingSettings hubBillingSettings = this.hubSettingService.getSettingsBySubscriptionId(subscriptionId);
            if (hubBillingSettings != null && Utils.SubscriptionStatus.TRIALING.name().equalsIgnoreCase(hubBillingSettings.getSubscriptionStatus()) && !isTrialInvoice) {
                Subscription subscription = this.billingService.getSubscription(subscriptionId);
                hubBillingSettings.setSubscriptionStatus(Utils.SubscriptionStatus.ACTIVE.name());
                hubBillingSettings.setSubscriptionCurrentPeriodEnd(Utils.getCurrentPeriodEndDate(subscription));
                this.hubSettingService.updateSettings(hubBillingSettings);
            }
        }
    }

    private void processPlanUpdatedEvent(Event event) {
        Plan plan;
        HubBillingPlan hubBillingPlan;
        StripeObject stripeObject = event.getDataObjectDeserializer().getObject().orElse(null);
        if (stripeObject instanceof Plan && (hubBillingPlan = this.hubBillingPlanService.getHubBillingPlanByPlanId((plan = (Plan)stripeObject).getId())) != null) {
            hubBillingPlan.setMeterId(plan.getMeter());
            hubBillingPlan.setProductId(plan.getProduct());
            String maxOfUsersMetadata = MapUtils.isNotEmpty((Map)plan.getMetadata()) ? (String)plan.getMetadata().get("maxOfUsers") : null;
            long maxOfUsers = maxOfUsersMetadata == null ? 0L : Long.parseLong(maxOfUsersMetadata);
            hubBillingPlan.setMaxUsers(maxOfUsers);
            this.hubBillingPlanService.saveHubBillingPlan(hubBillingPlan);
        }
    }

    private void notifyAdminsOnPlanChange(long spaceId) {
        this.billingService.notifyAdminsOnPlanChange(spaceId);
    }
}

