/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.listener;

import io.meeds.billing.model.HubBilling;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.model.SiteLayout;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFF)
public class SpaceSiteCreatedListener
implements ListenerBase<SiteKey, SiteKey> {
    private static final Log LOG = ExoLogger.getLogger(SpaceSiteCreatedListener.class);
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private HubBilling hubBilling;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("site.template.instantiated", (ListenerBase)this);
    }

    public void onEvent(Event<SiteKey, SiteKey> event) throws Exception {
        boolean isBillableSpace;
        SiteKey siteKey = (SiteKey)event.getData();
        if (!siteKey.getName().startsWith("/spaces/")) {
            return;
        }
        Space space = this.spaceService.getSpaceByGroupId(siteKey.getName());
        if (space == null) {
            return;
        }
        boolean bl = isBillableSpace = this.hubBilling.isEnabled() && this.hubBilling.getSpaceTemplateIds().contains(space.getTemplateId());
        if (isBillableSpace) {
            this.updateSpaceLayout(siteKey);
        }
    }

    private void updateSpaceLayout(SiteKey siteKey) {
        try {
            PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
            SiteLayout siteLayout = portalConfig.getPortalLayout();
            Application application = new Application();
            application.setAccessPermissions(portalConfig.getAccessPermissions());
            TransientApplicationState transientApplicationState = new TransientApplicationState("billing/HubSubscriptionRestriction");
            application.setState((ApplicationState)transientApplicationState);
            siteLayout.setChildren(new ArrayList(siteLayout.getChildren()));
            siteLayout.getChildren().add(application);
            portalConfig.setPortalLayout((Container)siteLayout);
            this.layoutService.save(portalConfig);
        }
        catch (Exception e) {
            LOG.error("Error while adding portlet 'HubSubscriptionRestriction' to space site layout with id '{}'", new Object[]{siteKey, e});
        }
    }
}

