/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billig.scheduling.task;

import io.meeds.billing.model.HubBillingSettings;
import io.meeds.billing.scheduling.task.HubBillingReportJob;
import io.meeds.billing.service.BillingService;
import io.meeds.billing.service.HubSettingService;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

@SpringBootTest(classes={HubBillingReportJob.class})
@ExtendWith(value={MockitoExtension.class})
public class HubBillingReportJobTest {
    @MockitoBean
    private BillingService billingService;
    @MockitoBean
    private HubSettingService hubSettingService;
    @Autowired
    private HubBillingReportJob hubBillingReportJob;

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.billingService.isEnabled()).thenReturn((Object)true);
    }

    @Test
    public void shouldDoNothingWhenNoHubBillingSettings() throws Exception {
        Mockito.when((Object)this.hubSettingService.getMeteredHubBillingSettingList()).thenReturn(Collections.emptyList());
        this.hubBillingReportJob.reportMembersCount();
        ((BillingService)Mockito.verify((Object)this.billingService, (VerificationMode)Mockito.never())).reportMembersCount((HubBillingSettings)ArgumentMatchers.any());
    }

    @Test
    public void shouldReportMembersCountForEachHubBillingSetting() throws Exception {
        HubBillingSettings hubBillingSettings = (HubBillingSettings)Mockito.mock(HubBillingSettings.class);
        Mockito.when((Object)this.hubSettingService.getMeteredHubBillingSettingList()).thenReturn(List.of(hubBillingSettings));
        this.hubBillingReportJob.reportMembersCount();
        ((BillingService)Mockito.verify((Object)this.billingService, (VerificationMode)Mockito.times((int)1))).reportMembersCount(hubBillingSettings);
    }

    @Test
    public void shouldCatchExceptionWhenBillingServiceFails() throws Exception {
        HubBillingSettings hubBillingSettings = (HubBillingSettings)Mockito.mock(HubBillingSettings.class);
        HubBillingSettings secondHubBillingSettings = (HubBillingSettings)Mockito.mock(HubBillingSettings.class);
        Mockito.when((Object)hubBillingSettings.getSpaceId()).thenReturn((Object)123L);
        Mockito.when((Object)hubBillingSettings.getSpaceId()).thenReturn((Object)1234L);
        Mockito.when((Object)this.hubSettingService.getMeteredHubBillingSettingList()).thenReturn(List.of(hubBillingSettings, secondHubBillingSettings));
        ((BillingService)Mockito.doThrow((Throwable[])new Throwable[]{new Exception("Simulated failure")}).when((Object)this.billingService)).reportMembersCount(hubBillingSettings);
        ((BillingService)Mockito.doNothing().when((Object)this.billingService)).reportMembersCount(secondHubBillingSettings);
        this.hubBillingReportJob.reportMembersCount();
        ((BillingService)Mockito.verify((Object)this.billingService, (VerificationMode)Mockito.times((int)1))).reportMembersCount(hubBillingSettings);
        ((BillingService)Mockito.verify((Object)this.billingService, (VerificationMode)Mockito.times((int)1))).reportMembersCount(secondHubBillingSettings);
    }
}

