/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billig.listener;

import com.stripe.exception.StripeException;
import com.stripe.model.Price;
import com.stripe.model.Subscription;
import io.meeds.billing.listener.BillingSpaceListener;
import io.meeds.billing.model.HubBilling;
import io.meeds.billing.service.BillingService;
import io.meeds.billing.service.HubSettingService;
import io.meeds.billing.utils.Utils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

@SpringBootTest(classes={BillingSpaceListener.class})
@ExtendWith(value={MockitoExtension.class})
public class BillingSpaceListenerTest {
    @MockitoBean
    private HubBilling hubBilling;
    @MockitoBean
    private HubSettingService hubSettingService;
    @MockitoBean
    private IdentityManager identityManager;
    @MockitoBean
    private SpaceService spaceService;
    @MockitoBean
    private ListenerService listenerService;
    @MockitoBean
    private BillingService billingService;
    @Autowired
    private BillingSpaceListener billingSpaceListener;

    @BeforeEach
    void setUp() {
        this.billingSpaceListener.init();
    }

    @Test
    public void testSaveSettings() throws StripeException, ObjectAlreadyExistsException {
        Space space = (Space)Mockito.mock(Space.class);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        String customerId = "customer_1";
        String priceId = "price_1";
        Subscription subscription = (Subscription)Mockito.mock(Subscription.class);
        Price price = (Price)Mockito.mock(Price.class);
        Mockito.when((Object)price.getId()).thenReturn((Object)priceId);
        Mockito.when((Object)space.getTemplateId()).thenReturn((Object)1L);
        Mockito.when((Object)this.billingService.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.hubBilling.getSpaceTemplateIds()).thenReturn(Collections.singletonList(1L));
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("john")).thenReturn((Object)identity);
        Mockito.when((Object)this.billingService.getPriceById(priceId)).thenReturn((Object)price);
        Mockito.when((Object)this.billingService.createCustomer(space, identity)).thenReturn((Object)customerId);
        Mockito.when((Object)this.billingService.subscribe(space, customerId, priceId)).thenReturn((Object)subscription);
        try (MockedStatic utilsMock = Mockito.mockStatic(Utils.class);){
            utilsMock.when(() -> Utils.getCurrentPeriodEndDate((Subscription)subscription)).thenReturn((Object)new Date());
            utilsMock.when(() -> Utils.getTemplatePriceId((long)ArgumentMatchers.anyLong())).thenReturn((Object)priceId);
            SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, "john", SpaceLifeCycleEvent.Type.SPACE_CREATED);
            this.billingSpaceListener.spaceCreated(event);
            ((HubSettingService)Mockito.verify((Object)this.hubSettingService, (VerificationMode)Mockito.times((int)1))).createSettings((Space)ArgumentMatchers.eq((Object)space), (Subscription)ArgumentMatchers.any(Subscription.class), (Identity)ArgumentMatchers.eq((Object)identity));
            ((BillingService)Mockito.verify((Object)this.billingService, (VerificationMode)Mockito.times((int)1))).createCustomer(space, identity);
            ((BillingService)Mockito.verify((Object)this.billingService, (VerificationMode)Mockito.times((int)1))).subscribe(space, customerId, priceId);
        }
    }

    @Test
    public void testSpaceCreatedNotBillable() throws ObjectAlreadyExistsException {
        Space space = new Space();
        space.setGroupId("/spaces/test");
        space.setTemplateId(2L);
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, "john", SpaceLifeCycleEvent.Type.SPACE_CREATED);
        Mockito.when((Object)this.hubBilling.isEnabled()).thenReturn((Object)true);
        List<Long> templateIds = Collections.singletonList(1L);
        Mockito.when((Object)this.hubBilling.getSpaceTemplateIds()).thenReturn(templateIds);
        this.billingSpaceListener.spaceCreated(event);
        ((HubSettingService)Mockito.verify((Object)this.hubSettingService, (VerificationMode)Mockito.never())).createSettings((Space)ArgumentMatchers.any(Space.class), (Subscription)ArgumentMatchers.any(Subscription.class), (Identity)ArgumentMatchers.any(Identity.class));
    }
}

