/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billig.listener;

import io.meeds.billing.listener.SpaceSiteCreatedListener;
import io.meeds.billing.model.HubBilling;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.serialize.model.SiteLayout;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

@SpringBootTest(classes={SpaceSiteCreatedListener.class})
@ExtendWith(value={MockitoExtension.class})
public class SpaceSiteCreatedListenerTest {
    @MockitoBean
    private HubBilling hubBilling;
    @MockitoBean
    private SpaceService spaceService;
    @MockitoBean
    private ListenerService listenerService;
    @MockBean
    private LayoutService layoutService;
    @Autowired
    private SpaceSiteCreatedListener spaceSiteCreatedListener;

    @BeforeEach
    void setUp() {
        this.spaceSiteCreatedListener.init();
    }

    @Test
    public void onEvent() throws Exception {
        Space space = new Space();
        space.setGroupId("/spaces/test");
        space.setTemplateId(1L);
        SiteKey siteKey = new SiteKey(SiteType.GROUP, space.getGroupId());
        Mockito.when((Object)this.hubBilling.isEnabled()).thenReturn((Object)true);
        List<Long> templateIds = Collections.singletonList(1L);
        Mockito.when((Object)this.hubBilling.getSpaceTemplateIds()).thenReturn(templateIds);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(siteKey.getName())).thenReturn((Object)space);
        PortalConfig portalConfig = new PortalConfig();
        SiteLayout siteLayout = new SiteLayout();
        portalConfig.setPortalLayout((Container)siteLayout);
        Mockito.when((Object)this.layoutService.getPortalConfig(siteKey)).thenReturn((Object)portalConfig);
        Event event = new Event("site.template.instantiated", (Object)"", (Object)siteKey);
        this.spaceSiteCreatedListener.onEvent(event);
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)portalConfig.getPortalLayout().getChildren()).hasSize(1)).first()).isInstanceOf(Application.class);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save(portalConfig);
    }
}

