/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.service;

import com.stripe.StripeClient;
import com.stripe.exception.StripeException;
import com.stripe.model.Price;
import com.stripe.model.Subscription;
import com.stripe.model.billing.Meter;
import com.stripe.model.billingportal.Session;
import com.stripe.param.CustomerCreateParams;
import com.stripe.param.SubscriptionCreateParams;
import com.stripe.param.SubscriptionUpdateParams;
import com.stripe.param.billing.MeterEventCreateParams;
import com.stripe.param.billingportal.SessionCreateParams;
import io.meeds.billing.model.HubBilling;
import io.meeds.billing.model.HubBillingSettings;
import io.meeds.billing.service.HubSettingService;
import io.meeds.billing.service.SubscriptionEmailReminderService;
import io.meeds.billing.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.model.SiteLayout;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.stereotype.Service;

@Service
public class BillingService {
    private static final Log LOG = ExoLogger.getLogger(BillingService.class);
    private final HubBilling hubBilling;
    private final StripeClient stripeClient;
    private final SubscriptionEmailReminderService subscriptionEmailReminderService;
    private final SpaceService spaceService;
    private final HubSettingService hubSettingService;
    private final IdentityManager identityManager;
    private final LayoutService layoutService;
    private final Map<String, String> meterEventName = new ConcurrentHashMap<String, String>();
    private boolean enabled;

    public BillingService(HubBilling hubBilling, SubscriptionEmailReminderService subscriptionEmailReminderService, SpaceService spaceService, HubSettingService hubSettingService, IdentityManager identityManager, LayoutService layoutService) {
        this.hubBilling = hubBilling;
        this.subscriptionEmailReminderService = subscriptionEmailReminderService;
        this.spaceService = spaceService;
        this.hubSettingService = hubSettingService;
        this.identityManager = identityManager;
        this.layoutService = layoutService;
        boolean bl = this.enabled = this.hubBilling.isEnabled() && StringUtils.isNotBlank((CharSequence)this.hubBilling.getSecretKey());
        if (this.hubBilling.isEnabled() && StringUtils.isBlank((CharSequence)this.hubBilling.getSecretKey())) {
            LOG.warn((Object)"Billing is enabled but secret key is missing. The billing process will be disabled.");
        }
        this.stripeClient = this.enabled ? new StripeClient(this.hubBilling.getSecretKey()) : null;
    }

    public String createCustomer(Space space, Identity identity) throws StripeException {
        HashMap<String, String> customerMetadata = new HashMap<String, String>();
        customerMetadata.put("spaceId", space.getId());
        customerMetadata.put("userIdentityId", identity.getId());
        CustomerCreateParams params = CustomerCreateParams.builder().setName(space.getDisplayName()).setDescription(space.getDescription()).setEmail(identity.getProfile().getEmail()).setMetadata(customerMetadata).build();
        return this.stripeClient.customers().create(params).getId();
    }

    public Subscription subscribe(Space space, String customerId, String priceId) throws StripeException {
        Long spaceTemplateId = space.getTemplateId();
        String trialDaysValue = Utils.getTemplateTrialDays(spaceTemplateId);
        long trialDays = StringUtils.isEmpty((CharSequence)trialDaysValue) ? 0L : Long.parseLong(trialDaysValue);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("spaceId", space.getId());
        SubscriptionCreateParams.Item subscriptionItem = SubscriptionCreateParams.Item.builder().setPrice(priceId).build();
        SubscriptionCreateParams params = SubscriptionCreateParams.builder().setPaymentBehavior(SubscriptionCreateParams.PaymentBehavior.DEFAULT_INCOMPLETE).setCustomer(customerId).addItem(subscriptionItem).setMetadata(metadata).setTrialPeriodDays(Long.valueOf(trialDays)).build();
        return this.stripeClient.subscriptions().create(params);
    }

    public String createCustomerPortalSession(long spaceId, String userName) throws ObjectNotFoundException, IllegalAccessException {
        HubBillingSettings hubBillingSettings = this.hubSettingService.getSettingsBySpaceId(spaceId, userName);
        return this.createCustomerPortalSession(hubBillingSettings.getCustomerId());
    }

    public String createCustomerPortalSession(String customerId) {
        try {
            SessionCreateParams params = SessionCreateParams.builder().setCustomer(customerId).build();
            Session session = this.stripeClient.billingPortal().sessions().create(params);
            return session.getUrl();
        }
        catch (StripeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void cancelSubscription(long spaceId, String userName) throws ObjectNotFoundException, IllegalAccessException {
        HubBillingSettings hubBillingSettings = this.hubSettingService.getSettingsBySpaceId(spaceId, userName);
        this.cancelSubscription(hubBillingSettings.getSubscriptionId());
        this.hubSettingService.updateSubscriptionStatus(hubBillingSettings.getId(), Utils.SubscriptionStatus.CANCELED.name());
        this.notifyAdminsOnSubscriptionCancellation(null, spaceId);
    }

    public void cancelSubscription(String subscriptionId) {
        try {
            this.stripeClient.subscriptions().cancel(subscriptionId);
        }
        catch (StripeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Subscription getSubscription(String subscriptionId) throws Exception {
        return this.stripeClient.subscriptions().retrieve(subscriptionId);
    }

    public void notifyOnSubscriptionStatus(long spaceId, String authenticatedUser, boolean maxOfUsersExceeded) throws IllegalAccessException, ObjectNotFoundException {
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new ObjectNotFoundException("Space not found for Space Id: " + spaceId);
        }
        if (!this.spaceService.isMember(space, authenticatedUser)) {
            throw new IllegalAccessException("User" + authenticatedUser + " is not allowed to mange space " + spaceId);
        }
        HubBillingSettings hubBillingSettings = this.hubSettingService.getSettingsBySpaceId(String.valueOf(spaceId));
        if (maxOfUsersExceeded) {
            this.notifyHubAdminsOnUsersLimitExceeded(authenticatedUser, hubBillingSettings.getSpaceId());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)hubBillingSettings.getSubscriptionStatus(), (CharSequence)Utils.SubscriptionStatus.CANCELED.name())) {
            this.notifyAdminsOnSubscriptionCancellation(authenticatedUser, hubBillingSettings.getSpaceId());
        } else {
            this.notifyHubAdminsOnSubscriptionStatus(hubBillingSettings, authenticatedUser);
        }
    }

    public void notifyHubAdminsOnSubscriptionStatus(HubBillingSettings hubBillingSettings, String authenticatedUser) {
        String context = this.getNotificationContext(hubBillingSettings.getSubscriptionStatus(), hubBillingSettings.getSubscriptionPreviousStatus());
        if (context != null) {
            this.sendMailNotification(authenticatedUser, hubBillingSettings.getSpaceId(), context);
        }
    }

    public void notifyHubAdminsOnUsersLimitExceeded(String authenticatedUser, long spaceId) {
        this.sendMailNotification(authenticatedUser, spaceId, "maxOfUsersExceeded");
    }

    public void notifyAdminsOnPlanChange(long spaceId) {
        this.sendMailNotification(null, spaceId, "hubPlanChanged");
    }

    public void notifyAdminsOnSubscriptionCancellation(String authenticatedUser, long spaceId) {
        this.sendMailNotification(authenticatedUser, spaceId, "subscriptionCanceled");
    }

    public Price getPriceById(String id) throws StripeException {
        return this.stripeClient.prices().retrieve(id);
    }

    public void reportMembersCount(HubBillingSettings hubBillingSettings) throws Exception {
        String meterId = hubBillingSettings.getHubBillingPlan().getMeterId();
        if (meterId == null) {
            return;
        }
        Space space = this.spaceService.getSpaceById(hubBillingSettings.getSpaceId().longValue());
        if (space == null) {
            throw new ObjectNotFoundException("Space with id " + hubBillingSettings.getSpaceId() + " not found");
        }
        String eventName = this.meterEventName.computeIfAbsent(meterId, this::getEventNameByMeterId);
        if (eventName == null) {
            throw new ObjectNotFoundException("Meter Event with id " + meterId + " not found");
        }
        String customerId = hubBillingSettings.getCustomerId();
        String usersCount = String.valueOf(space.getMembers().length);
        MeterEventCreateParams params = MeterEventCreateParams.builder().setEventName(eventName).putPayload("value", usersCount).putPayload("stripe_customer_id", customerId).build();
        this.stripeClient.billing().meterEvents().create(params);
        LOG.info("Reported usage of {} members for space {} with meter event {}", new Object[]{usersCount, hubBillingSettings.getSpaceId(), eventName});
    }

    public void updateTieredBillingQuantities(HubBillingSettings hubBillingSettings) throws ObjectNotFoundException, StripeException {
        long currentQuantity;
        Space space = this.spaceService.getSpaceById(hubBillingSettings.getSpaceId().longValue());
        if (space == null) {
            throw new ObjectNotFoundException("Space with id " + hubBillingSettings.getSpaceId() + " not found");
        }
        long membersCount = space.getMembers().length;
        if (membersCount > (currentQuantity = hubBillingSettings.getSubscriptionQuantity())) {
            this.updateSubscriptionQuantity(hubBillingSettings.getSubscriptionId(), membersCount);
            LOG.info("Updating subscription quantity for space {} from {} to {}", new Object[]{space.getId(), currentQuantity, membersCount});
        }
    }

    public void updateSubscriptionQuantity(String subscriptionId, long subscriptionQuantity) throws StripeException, ObjectNotFoundException {
        Subscription subscription = this.stripeClient.subscriptions().retrieve(subscriptionId);
        String subscriptionItemId = Utils.getSubscriptionItemId(subscription);
        if (subscriptionItemId == null) {
            throw new ObjectNotFoundException("No subscription items found for subscription" + subscriptionId);
        }
        SubscriptionUpdateParams params = SubscriptionUpdateParams.builder().setPaymentBehavior(SubscriptionUpdateParams.PaymentBehavior.DEFAULT_INCOMPLETE).setProrationBehavior(SubscriptionUpdateParams.ProrationBehavior.ALWAYS_INVOICE).addItem(SubscriptionUpdateParams.Item.builder().setId(subscriptionItemId).setQuantity(Long.valueOf(subscriptionQuantity)).build()).build();
        this.stripeClient.subscriptions().update(subscriptionId, params);
    }

    public void enableExistingSpaceBilling(long spaceId, String priceId, String spaceManager) throws ObjectNotFoundException, ObjectAlreadyExistsException, IllegalAccessException {
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new ObjectNotFoundException("No space with id " + spaceId + " found");
        }
        HubBillingSettings settings = this.hubSettingService.getSettingsBySpaceId(space.getId());
        if (settings != null) {
            throw new ObjectAlreadyExistsException((Object)settings, "Space with id " + spaceId + " is already billable");
        }
        if (StringUtils.isBlank((CharSequence)priceId) || StringUtils.isBlank((CharSequence)spaceManager)) {
            throw new IllegalArgumentException("Missing required parameters: priceId and spaceManager must not be blank");
        }
        if (StringUtils.isNotBlank((CharSequence)spaceManager) && !this.spaceService.canManageSpace(space, spaceManager)) {
            throw new IllegalAccessException("User " + spaceManager + " not allowed to manage the space: " + spaceId);
        }
        try {
            Identity identity = this.identityManager.getOrCreateUserIdentity(spaceManager);
            Price price = this.getPriceById(priceId.trim());
            String customerId = this.createCustomer(space, identity);
            Subscription subscription = this.subscribe(space, customerId, price.getId());
            this.hubSettingService.createSettings(space, subscription, identity);
            this.updateBillableSpaceLayout(new SiteKey(SiteType.GROUP, space.getGroupId()));
        }
        catch (StripeException stripeException) {
            throw new IllegalArgumentException("Unable to enable billing for space " + spaceId + " : " + stripeException.getMessage());
        }
    }

    public void updateBillableSpaceLayout(SiteKey siteKey) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        SiteLayout siteLayout = portalConfig.getPortalLayout();
        Application application = new Application();
        application.setAccessPermissions(portalConfig.getAccessPermissions());
        TransientApplicationState transientApplicationState = new TransientApplicationState("billing/HubSubscriptionRestriction");
        application.setState((ApplicationState)transientApplicationState);
        siteLayout.setChildren(new ArrayList(siteLayout.getChildren()));
        siteLayout.getChildren().add(application);
        portalConfig.setPortalLayout((Container)siteLayout);
        this.layoutService.save(portalConfig);
    }

    private void sendMailNotification(String authenticatedUser, long spaceId, String context) {
        List<String> receivers = context.equals("subscriptionCanceled") || context.equals("hubPlanChanged") ? Utils.getAdministrators() : Utils.getSpaceManagers(spaceId);
        this.subscriptionEmailReminderService.sendEmailNotification(authenticatedUser, receivers, spaceId, context);
    }

    private String getNotificationContext(String subscriptionStatus, String subscriptionPreviousStatus) {
        if (subscriptionStatus == null) {
            return null;
        }
        if (Utils.SubscriptionStatus.TRIALING.name().equalsIgnoreCase(subscriptionStatus)) {
            return "trialEnding";
        }
        if (Utils.SubscriptionStatus.ACTIVE.name().equalsIgnoreCase(subscriptionStatus)) {
            return "subscriptionRenewal";
        }
        if (Utils.SubscriptionStatus.INCOMPLETE.name().equalsIgnoreCase(subscriptionStatus)) {
            return "subscriptionPastDue";
        }
        if (Utils.SubscriptionStatus.PAST_DUE.name().equalsIgnoreCase(subscriptionStatus)) {
            return Utils.SubscriptionStatus.TRIALING.name().equalsIgnoreCase(subscriptionPreviousStatus) ? "trialExpired" : "subscriptionPastDue";
        }
        return null;
    }

    private String getEventNameByMeterId(String meterId) {
        Meter meter = this.stripeClient.billing().meters().retrieve(meterId);
        return meter.getEventName();
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }
}

