<!--

  This file is part of the Meeds project (https://meeds.io/).

  Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

-->
<%@page import="org.exoplatform.social.core.space.model.Space" %>
<%@page import="org.exoplatform.social.core.space.spi.SpaceService" %>
<%@page import="org.exoplatform.social.core.space.SpaceUtils" %>
<%@page import="org.exoplatform.commons.utils.CommonsUtils" %>
<%@page import="org.exoplatform.commons.utils.PropertyManager"%>
<%@page import="io.meeds.billing.utils.Utils"%>

<%
  boolean isManager = false;
  Space space = SpaceUtils.getSpaceByContext();
  if (space != null) {
    SpaceService spaceService = CommonsUtils.getService(SpaceService.class);
    isManager = spaceService.canManageSpace(space, request.getRemoteUser());
  }

  String publicKey = PropertyManager.getProperty(Utils.PUBLIC_KEY_PROPERTY);
  String pricingTableId = PropertyManager.getProperty(Utils.PRICING_TABLE_ID_PROPERTY);
  String billingEnabledProperty = PropertyManager.getProperty(Utils.BILLING_ENABLED_PROPERTY);
  boolean isHubBillingEnabled = Boolean.parseBoolean(billingEnabledProperty != null ? billingEnabledProperty.trim() : "false");
%>
<% if (isManager && isHubBillingEnabled) { %>
<div class="VuetifyApp">
  <div data-app="true"
    class="v-application v-application--is-ltr theme--light"
    id="PricingTable">
    <script type="text/javascript">
      require(['PORTLET/billing/PricingTable'],
        app => app.init('<%=publicKey%>', '<%=pricingTableId%>')
      );
    </script>
  </div>
</div>
<% } %>