<!--

This file is part of the Meeds project (https://meeds.io/).

Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 3 of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

-->
<%@page import="org.exoplatform.social.core.space.model.Space" %>
<%@page import="org.exoplatform.social.core.space.spi.SpaceService" %>
<%@page import="org.exoplatform.social.core.space.SpaceUtils" %>
<%@page import="org.exoplatform.commons.utils.CommonsUtils" %>
<%@page import="org.exoplatform.commons.utils.PropertyManager" %>
<%@page import="io.meeds.billing.utils.Utils" %>
<%@ page import="io.meeds.billing.model.HubBillingSettings" %>
<%@ page import="io.meeds.billing.service.HubSettingService" %>


<%
  boolean isManager = false;
  String subscriptionStatus = null;
  Long currentPeriodEnd = null;
  boolean displayHubSubscriptionInfos = false;

  Space space = SpaceUtils.getSpaceByContext();
  if (space != null) {
    SpaceService spaceService = CommonsUtils.getService(SpaceService.class);
    isManager = spaceService.canManageSpace(space, request.getRemoteUser());

    HubSettingService hubSettingService = CommonsUtils.getService(HubSettingService.class);
    HubBillingSettings hubBillingSettings = hubSettingService.getSettingsBySpaceId(space.getId());
    if (hubBillingSettings != null) {
      subscriptionStatus = hubBillingSettings.getSubscriptionStatus().toLowerCase();
      currentPeriodEnd = hubBillingSettings.getSubscriptionCurrentPeriodEnd().getTime();
      long sevenDaysFromNow = System.currentTimeMillis() + (7L * 24 * 60 * 60 * 1000);
      displayHubSubscriptionInfos =
              Utils.SubscriptionStatus.TRIALING.name().equalsIgnoreCase(subscriptionStatus) ||
                      (Utils.SubscriptionStatus.ACTIVE.name().equalsIgnoreCase(subscriptionStatus) && currentPeriodEnd <= sevenDaysFromNow);
    }
  }

  String billingEnabledProperty = PropertyManager.getProperty(Utils.BILLING_ENABLED_PROPERTY);
  boolean isHubBillingEnabled = Boolean.parseBoolean(
          billingEnabledProperty != null ? billingEnabledProperty.trim() : "false"
  );
  displayHubSubscriptionInfos = isHubBillingEnabled && displayHubSubscriptionInfos;
%>
<% if (displayHubSubscriptionInfos) { %>
<div class="VuetifyApp">
  <div data-app="true"
       class="v-application v-application--is-ltr theme--light"
       id="hubSubscriptionInfos">
    <script type="text/javascript">
        require(['PORTLET/billing/HubSubscriptionInfos'],
            app => app.init(<%=isManager%>, '<%=subscriptionStatus%>', <%=currentPeriodEnd%>)
        );
    </script>
  </div>
</div>
<% } %>