/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.channel;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.PluginTemplateBuilderAdapter;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.lifecycle.AbstractNotificationLifecycle;
import org.exoplatform.commons.api.notification.lifecycle.DefaultLifecycle;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.container.component.BaseComponentPlugin;

public abstract class AbstractChannel
extends BaseComponentPlugin {
    private final AbstractNotificationLifecycle lifecycle;
    private boolean enabled = true;

    public AbstractChannel(AbstractNotificationLifecycle lifecycle) {
        this.lifecycle = lifecycle != null ? lifecycle : new DefaultLifecycle();
        this.lifecycle.setChannel(this);
    }

    public AbstractChannel() {
        this.lifecycle = new DefaultLifecycle();
        this.lifecycle.setChannel(this);
    }

    public void start() {
    }

    public void end() {
    }

    public abstract String getId();

    public abstract ChannelKey getKey();

    public AbstractNotificationLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public abstract void dispatch(NotificationContext var1, String var2);

    public void dispatch(NotificationInfo notifInfo) {
    }

    public abstract void registerTemplateProvider(TemplateProvider var1);

    public String getTemplateFilePath(PluginKey key) {
        return "";
    }

    public boolean hasTemplateBuilder(PluginKey key) {
        return false;
    }

    public AbstractTemplateBuilder getTemplateBuilder(PluginKey key) {
        if (!this.hasTemplateBuilder(key)) {
            return new PluginTemplateBuilderAdapter();
        }
        return this.getTemplateBuilderInChannel(key);
    }

    public boolean isDefaultChannel() {
        return true;
    }

    protected abstract AbstractTemplateBuilder getTemplateBuilderInChannel(PluginKey var1);

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

