/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.StringCommonUtils;

public class StringCommonUtilsTest
extends TestCase {
    public void testCompressDecompress() throws Exception {
        String initialString = "abcdefghijklmnopqrstuvwxyzabcde\u00e9abcd";
        InputStream is = StringCommonUtils.compress((String)initialString);
        String result = StringCommonUtils.decompress((InputStream)is);
        StringCommonUtilsTest.assertTrue((boolean)result.equals(initialString));
    }

    public void testEncodeSpecialCharInSearchTerm() {
        String s = null;
        StringCommonUtilsTest.assertEquals((String)"", (String)StringCommonUtils.encodeSpecialCharInSearchTerm(s));
        s = "";
        StringCommonUtilsTest.assertEquals((String)"", (String)StringCommonUtils.encodeSpecialCharInSearchTerm((String)s));
        s = "normal text";
        StringCommonUtilsTest.assertEquals((String)"normal text", (String)StringCommonUtils.encodeSpecialCharInSearchTerm((String)s));
        s = "@#$%^&*()\"/-=~`'.,";
        StringCommonUtilsTest.assertEquals((String)"&#64;&#35;&#36;&#37;&#94;&#38;&#42;&#40;&#41;&#34;&#47;&#45;&#61;&#126;&#96;&#39;&#46;&#44;", (String)StringCommonUtils.encodeSpecialCharInSearchTerm((String)s));
        s = "abc !#:? =., +;";
        StringCommonUtilsTest.assertEquals((String)"abc !#:? =., +;", (String)StringCommonUtils.encodeSpecialCharInSearchTerm((String)s));
        s = "abc !#: ()\" ' | ] [";
        StringCommonUtilsTest.assertEquals((String)"abc !#: &#40;&#41;&#34; &#39; &#124; &#93; &#91;", (String)StringCommonUtils.encodeSpecialCharInSearchTerm((String)s));
    }

    public void testencodeSpecialCharForSimpleInput() {
        String s = null;
        StringCommonUtilsTest.assertEquals((String)"", (String)StringCommonUtils.encodeSpecialCharForSimpleInput(s));
        s = "";
        StringCommonUtilsTest.assertEquals((String)"", (String)StringCommonUtils.encodeSpecialCharForSimpleInput((String)s));
        s = "normal text";
        StringCommonUtilsTest.assertEquals((String)"normal text", (String)StringCommonUtils.encodeSpecialCharForSimpleInput((String)s));
        s = "   abc   aa s   s";
        StringCommonUtilsTest.assertEquals((String)"abc aa s s", (String)StringCommonUtils.encodeSpecialCharForSimpleInput((String)s));
        s = "abc !#:?=.,()+; ddd";
        StringCommonUtilsTest.assertEquals((String)"abc !#:?=.,&#40;&#41;+; ddd", (String)StringCommonUtils.encodeSpecialCharForSimpleInput((String)s));
        s = "abc !# :?=.,' | ] [";
        StringCommonUtilsTest.assertEquals((String)"abc !# :?=.,&#39; &#124; &#93; &#91;", (String)StringCommonUtils.encodeSpecialCharForSimpleInput((String)s));
    }

    public void testEncodeSpecialCharInHTML() {
        String s = null;
        StringCommonUtilsTest.assertEquals((String)"", (String)StringCommonUtils.encodeSpecialCharInHTML(s));
        s = "";
        StringCommonUtilsTest.assertEquals((String)"", (String)StringCommonUtils.encodeSpecialCharInHTML((String)s));
        s = "normal text";
        StringCommonUtilsTest.assertEquals((String)"normal text", (String)StringCommonUtils.encodeSpecialCharInHTML((String)s));
        s = "abc &#<>[]/:?\"=.,*$%()\\+@!^*-}{;`~_ ddd";
        StringCommonUtilsTest.assertEquals((String)"abc &#<>[]/:?\"=.,*$%()\\+@!^*-}{;`~_ ddd", (String)StringCommonUtils.encodeSpecialCharInHTML((String)s));
        s = "abc !# :?=.,' | ] [";
        StringCommonUtilsTest.assertEquals((String)"abc !# :?=.,&#39; &#124; ] [", (String)StringCommonUtils.encodeSpecialCharInHTML((String)s));
    }

    public void testDecodeSpecialCharToHTMLnumber() throws Exception {
        String input = null;
        StringCommonUtilsTest.assertEquals(null, (String)StringCommonUtils.decodeSpecialCharToHTMLnumber(input));
        input = "";
        StringCommonUtilsTest.assertEquals((String)input, (String)StringCommonUtils.decodeSpecialCharToHTMLnumber((String)input));
        input = "Normal text abc";
        StringCommonUtilsTest.assertEquals((String)input, (String)StringCommonUtils.decodeSpecialCharToHTMLnumber((String)input));
        input = "Text ...&#60;&#64;&#35;&#36;&#37;&#94;&#38;&#42;&#40;&#41;&#34;&#47;&#45;&#61;&#126;&#96;&#39;&#46;&#44;&#62; too";
        StringCommonUtilsTest.assertEquals((String)"Text ...<@#$%^&*()\"/-=~`'.,> too", (String)StringCommonUtils.decodeSpecialCharToHTMLnumber((String)input));
        input = "Text ...&lt;div class=&quot;&amp;XZY&quot;&gt;Test&lt;&#47;div&gt;&#40;&#41;&#34;&#47;&#45;&#61;&#126;&#96;&#39;&#46;&#44;&#60;strong&#62;too&#60;&#47;strong&#62;";
        StringCommonUtilsTest.assertEquals((String)"Text ...<div class=\"&XZY\">Test</div>()\"/-=~`'.,<strong>too</strong>", (String)StringCommonUtils.decodeSpecialCharToHTMLnumber((String)input));
        List<String> ig = Arrays.asList("&gt;", "&lt;", "&#46;");
        StringCommonUtilsTest.assertEquals((String)"Text ...&lt;div class=\"&XZY\"&gt;Test&lt;/div&gt;()\"/-=~`'&#46;,<strong>too</strong>", (String)StringCommonUtils.decodeSpecialCharToHTMLnumber((String)input, ig));
        StringCommonUtilsTest.assertEquals((String)"Text ...&lt;div class=\"&amp;XZY\"&gt;Test&lt;/div&gt;()\"/-=~`'.,<strong>too</strong>", (String)StringCommonUtils.decodeSpecialCharToHTMLnumberIgnore((String)input));
    }

    public void testIsContainSpecialCharacter() {
        String input = null;
        StringCommonUtilsTest.assertEquals((boolean)false, (boolean)StringCommonUtils.isContainSpecialCharacter(input));
        input = "";
        StringCommonUtilsTest.assertEquals((boolean)false, (boolean)StringCommonUtils.isContainSpecialCharacter((String)input));
        input = "abcgde";
        StringCommonUtilsTest.assertEquals((boolean)false, (boolean)StringCommonUtils.isContainSpecialCharacter((String)input));
        input = "abcg#$de";
        StringCommonUtilsTest.assertEquals((boolean)true, (boolean)StringCommonUtils.isContainSpecialCharacter((String)input));
        input = "!@#abcgde";
        StringCommonUtilsTest.assertEquals((boolean)true, (boolean)StringCommonUtils.isContainSpecialCharacter((String)input));
        input = "&#<>[]/:?\"=.,*$%()\\+@!^*-}{;`~_";
        StringCommonUtilsTest.assertEquals((boolean)true, (boolean)StringCommonUtils.isContainSpecialCharacter((String)input));
    }
}

