/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.resource;

import javax.ws.rs.core.Response;
import org.exoplatform.commons.resource.ResourceBundleREST;
import org.exoplatform.commons.testing.BaseResourceTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.wadl.research.HTTPMethods;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.json.JSONObject;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.commons.component.core-local-configuration.xml")})
public class ResourceBundleRESTTest
extends BaseResourceTestCase {
    public void setUp() throws Exception {
        super.setUp();
        ResourceBundleREST resourceBundleREST = (ResourceBundleREST)this.getService(ResourceBundleREST.class);
        this.resourceBinder.addResource((Object)resourceBundleREST, null);
        ConversationState c = new ConversationState(new Identity("root"));
        ConversationState.setCurrent((ConversationState)c);
    }

    public void testGetBundleContent() throws Exception {
        String restPath = "/i18n/bundle/locale.test-fr.json";
        ContainerResponse response = this.service(HTTPMethods.GET.toString(), restPath, "", null, null);
        ResourceBundleRESTTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String data = (String)response.getEntity();
        JSONObject jsonObject = new JSONObject(data);
        ResourceBundleRESTTest.assertEquals((int)2, (int)jsonObject.length());
        ResourceBundleRESTTest.assertEquals((String)"testvalue_fr", (String)jsonObject.getString("testkey"));
        ResourceBundleRESTTest.assertEquals((String)"testvalue2", (String)jsonObject.getString("testkey2"));
    }

    public void testGetBundleContentUnknownLanguage() throws Exception {
        String restPath = "/i18n/bundle/locale.test-ca.json";
        ContainerResponse response = this.service(HTTPMethods.GET.toString(), restPath, "", null, null);
        ResourceBundleRESTTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String data = (String)response.getEntity();
        JSONObject jsonObject = new JSONObject(data);
        ResourceBundleRESTTest.assertEquals((int)2, (int)jsonObject.length());
        ResourceBundleRESTTest.assertEquals((String)"testvalue", (String)jsonObject.getString("testkey"));
        ResourceBundleRESTTest.assertEquals((String)"testvalue2", (String)jsonObject.getString("testkey2"));
    }
}

