/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.dao;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.search.dao.IndexingOperationDAO;
import org.exoplatform.commons.search.domain.IndexingOperation;
import org.exoplatform.commons.search.domain.OperationType;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.container.PortalContainer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class IndexingOperationDAOTest
extends BaseCommonsTestCase {
    private IndexingOperationDAO indexingOperationDAO;

    @Before
    public void setUp() {
        PortalContainer container = PortalContainer.getInstance();
        this.indexingOperationDAO = (IndexingOperationDAO)container.getComponentInstanceOfType(IndexingOperationDAO.class);
        this.begin();
    }

    @After
    public void tearDown() {
        this.indexingOperationDAO.deleteAll();
        this.end();
    }

    @Test
    public void testIndexingQueueCreation() throws IllegalAccessException, NoSuchFieldException {
        List indexingOperations = this.indexingOperationDAO.findAll();
        IndexingOperationDAOTest.assertEquals((int)indexingOperations.size(), (int)0);
        IndexingOperation indexingOperation = new IndexingOperation();
        indexingOperation.setEntityIndex("blog");
        indexingOperation.setOperation(OperationType.INIT);
        this.indexingOperationDAO.create((Object)indexingOperation);
        IndexingOperationDAOTest.assertEquals((int)this.indexingOperationDAO.findAll().size(), (int)1);
        Field privateField = IndexingOperation.class.getDeclaredField("timestamp");
        privateField.setAccessible(true);
        Date timestamp = (Date)privateField.get(indexingOperation);
        IndexingOperationDAOTest.assertNull((Object)timestamp);
    }

    @Test
    public void testDatabaseAutoGeneratingTimestamp() throws NoSuchFieldException, IllegalAccessException {
        IndexingOperation indexingOperation1 = new IndexingOperation();
        indexingOperation1.setEntityIndex("blog");
        indexingOperation1.setOperation(OperationType.INIT);
        this.indexingOperationDAO.create((Object)indexingOperation1);
        this.restartTransaction();
        indexingOperation1 = (IndexingOperation)this.indexingOperationDAO.find((Serializable)indexingOperation1.getId());
        Field privateField = IndexingOperation.class.getDeclaredField("timestamp");
        privateField.setAccessible(true);
        Date timestamp = (Date)privateField.get(indexingOperation1);
        IndexingOperationDAOTest.assertNotNull((Object)timestamp);
    }
}

