/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing;

import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.junit.BeforeClass;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.commons.component.core-dependencies-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.commons.component.core-configuration.xml")})
public abstract class BaseCommonsTestCase
extends AbstractKernelTest {
    protected static IDGeneratorService idGeneratorService;
    protected PortalContainer container;
    protected ConfigurationManager configurationManager;

    public void setUp() throws Exception {
        super.setUp();
        this.begin();
        this.container = PortalContainer.getInstance();
        this.configurationManager = this.getService(ConfigurationManager.class);
        System.setProperty("gatein.email.domain.url", "http://localhost:8080");
    }

    protected void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    @BeforeClass
    protected void beforeRunBare() {
        if (System.getProperty("gatein.test.output.path") == null) {
            System.setProperty("gatein.test.output.path", System.getProperty("java.io.tmpdir"));
        }
        super.beforeRunBare();
    }

    protected <T> T getService(Class<T> clazz) {
        return clazz.cast(this.container.getComponentInstanceOfType(clazz));
    }

    public static IDGeneratorService getIdGeneratorService() {
        if (idGeneratorService == null) {
            idGeneratorService = (IDGeneratorService)PortalContainer.getInstance().getComponentInstanceOfType(IDGeneratorService.class);
        }
        return idGeneratorService;
    }

    public static String generate() {
        return BaseCommonsTestCase.getIdGeneratorService().generateStringID((Object)Long.toString(System.currentTimeMillis()));
    }
}

