/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.commons.testing.webui;

import org.exoplatform.web.application.AbstractApplicationMessage;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;

/**
 * Convenience TestCase made to test UIComponent classes.
 * Creates a new UIComponent for each call to {@link #setUp()}
 * @param <T> type of the UIComponent
 */
public abstract class AbstractUIComponentTestCase<T extends UIComponent> extends AbstractWebuiTestCase {

  public AbstractUIComponentTestCase() throws Exception {
    super();
    
  }


  protected T component;
  
  
  public void doSetUp() {  
    try {
      initComponent();
    } catch (Exception e) { //we want to catch all exceptions here to know a testcase is false or not.
      fail("failed to initialize UIComponent: " + e.getMessage());
    }
  }
  
  private void initComponent() throws Exception {
    this.component = createComponent();
    this.component.setParent(new MockUIApplication());
  }

  protected abstract T createComponent() throws Exception;
  
  protected void assertApplicationMessage(String key) {
    UIApplication app = component.getAncestorOfType(UIApplication.class);
    boolean found = false;
    for (AbstractApplicationMessage message : app.getUIPopupMessages().getWarnings()) {
      if(key.equals(message.getMessageKey())) {
        found = true;
      }
    }
    
    for (AbstractApplicationMessage message : app.getUIPopupMessages().getInfos()) {
      if(key.equals(message.getMessageKey())) {
        found = true;
      }
    }
    
    for (AbstractApplicationMessage message : app.getUIPopupMessages().getErrors()) {
      if(key.equals(message.getMessageKey())) {
        found = true;
      }
    }
    
    assertTrue("Message not found <" + key +">", found);
    
  }
  
  
    class MockUIApplication extends UIApplication {

    public MockUIApplication() throws Exception {
      super();
      
    }

  }
  
}
