/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.HashMap;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectMapper;
import org.exoplatform.services.database.annotation.Table;
import org.exoplatform.services.database.annotation.TableField;

@Table(name="MockTable", field={@TableField(name="name", type="string", length=500, unique=true, nullable=false), @TableField(name="status", type="int", defaultValue="0"), @TableField(name="start", type="date"), @TableField(name="pass", type="boolean", defaultValue="false")})
public class Mock
extends DBObject {
    private String name;
    private int status;
    private Calendar start = Calendar.getInstance();
    private boolean pass = false;

    public Mock() {
    }

    public Mock(String name, int status) {
        this.name = name;
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPass() {
        return this.pass;
    }

    public void setPass(boolean pass) {
        this.pass = pass;
    }

    public Calendar getStart() {
        return this.start;
    }

    public void setStart(Calendar start) {
        this.start = start;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void getUserByName(String s) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("username", s);
        values.put("fname", s);
    }

    public static class MockMapper
    implements DBObjectMapper<Mock> {
        public String[][] toParameters(Mock bean) throws Exception {
            Date date = new Date(bean.getStart().getTimeInMillis());
            return new String[][]{{"id", String.valueOf(bean.getDBObjectId())}, {"name", bean.getName()}, {"status", String.valueOf(bean.getStatus())}, {"start", date.toString()}, {"pass", String.valueOf(bean.isPass())}};
        }

        public void mapResultSet(ResultSet res, Mock bean) throws Exception {
            bean.setName(res.getString("name"));
            bean.setPass(res.getBoolean("pass"));
            Calendar calendar = Calendar.getInstance();
            res.getDate("start", calendar);
            bean.setStart(calendar);
            bean.setStatus(res.getInt("status"));
        }

        public void mapUpdate(Mock bean, PreparedStatement statement) throws Exception {
            statement.setString(1, bean.getName());
            statement.setInt(2, bean.getStatus());
            statement.setDate(3, new Date(bean.getStart().getTimeInMillis()));
            statement.setBoolean(4, bean.isPass());
        }
    }
}

