/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.database.DBTableManager;
import org.exoplatform.services.database.DatabaseService;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.Mock;
import org.exoplatform.services.database.impl.XAPoolTxSupportDatabaseService;
import org.exoplatform.services.database.table.ExoLongID;
import org.exoplatform.services.database.table.IDGenerator;
import org.exoplatform.services.transaction.TransactionService;

public class TestDatabaseService
extends TestCase {
    public void testDatabaseService() throws Exception {
        PortalContainer pcontainer = PortalContainer.getInstance();
        DatabaseService service = (DatabaseService)pcontainer.getComponentInstanceOfType(XAPoolTxSupportDatabaseService.class);
        TestDatabaseService.assertNotNull((Object)service);
        this.assertConfiguration(service);
        this.assertDBTableManager(service);
        this.assertIDGenerator(service);
    }

    private void assertConfiguration(DatabaseService service) throws Exception {
        TransactionService txservice = service.getTransactionService();
        TestDatabaseService.assertTrue((service != null ? 1 : 0) != 0);
        UserTransaction utx = txservice.getUserTransaction();
        Connection conn = service.getConnection();
        Statement s = null;
        utx.begin();
        try {
            s = conn.createStatement();
            s.addBatch("create table test (name varchar(25), data varchar(25))");
            s.addBatch("insert into test values('name1', 'value1')");
            s.executeBatch();
            s.close();
            conn.commit();
            utx.commit();
        }
        catch (Exception ex) {
            utx.rollback();
        }
        service.closeConnection(conn);
        conn = service.getConnection();
        s = conn.createStatement();
        ResultSet rs = s.executeQuery("select name from test");
        if (rs.next()) {
            TestDatabaseService.fail((String)"Should not have any data in the test table");
        }
    }

    private void assertDBTableManager(DatabaseService service) throws Exception {
        ExoDatasource datasource = service.getDatasource();
        DBTableManager dbManager = datasource.getDBTableManager();
        TestDatabaseService.assertEquals((boolean)dbManager.hasTable(Mock.class), (boolean)false);
        dbManager.createTable(Mock.class, true);
        TestDatabaseService.assertEquals((boolean)dbManager.hasTable(Mock.class), (boolean)true);
        dbManager.dropTable(Mock.class);
        TestDatabaseService.assertEquals((boolean)dbManager.hasTable(Mock.class), (boolean)false);
    }

    private void assertIDGenerator(DatabaseService service) throws Exception {
        ExoDatasource datasource = service.getDatasource();
        IDGenerator idGenerator = new IDGenerator(datasource);
        for (int i = 0; i < 10; ++i) {
            idGenerator.generateLongId(ExoLongID.class);
        }
        idGenerator.restartTracker();
        idGenerator.generateLongId(ExoLongID.class);
    }
}

