/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import io.meeds.deeds.elasticsearch.model.DeedTenantEvent;
import io.meeds.deeds.listener.EventListener;
import io.meeds.deeds.listerner.model.Event;
import io.meeds.deeds.listerner.model.EventSerialization;
import io.meeds.deeds.redis.RedisConfigurationProperties;
import io.meeds.deeds.service.SettingService;
import io.meeds.deeds.storage.DeedTenantEventRepository;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ListenerService
implements ApplicationContextAware {
    public static final String ES_LAST_SCANNED_DATE_SETTING_NAME = "ES-LAST-SCANNED-DATE";
    public static final Logger LOG = LoggerFactory.getLogger(ListenerService.class);
    protected StatefulRedisPubSubConnection<String, String> subscriptionConnection;
    protected StatefulRedisPubSubConnection<String, String> publicationConnection;
    @Autowired
    private RedisConfigurationProperties redisProperties;
    @Autowired(required=false)
    private RedisClient redisClient;
    @Autowired
    private SettingService settingService;
    @Autowired
    private DeedTenantEventRepository deedTenantEventRepository;
    @Value(value="${meeds.elasticsearch.listener.events.cleanupHoursPeriodicity:}")
    private String cleanupHoursPeriodicity;
    private ApplicationContext applicationContext;
    private List<EventListener<?>> eventListeners = new ArrayList();
    private Map<String, List<EventListener<?>>> listeners;
    private StampedLock elasticsearchEventReadingLock = new StampedLock();
    private String clientName;

    public void publishEvent(String eventName, Object data) {
        LOG.debug("{} - Publish event {} locally with data {}", new Object[]{this.getClientName(), eventName, data});
        Event event = new Event(eventName, data, data == null ? null : data.getClass().getName());
        this.triggerEventLocally(event);
        DeedTenantEvent persistentEvent = this.publishEventOnElasticsearch(event);
        this.publishEventOnRedis(persistentEvent.getId(), eventName);
    }

    public void addListener(EventListener<?> listener) {
        List<String> supportedEvents = listener.getSupportedEvents();
        if (!CollectionUtils.isEmpty(supportedEvents)) {
            supportedEvents.forEach(eventName -> this.getListeners().computeIfAbsent((String)eventName, key -> new ArrayList()).add(listener));
        }
    }

    public void removeListsner(String listenerName) {
        Iterator<Map.Entry<String, List<EventListener<?>>>> iterator = this.getListeners().entrySet().iterator();
        iterator.forEachRemaining(entry -> {
            List list = (List)entry.getValue();
            list.removeIf(eventListener -> StringUtils.equals((CharSequence)eventListener.getName(), (CharSequence)listenerName));
            if (list.isEmpty()) {
                iterator.remove();
            }
        });
    }

    public void removeListsner(String eventName, String listenerName) {
        Iterator<Map.Entry<String, List<EventListener<?>>>> iterator = this.getListeners().entrySet().iterator();
        iterator.forEachRemaining(entry -> {
            if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)eventName)) {
                return;
            }
            List list = (List)entry.getValue();
            list.removeIf(eventListener -> StringUtils.equals((CharSequence)eventListener.getName(), (CharSequence)listenerName));
            if (list.isEmpty()) {
                iterator.remove();
            }
        });
    }

    public void triggerElasticSearchEvents() {
        this.executeElasticSearchScanning(() -> {
            Instant lastEventScanDate = this.getLastELasticsearchScanDate();
            List<DeedTenantEvent> events = this.deedTenantEventRepository.findByDateGreaterThanEqualAndConsumersNotOrderByDateAsc(lastEventScanDate, this.getClientName());
            try {
                for (DeedTenantEvent persistentEvent : events) {
                    if (this.hasListeners(persistentEvent.getEventName())) {
                        this.triggerElasticsearchEvent(persistentEvent);
                    }
                    lastEventScanDate = this.maxInstant(lastEventScanDate, persistentEvent.getDate());
                }
            }
            finally {
                this.saveLastELasticsearchScanDate(lastEventScanDate);
            }
        });
    }

    public void cleanupElasticsearchEvents() {
        if (StringUtils.isNotBlank((CharSequence)this.cleanupHoursPeriodicity)) {
            Instant lastEventScanDate = this.getLastELasticsearchScanDate();
            this.deedTenantEventRepository.deleteByDateLessThan(lastEventScanDate.minus(Long.parseLong(this.cleanupHoursPeriodicity.trim()), ChronoUnit.HOURS));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    protected void init() {
        this.destroy();
        this.clientName = this.redisProperties.getClientName();
        this.initRedisSubscription();
    }

    @PreDestroy
    protected void destroy() {
        if (this.subscriptionConnection != null && this.subscriptionConnection.isOpen()) {
            this.subscriptionConnection.close();
            this.subscriptionConnection = null;
        }
        if (this.publicationConnection != null && this.publicationConnection.isOpen()) {
            this.publicationConnection.close();
            this.publicationConnection = null;
        }
    }

    private void triggerEventFromRedis(Map<String, String> redisEvent) {
        if (!MapUtils.isEmpty(redisEvent)) {
            this.executeElasticSearchScanning(() -> redisEvent.forEach((eventId, eventName) -> {
                if (this.hasListeners((String)eventName)) {
                    this.triggerElasticsearchEvent((String)eventId);
                }
            }));
        }
    }

    private void publishEventOnRedis(String eventId, String eventName) {
        try {
            RedisPubSubAsyncCommands async = this.getPublicationConnection().async();
            String eventJsonString = this.serializeObjectToJson(Collections.singletonMap(eventId, eventName));
            RedisFuture publish = async.publish((Object)this.getChannelName(), (Object)eventJsonString);
            if (publish == null) {
                throw new IllegalStateException("Redis returned null publication event");
            }
            if (StringUtils.isNotBlank((CharSequence)publish.getError())) {
                throw new IllegalStateException("Redis returned an error while publishing event: " + publish.getError());
            }
        }
        catch (Exception e) {
            LOG.trace("{} - Redis connection failure, event {}/{} will not be triggered remotely instantly", new Object[]{this.getClientName(), eventName, eventId, e});
        }
    }

    private DeedTenantEvent publishEventOnElasticsearch(Event event) {
        String eventJsonString = this.serializeObjectToJson(event);
        List<String> consumers = Collections.singletonList(this.getClientName());
        return (DeedTenantEvent)this.deedTenantEventRepository.save(new DeedTenantEvent(event.getEventName(), eventJsonString, consumers, Instant.now()));
    }

    private void triggerEventLocally(Event event) {
        String eventName = event.getEventName();
        Object data = event.getData();
        List<EventListener<?>> listenerList = this.getListeners().get(eventName);
        if (!CollectionUtils.isEmpty(listenerList)) {
            LOG.debug("{} - Trigger event {} locally with data {}", new Object[]{this.getClientName(), eventName, data});
            listenerList.forEach(listener -> {
                LOG.debug("  {} - Trigger listener {}  with event {} with data {}", new Object[]{this.getClientName(), listener.getName(), eventName, data});
                listener.handleEvent(eventName, data);
            });
        }
    }

    protected Map<String, List<EventListener<?>>> getListeners() {
        if (this.listeners == null) {
            this.registerListeners();
        }
        return this.listeners;
    }

    private synchronized void registerListeners() {
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        Map eventListenerBeans = this.applicationContext.getBeansOfType(EventListener.class);
        for (EventListener eventListener : eventListenerBeans.values()) {
            this.eventListeners.add(eventListener);
        }
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            this.eventListeners.forEach(this::addListener);
        }
    }

    private void triggerElasticsearchEvent(String persistentEventId) {
        DeedTenantEvent persistentEvent = this.deedTenantEventRepository.findById(persistentEventId).orElse(null);
        if (persistentEvent != null) {
            this.triggerElasticsearchEvent(persistentEvent);
        }
    }

    private void triggerElasticsearchEvent(DeedTenantEvent persistentEvent) {
        if (persistentEvent.getConsumers().contains(this.getClientName())) {
            return;
        }
        try {
            Event event = (Event)EventSerialization.OBJECT_MAPPER.readValue(persistentEvent.getObjectJson(), Event.class);
            if (event == null) {
                LOG.debug("Can't parse Event Class of name {}. Ignore the event, it should be meant to another type of clients", (Object)persistentEvent.getEventName());
            } else {
                this.triggerEventLocally(event);
            }
            this.addElasticsearchEventCurrentConsumer(persistentEvent);
        }
        catch (Exception e) {
            LOG.warn("{} - Error while triggering event from ES {}", new Object[]{this.getClientName(), persistentEvent, e});
        }
    }

    private void addElasticsearchEventCurrentConsumer(DeedTenantEvent event) {
        try {
            event = this.deedTenantEventRepository.findById(event.getId()).orElse(event);
            ArrayList<String> consumers = CollectionUtils.isEmpty(event.getConsumers()) ? new ArrayList<String>() : new ArrayList<String>(event.getConsumers());
            consumers.add(this.getClientName());
            event.setConsumers(consumers);
            this.deedTenantEventRepository.save(event);
        }
        catch (Exception e) {
            LOG.warn("{} - Error saving consumer name of event {}/{}", new Object[]{this.getClientName(), event.getId(), event.getEventName()});
        }
    }

    private Instant getLastELasticsearchScanDate() {
        String settingName = this.getSettingName(ES_LAST_SCANNED_DATE_SETTING_NAME);
        String lastEventScanDate = this.settingService.get(settingName);
        if (StringUtils.isBlank((CharSequence)lastEventScanDate)) {
            return Instant.now();
        }
        return Instant.ofEpochMilli(Long.parseLong(lastEventScanDate));
    }

    private void saveLastELasticsearchScanDate(Instant persistedEventDate) {
        String settingName = this.getSettingName(ES_LAST_SCANNED_DATE_SETTING_NAME);
        this.settingService.save(settingName, String.valueOf(persistedEventDate.toEpochMilli()));
    }

    private StatefulRedisPubSubConnection<String, String> getPublicationConnection() {
        if (this.publicationConnection == null || !this.publicationConnection.isOpen()) {
            this.publicationConnection = this.redisClient.connectPubSub();
        }
        return this.publicationConnection;
    }

    private void initRedisSubscription() {
        try {
            if (this.subscriptionConnection != null && this.subscriptionConnection.isOpen()) {
                return;
            }
            this.subscriptionConnection = this.redisClient.connectPubSub();
            this.subscriptionConnection.addListener((RedisPubSubListener)new RedisPubSubAdapter<String, String>(){

                public void message(String channel, String message) {
                    try {
                        Map event = (Map)EventSerialization.OBJECT_MAPPER.readValue(message, Map.class);
                        ListenerService.this.triggerEventFromRedis(event);
                    }
                    catch (Exception e) {
                        LOG.warn("{} - An error occurred while triggering an event published from Redis: {}", new Object[]{ListenerService.this.getClientName(), message, e});
                    }
                }

                public void message(String pattern, String channel, String message) {
                    this.message(channel, message);
                }
            });
            this.subscriptionConnection.async().subscribe((Object[])new String[]{this.getChannelName()});
        }
        catch (Exception e) {
            LOG.warn("{} - Redis connection failure: {}. Events will not be triggered remotely instantly.", (Object)this.getClientName(), (Object)e.getMessage());
        }
    }

    private boolean hasListeners(String eventName) {
        return !CollectionUtils.isEmpty((Collection)this.getListeners().get(eventName));
    }

    private String serializeObjectToJson(Object event) {
        try {
            return EventSerialization.OBJECT_MAPPER.writeValueAsString(event);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("An error occurred while parsing POJO object to JSON:" + event, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeElasticSearchScanning(Runnable task) {
        try {
            long stamp = this.elasticsearchEventReadingLock.tryWriteLock(3L, TimeUnit.SECONDS);
            try {
                task.run();
            }
            finally {
                this.elasticsearchEventReadingLock.unlock(stamp);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private Instant maxInstant(Instant instant1, Instant instant2) {
        if (instant1.isBefore(instant2)) {
            instant1 = instant2;
        }
        return instant1;
    }

    private String getSettingName(String settingPrefix) {
        return settingPrefix + "-" + this.getClientName();
    }

    private String getChannelName() {
        return this.redisProperties.getChannelName();
    }

    private String getClientName() {
        return this.clientName;
    }
}

