/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.elasticsearch;

import io.meeds.deeds.elasticsearch.model.DeedMetadata;
import io.meeds.deeds.elasticsearch.model.DeedSetting;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.elasticsearch.model.DeedTenantEvent;
import io.meeds.deeds.elasticsearch.model.UserProfile;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.RestClients;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.cluster.ClusterHealth;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;

@Configuration
@EnableElasticsearchRepositories(basePackages={"io.meeds"})
public class ElasticSearchConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchConfig.class);
    @Value(value="${meeds.elasticsearch.username:}")
    private String esUsername;
    @Value(value="${meeds.elasticsearch.password:}")
    private String esPassword;
    @Value(value="${meeds.elasticsearch.url:http://127.0.0.1:9200}")
    private String esUrl;
    @Value(value="${meeds.elasticsearch.socketTimeout:20}")
    private int socketTimeout;
    @Value(value="${meeds.elasticsearch.connectTimeout:20}")
    private int connectionTimeout;
    @Value(value="${meeds.elasticsearch.connectionRetry:30}")
    private int connectionRetry;
    @Value(value="${meeds.elasticsearch.autoCreateIndex:true}")
    private boolean createDeedIndexes;

    @Bean
    public RestHighLevelClient client() {
        ClientConfiguration.ClientConfigurationBuilderWithRequiredEndpoint builder = ClientConfiguration.builder();
        String hostAndPort = this.esUrl.split("//")[1];
        ClientConfiguration.MaybeSecureClientConfigurationBuilder connectionBuilder = builder.connectedTo(hostAndPort);
        if (this.esUrl.contains("https://")) {
            connectionBuilder.usingSsl();
        }
        if (StringUtils.isNotBlank((CharSequence)this.esPassword) && StringUtils.isNotBlank((CharSequence)this.esUsername)) {
            connectionBuilder.withBasicAuth(this.esUsername, this.esPassword);
        }
        connectionBuilder.withConnectTimeout(Duration.ofSeconds(this.connectionTimeout));
        connectionBuilder.withSocketTimeout(Duration.ofSeconds(this.socketTimeout));
        ClientConfiguration clientConfiguration = connectionBuilder.build();
        return RestClients.create((ClientConfiguration)clientConfiguration).rest();
    }

    @Bean
    public ElasticsearchOperations elasticsearchTemplate(RestHighLevelClient client) {
        ElasticsearchRestTemplate elasticsearchTemplate = new ElasticsearchRestTemplate(client);
        this.tryConnection(elasticsearchTemplate);
        if (this.createDeedIndexes) {
            this.createIndex(elasticsearchTemplate, DeedSetting.class);
            this.createIndex(elasticsearchTemplate, DeedTenant.class);
            this.createIndex(elasticsearchTemplate, DeedMetadata.class);
            this.createIndex(elasticsearchTemplate, DeedTenantEvent.class);
            this.createIndex(elasticsearchTemplate, UserProfile.class);
        }
        return elasticsearchTemplate;
    }

    private void tryConnection(ElasticsearchRestTemplate elasticsearchTemplate) {
        int i = this.connectionRetry;
        while (i-- > 0) {
            int tentative = this.connectionRetry - i;
            try {
                ClusterHealth elasticHealth = elasticsearchTemplate.cluster().health();
                if (elasticHealth.isTimedOut() || elasticHealth.getActiveShardsPercent() < 1.0 || elasticHealth.getActiveShards() == 0) {
                    throw new IllegalStateException("Elasticsearch Cluster Health Check TimedOut. Active shard = " + elasticHealth.getActiveShards() + ". Percentage = " + elasticHealth.getActiveShardsPercent());
                }
                LOG.info("Connection established to ES after {}/{} tentatives", (Object)tentative, (Object)this.connectionRetry);
                i = 0;
            }
            catch (Exception e) {
                if (i == 0) {
                    LOG.warn("Connection failure to ES. tentative {}/{}.", (Object)tentative, (Object)this.connectionRetry);
                    continue;
                }
                LOG.info("Connection failure to ES. tentative {}/{}. Error Message: {}", new Object[]{tentative, this.connectionRetry, e.getMessage()});
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void createIndex(ElasticsearchRestTemplate elasticsearchTemplate, Class<?> esDocumentModelClass) {
        IndexOperations indexOperations = elasticsearchTemplate.indexOps(esDocumentModelClass);
        boolean indexExists = indexOperations.exists();
        if (!indexExists) {
            indexOperations.createWithMapping();
        }
    }
}

