/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.constant.TenantProvisioningStatus;
import io.meeds.deeds.common.constant.UnauthorizedOperationException;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.elasticsearch.storage.DeedTenantManagerRepository;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.service.TenantService;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={TenantService.class})
class TenantServiceTest {
    @MockBean
    private BlockchainService blockchainService;
    @MockBean
    private DeedTenantManagerRepository deedTenantManagerRepository;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private TenantService tenantService;

    TenantServiceTest() {
    }

    @Test
    void testGetDeedTenant() throws Exception {
        long nftId = 1L;
        DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        DeedTenant deedTenant = this.tenantService.getDeedTenant(nftId);
        Assertions.assertNotNull((Object)deedTenant);
        Assertions.assertEquals((Object)deedTenantMock, (Object)deedTenant);
    }

    @Test
    void testGetDeedTenantByAddress() throws Exception {
        long nftId = 1L;
        String address = "address";
        Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.tenantService.getDeedTenant(address, nftId));
    }

    @Test
    void testGetDeedTenantByManager() throws Exception {
        long nftId = 1L;
        String address = "address";
        DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(address, nftId)).thenReturn((Object)true);
        DeedTenant deedTenant = this.tenantService.getDeedTenant(address, nftId);
        Assertions.assertEquals((Object)deedTenantMock, (Object)deedTenant);
    }

    @Test
    void testGetDeedTenantByOwner() throws Exception {
        long nftId = 1L;
        String address = "address";
        DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        Mockito.when((Object)this.blockchainService.isDeedOwner(address, nftId)).thenReturn((Object)true);
        DeedTenant deedTenant = this.tenantService.getDeedTenant(address, nftId);
        Assertions.assertEquals((Object)deedTenantMock, (Object)deedTenant);
    }

    @Test
    void testGetDeedTenantOrImportByManagerWhenExists() throws Exception {
        long nftId = 1L;
        String address = "address";
        DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        Mockito.when((Object)this.deedTenantManagerRepository.save((Object)((DeedTenant)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0, DeedTenant.class));
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(address, nftId)).thenReturn((Object)true);
        DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(address, Long.valueOf(nftId));
        Assertions.assertEquals((Object)deedTenantMock, (Object)deedTenant);
        Assertions.assertEquals((Object)address, (Object)deedTenant.getManagerAddress());
        Assertions.assertNull((Object)deedTenant.getOwnerAddress());
    }

    void testGetDeedTenantOrImportByOwnerWhenExists() throws Exception {
        long nftId = 1L;
        String address = "address";
        DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        Mockito.when((Object)this.deedTenantManagerRepository.save((Object)((DeedTenant)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0, DeedTenant.class));
        Mockito.when((Object)this.blockchainService.isDeedOwner(address, nftId)).thenReturn((Object)true);
        DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(address, Long.valueOf(nftId));
        Assertions.assertEquals((Object)deedTenantMock, (Object)deedTenant);
        Assertions.assertEquals((Object)address, (Object)deedTenant.getOwnerAddress());
        Assertions.assertNull((Object)deedTenant.getManagerAddress());
    }

    @Test
    void testGetDeedTenantOrImportByManagerWhenNotExists() throws Exception {
        final long nftId = 1L;
        String address = "address";
        final short cardType = 2;
        final short cityIndex = 3;
        DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        deedTenantMock.setManagerAddress(address);
        deedTenantMock.setCardType(cardType);
        deedTenantMock.setCityIndex(cityIndex);
        Mockito.when((Object)this.blockchainService.getDeedCardType(nftId)).thenReturn((Object)cardType);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(nftId)).thenReturn((Object)cityIndex);
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(address, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.deedTenantManagerRepository.save((Object)((DeedTenant)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0, DeedTenant.class));
        DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(address, Long.valueOf(nftId));
        ((DeedTenantManagerRepository)Mockito.verify((Object)this.deedTenantManagerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenant)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenant>(){

            public boolean matches(DeedTenant deedTenant) {
                Assertions.assertNotNull((Object)deedTenant);
                Assertions.assertEquals((long)nftId, (long)deedTenant.getNftId());
                Assertions.assertEquals((short)cardType, (short)deedTenant.getCardType());
                Assertions.assertEquals((short)cityIndex, (short)deedTenant.getCityIndex());
                Assertions.assertNull((Object)deedTenant.getManagerEmail());
                Assertions.assertNull((Object)deedTenant.getStartupTransactionHash());
                Assertions.assertNull((Object)deedTenant.getShutdownTransactionHash());
                Assertions.assertNull((Object)deedTenant.getDate());
                return true;
            }
        })));
        Assertions.assertNotNull((Object)deedTenant);
        Assertions.assertEquals((Object)address, (Object)deedTenant.getManagerAddress());
        Assertions.assertNull((Object)deedTenant.getOwnerAddress());
    }

    @Test
    void testGetDeedTenantOrImportByOwnerWhenNotExists() throws Exception {
        final long nftId = 1L;
        String address = "address";
        final short cardType = 2;
        final short cityIndex = 3;
        DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        deedTenantMock.setCardType(cardType);
        deedTenantMock.setCityIndex(cityIndex);
        Mockito.when((Object)this.blockchainService.getDeedCardType(nftId)).thenReturn((Object)cardType);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(nftId)).thenReturn((Object)cityIndex);
        Mockito.when((Object)this.blockchainService.isDeedOwner(address, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.deedTenantManagerRepository.save((Object)((DeedTenant)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0, DeedTenant.class));
        DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(address, Long.valueOf(nftId));
        ((DeedTenantManagerRepository)Mockito.verify((Object)this.deedTenantManagerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenant)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenant>(){

            public boolean matches(DeedTenant deedTenant) {
                Assertions.assertNotNull((Object)deedTenant);
                Assertions.assertEquals((long)nftId, (long)deedTenant.getNftId());
                Assertions.assertEquals((short)cardType, (short)deedTenant.getCardType());
                Assertions.assertEquals((short)cityIndex, (short)deedTenant.getCityIndex());
                Assertions.assertNull((Object)deedTenant.getManagerEmail());
                Assertions.assertNull((Object)deedTenant.getStartupTransactionHash());
                Assertions.assertNull((Object)deedTenant.getShutdownTransactionHash());
                Assertions.assertNull((Object)deedTenant.getDate());
                return true;
            }
        })));
        Assertions.assertNotNull((Object)deedTenant);
        Assertions.assertEquals((Object)address, (Object)deedTenant.getOwnerAddress());
        Assertions.assertNull((Object)deedTenant.getManagerAddress());
    }

    @Test
    void testGetDeedTenantOrImportByChangedOwner() throws Exception {
        long nftId = 1L;
        String address = "address";
        String otherAddress = "anotherAddress";
        short cardType = 2;
        short cityIndex = 3;
        Mockito.when((Object)this.blockchainService.getDeedCardType(nftId)).thenReturn((Object)cardType);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(nftId)).thenReturn((Object)cityIndex);
        DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        deedTenantMock.setManagerAddress(otherAddress);
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(address, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.deedTenantManagerRepository.save((Object)((DeedTenant)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0, DeedTenant.class));
        DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(address, Long.valueOf(nftId));
        Assertions.assertNotNull((Object)deedTenant);
        Assertions.assertEquals((Object)address, (Object)deedTenant.getManagerAddress());
        ((DeedTenantManagerRepository)Mockito.verify((Object)this.deedTenantManagerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)deedTenant);
    }

    @Test
    void testGetDeedTenantOrImportByChangedManager() throws Exception {
        long nftId = 1L;
        String address = "address";
        String otherAddress = "anotherAddress";
        short cardType = 2;
        short cityIndex = 3;
        Mockito.when((Object)this.blockchainService.getDeedCardType(nftId)).thenReturn((Object)cardType);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(nftId)).thenReturn((Object)cityIndex);
        DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        deedTenantMock.setOwnerAddress(otherAddress);
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        Mockito.when((Object)this.blockchainService.isDeedOwner(address, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.deedTenantManagerRepository.save((Object)((DeedTenant)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0, DeedTenant.class));
        DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(address, Long.valueOf(nftId));
        Assertions.assertNotNull((Object)deedTenant);
        Assertions.assertEquals((Object)address, (Object)deedTenant.getOwnerAddress());
        ((DeedTenantManagerRepository)Mockito.verify((Object)this.deedTenantManagerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)deedTenant);
    }

    @Test
    void testStartTenantByOwnerNotManager() throws Exception {
        long nftId = 1L;
        String address = "address";
        String transactionHash = "transactionHash";
        String email = "email";
        Mockito.lenient().when((Object)this.blockchainService.isDeedOwner(address, nftId)).thenReturn((Object)true);
        Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.tenantService.startTenant(address, transactionHash, nftId, email));
    }

    @Test
    void testStartTenantByManagerWithExistingTenant() throws Exception {
        long nftId = 1L;
        final short cardType = 2;
        final short cityIndex = 3;
        String managerAddress = "managerAddress";
        String transactionHash = "transactionHash";
        String email = "email";
        final DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        deedTenantMock.setManagerAddress(managerAddress);
        deedTenantMock.setManagerEmail(email);
        deedTenantMock.setStartupTransactionHash(transactionHash);
        deedTenantMock.setShutdownTransactionHash(transactionHash);
        deedTenantMock.setDate(LocalDateTime.now(ZoneOffset.UTC));
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(managerAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCardType(nftId)).thenReturn((Object)cardType);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(nftId)).thenReturn((Object)cityIndex);
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        this.tenantService.startTenant(managerAddress, transactionHash, nftId, email);
        ((DeedTenantManagerRepository)Mockito.verify((Object)this.deedTenantManagerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenant)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenant>(){

            public boolean matches(DeedTenant deedTenant) {
                Assertions.assertNotNull((Object)deedTenant);
                Assertions.assertNotNull((Object)deedTenant.getDate());
                Assertions.assertTrue((Duration.between(deedTenant.getDate(), deedTenantMock.getDate()).getSeconds() <= 5L ? 1 : 0) != 0);
                Assertions.assertEquals((long)deedTenantMock.getNftId(), (long)deedTenant.getNftId());
                Assertions.assertEquals((Object)deedTenantMock.getManagerAddress().toLowerCase(), (Object)deedTenant.getManagerAddress().toLowerCase());
                Assertions.assertEquals((short)cardType, (short)deedTenant.getCardType());
                Assertions.assertEquals((short)cityIndex, (short)deedTenant.getCityIndex());
                Assertions.assertEquals((Object)deedTenantMock.getManagerEmail(), (Object)deedTenant.getManagerEmail());
                Assertions.assertEquals((Object)deedTenantMock.getStartupTransactionHash().toLowerCase(), (Object)deedTenant.getStartupTransactionHash().toLowerCase());
                Assertions.assertNull((Object)deedTenant.getShutdownTransactionHash());
                return true;
            }
        })));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.tenantStart"), ArgumentMatchers.any());
    }

    @Test
    void testStartTenantByManager() throws Exception {
        long nftId = 1L;
        short cardType = 2;
        short cityIndex = 3;
        String managerAddress = "managerAddress";
        String transactionHash = "transactionHash";
        String email = "email";
        final DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        deedTenantMock.setManagerAddress(managerAddress);
        deedTenantMock.setCardType(cardType);
        deedTenantMock.setCityIndex(cityIndex);
        deedTenantMock.setManagerEmail(email);
        deedTenantMock.setStartupTransactionHash(transactionHash);
        deedTenantMock.setShutdownTransactionHash(transactionHash);
        deedTenantMock.setDate(LocalDateTime.now(ZoneOffset.UTC));
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(managerAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCardType(nftId)).thenReturn((Object)cardType);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(nftId)).thenReturn((Object)cityIndex);
        this.tenantService.startTenant(managerAddress, transactionHash, nftId, email);
        ((DeedTenantManagerRepository)Mockito.verify((Object)this.deedTenantManagerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenant)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenant>(){

            public boolean matches(DeedTenant deedTenant) {
                Assertions.assertNotNull((Object)deedTenant);
                Assertions.assertNotNull((Object)deedTenant.getDate());
                Assertions.assertTrue((Duration.between(deedTenant.getDate(), deedTenantMock.getDate()).getSeconds() <= 5L ? 1 : 0) != 0);
                Assertions.assertEquals((long)deedTenantMock.getNftId(), (long)deedTenant.getNftId());
                Assertions.assertEquals((Object)deedTenantMock.getManagerAddress().toLowerCase(), (Object)deedTenant.getManagerAddress().toLowerCase());
                Assertions.assertEquals((short)deedTenantMock.getCardType(), (short)deedTenant.getCardType());
                Assertions.assertEquals((short)deedTenantMock.getCityIndex(), (short)deedTenant.getCityIndex());
                Assertions.assertEquals((Object)deedTenantMock.getManagerEmail(), (Object)deedTenant.getManagerEmail());
                Assertions.assertEquals((Object)deedTenantMock.getStartupTransactionHash().toLowerCase(), (Object)deedTenant.getStartupTransactionHash().toLowerCase());
                Assertions.assertNull((Object)deedTenant.getShutdownTransactionHash());
                return true;
            }
        })));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.tenantStart"), ArgumentMatchers.any());
    }

    @Test
    void testStopTenantByOwnerNotManager() throws Exception {
        long nftId = 1L;
        String address = "address";
        String transactionHash = "transactionHash";
        Mockito.lenient().when((Object)this.blockchainService.isDeedOwner(address, nftId)).thenReturn((Object)true);
        Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.tenantService.stopTenant(address, transactionHash, nftId));
    }

    @Test
    void testStopTenantByManagerWithExistingTenant() throws Exception {
        long nftId = 1L;
        final short cardType = 2;
        final short cityIndex = 3;
        String managerAddress = "managerAddress";
        String transactionHash = "transactionHash";
        final DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        deedTenantMock.setManagerAddress(managerAddress);
        deedTenantMock.setStartupTransactionHash(transactionHash);
        deedTenantMock.setShutdownTransactionHash(transactionHash);
        deedTenantMock.setDate(LocalDateTime.now(ZoneOffset.UTC));
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(managerAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCardType(nftId)).thenReturn((Object)cardType);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(nftId)).thenReturn((Object)cityIndex);
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        this.tenantService.stopTenant(managerAddress, transactionHash, nftId);
        ((DeedTenantManagerRepository)Mockito.verify((Object)this.deedTenantManagerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenant)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenant>(){

            public boolean matches(DeedTenant deedTenant) {
                Assertions.assertNotNull((Object)deedTenant);
                Assertions.assertNotNull((Object)deedTenant.getDate());
                Assertions.assertTrue((Duration.between(deedTenant.getDate(), deedTenantMock.getDate()).getSeconds() <= 5L ? 1 : 0) != 0);
                Assertions.assertEquals((long)deedTenantMock.getNftId(), (long)deedTenant.getNftId());
                Assertions.assertEquals((Object)deedTenantMock.getManagerAddress().toLowerCase(), (Object)deedTenant.getManagerAddress().toLowerCase());
                Assertions.assertEquals((short)cardType, (short)deedTenant.getCardType());
                Assertions.assertEquals((short)cityIndex, (short)deedTenant.getCityIndex());
                Assertions.assertEquals((Object)deedTenantMock.getManagerEmail(), (Object)deedTenant.getManagerEmail());
                Assertions.assertEquals((Object)deedTenantMock.getShutdownTransactionHash().toLowerCase(), (Object)deedTenant.getShutdownTransactionHash().toLowerCase());
                Assertions.assertNull((Object)deedTenant.getStartupTransactionHash());
                return true;
            }
        })));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.tenantStop"), ArgumentMatchers.any());
    }

    @Test
    void testStopTenantByManager() throws Exception {
        long nftId = 1L;
        short cardType = 2;
        short cityIndex = 3;
        String managerAddress = "managerAddress";
        String transactionHash = "transactionHash";
        final DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        deedTenantMock.setManagerAddress(managerAddress);
        deedTenantMock.setCardType(cardType);
        deedTenantMock.setCityIndex(cityIndex);
        deedTenantMock.setStartupTransactionHash(transactionHash);
        deedTenantMock.setShutdownTransactionHash(transactionHash);
        deedTenantMock.setDate(LocalDateTime.now(ZoneOffset.UTC));
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(managerAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCardType(nftId)).thenReturn((Object)cardType);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(nftId)).thenReturn((Object)cityIndex);
        this.tenantService.stopTenant(managerAddress, transactionHash, nftId);
        ((DeedTenantManagerRepository)Mockito.verify((Object)this.deedTenantManagerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenant)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenant>(){

            public boolean matches(DeedTenant deedTenant) {
                Assertions.assertNotNull((Object)deedTenant);
                Assertions.assertNotNull((Object)deedTenant.getDate());
                Assertions.assertTrue((Duration.between(deedTenant.getDate(), deedTenantMock.getDate()).getSeconds() <= 5L ? 1 : 0) != 0);
                Assertions.assertEquals((long)deedTenantMock.getNftId(), (long)deedTenant.getNftId());
                Assertions.assertEquals((Object)deedTenantMock.getManagerAddress().toLowerCase(), (Object)deedTenant.getManagerAddress().toLowerCase());
                Assertions.assertEquals((short)deedTenantMock.getCardType(), (short)deedTenant.getCardType());
                Assertions.assertEquals((short)deedTenantMock.getCityIndex(), (short)deedTenant.getCityIndex());
                Assertions.assertEquals((Object)deedTenantMock.getManagerEmail(), (Object)deedTenant.getManagerEmail());
                Assertions.assertEquals((Object)deedTenantMock.getShutdownTransactionHash().toLowerCase(), (Object)deedTenant.getShutdownTransactionHash().toLowerCase());
                Assertions.assertNull((Object)deedTenant.getStartupTransactionHash());
                return true;
            }
        })));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.tenantStop"), ArgumentMatchers.any());
    }

    @Test
    void testSaveEmailByTenantOwnerNotManager() throws Exception {
        long nftId = 1L;
        String address = "address";
        String email = "email";
        Mockito.lenient().when((Object)this.blockchainService.isDeedOwner(address, nftId)).thenReturn((Object)true);
        Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.tenantService.saveEmail(address, nftId, email));
    }

    @Test
    void testIsTenantCommandStop() {
        long nftId = 1L;
        Assertions.assertTrue((boolean)this.tenantService.isTenantCommandStop(nftId));
        DeedTenant deedTenantMock = (DeedTenant)Mockito.mock(DeedTenant.class);
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        Assertions.assertTrue((boolean)this.tenantService.isTenantCommandStop(nftId));
        Mockito.when((Object)deedTenantMock.getTenantProvisioningStatus()).thenReturn((Object)TenantProvisioningStatus.START_CONFIRMED);
        Assertions.assertFalse((boolean)this.tenantService.isTenantCommandStop(nftId));
        Mockito.when((Object)deedTenantMock.getTenantProvisioningStatus()).thenReturn((Object)TenantProvisioningStatus.START_IN_PROGRESS);
        Assertions.assertFalse((boolean)this.tenantService.isTenantCommandStop(nftId));
        Mockito.when((Object)deedTenantMock.getTenantProvisioningStatus()).thenReturn((Object)TenantProvisioningStatus.STOP_IN_PROGRESS);
        Assertions.assertFalse((boolean)this.tenantService.isTenantCommandStop(nftId));
        Mockito.when((Object)deedTenantMock.getTenantProvisioningStatus()).thenReturn((Object)TenantProvisioningStatus.STOP_CONFIRMED);
        Assertions.assertTrue((boolean)this.tenantService.isTenantCommandStop(nftId));
    }

    @Test
    void testSaveEmailByTenantManager() throws Exception {
        final long nftId = 1L;
        final short cardType = 2;
        final short cityIndex = 3;
        final String managerAddress = "managerAddress";
        final String transactionHash = "transactionHash";
        final String email = "email";
        final DeedTenant deedTenantMock = new DeedTenant();
        deedTenantMock.setNftId(nftId);
        deedTenantMock.setManagerAddress(managerAddress);
        deedTenantMock.setCardType(cardType);
        deedTenantMock.setCityIndex(cityIndex);
        deedTenantMock.setStartupTransactionHash(transactionHash);
        deedTenantMock.setShutdownTransactionHash(transactionHash);
        deedTenantMock.setDate(LocalDateTime.now(ZoneOffset.UTC));
        Mockito.when((Object)this.deedTenantManagerRepository.findById((Object)nftId)).thenReturn(Optional.of(deedTenantMock));
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(managerAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCardType(nftId)).thenReturn((Object)cardType);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(nftId)).thenReturn((Object)cityIndex);
        this.tenantService.saveEmail(managerAddress, nftId, email);
        ((DeedTenantManagerRepository)Mockito.verify((Object)this.deedTenantManagerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenant)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenant>(){

            public boolean matches(DeedTenant deedTenant) {
                Assertions.assertNotNull((Object)deedTenant);
                Assertions.assertNotNull((Object)deedTenant.getDate());
                Assertions.assertTrue((Duration.between(deedTenant.getDate(), deedTenantMock.getDate()).getSeconds() <= 5L ? 1 : 0) != 0);
                Assertions.assertEquals((long)nftId, (long)deedTenant.getNftId());
                Assertions.assertEquals((Object)managerAddress.toLowerCase(), (Object)deedTenant.getManagerAddress().toLowerCase());
                Assertions.assertEquals((short)cardType, (short)deedTenant.getCardType());
                Assertions.assertEquals((short)cityIndex, (short)deedTenant.getCityIndex());
                Assertions.assertEquals((Object)email, (Object)deedTenant.getManagerEmail());
                Assertions.assertEquals((Object)transactionHash, (Object)deedTenant.getStartupTransactionHash());
                Assertions.assertEquals((Object)transactionHash, (Object)deedTenant.getShutdownTransactionHash());
                return true;
            }
        })));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.tenantEmailUpdated"), ArgumentMatchers.any());
    }
}

