/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.blockchain;

import io.meeds.deeds.common.blockchain.BlockchainConfigurationProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={BlockchainConfigurationProperties.class})
@EnableConfigurationProperties(value={BlockchainConfigurationProperties.class})
@TestPropertySource(properties={"meeds.blockchain.networkUrl=NETWORK_URL", "meeds.blockchain.polygonNetworkUrl=POLYGON_NETWORK_URL", "meeds.blockchain.tenantProvisioningAddress=TENANT_PROVISIONING_ADDRESS", "meeds.blockchain.tenantRentingAddress=TENANT_RENTING_ADDRESS_VALUE", "meeds.blockchain.deedAddress=DEED_ADDRESS", "meeds.blockchain.meedAddress=MAINNET_MEED_ADDRESS", "meeds.blockchain.polygonMeedAddress=POLYGON_MEED_ADDRESS", "meeds.blockchain.xMeedAddress=X_MEED_ADDRESS_VALUE", "meeds.blockchain.tokenFactoryAddress=TOKEN_FACTORY_ADDRESS_VALUE", "meeds.blockchain.sushiPairAddress=SUSHI_PAIR_ADDRESS_VALUE", "meeds.blockchain.womAddress=WOM_ADDRESS_VALUE", "meeds.blockchain.uemAddress=UEM_ADDRESS_VALUE"})
class BlockchainConfigurationPropertiesTest {
    public static final String NETWORK_URL_VALUE = "NETWORK_URL";
    public static final String POLYGON_NETWORK_URL_VALUE = "POLYGON_NETWORK_URL";
    public static final String TENANT_PROVISIONING_ADDRESS_VALUE = "TENANT_PROVISIONING_ADDRESS";
    public static final String TENANT_RENTING_ADDRESS_VALUE = "TENANT_RENTING_ADDRESS_VALUE";
    public static final String DEED_ADDRESS_VALUE = "DEED_ADDRESS";
    public static final String MAINNET_MEED_ADDRESS_VALUE = "MAINNET_MEED_ADDRESS";
    public static final String POLYGON_MEED_ADDRESS_VALUE = "POLYGON_MEED_ADDRESS";
    public static final String X_MEED_ADDRESS_VALUE = "X_MEED_ADDRESS_VALUE";
    public static final String TOKEN_FACTORY_ADDRESS_VALUE = "TOKEN_FACTORY_ADDRESS_VALUE";
    public static final String SUSHI_PAIR_ADDRESS_VALUE = "SUSHI_PAIR_ADDRESS_VALUE";
    public static final String WOM_ADDRESS_VALUE = "WOM_ADDRESS_VALUE";
    public static final String UEM_ADDRESS_VALUE = "UEM_ADDRESS_VALUE";
    @Autowired
    private BlockchainConfigurationProperties blockchainConfigurationProperties;

    BlockchainConfigurationPropertiesTest() {
    }

    @Test
    void testProperties() {
        Assertions.assertNotNull((Object)this.blockchainConfigurationProperties);
        Assertions.assertEquals((Object)NETWORK_URL_VALUE, (Object)this.blockchainConfigurationProperties.getNetworkUrl());
        Assertions.assertEquals((Object)POLYGON_NETWORK_URL_VALUE, (Object)this.blockchainConfigurationProperties.getPolygonNetworkUrl());
        Assertions.assertEquals((Object)TENANT_PROVISIONING_ADDRESS_VALUE, (Object)this.blockchainConfigurationProperties.getTenantProvisioningAddress());
        Assertions.assertEquals((Object)DEED_ADDRESS_VALUE, (Object)this.blockchainConfigurationProperties.getDeedAddress());
        Assertions.assertEquals((Object)MAINNET_MEED_ADDRESS_VALUE, (Object)this.blockchainConfigurationProperties.getMeedAddress());
        Assertions.assertEquals((Object)POLYGON_MEED_ADDRESS_VALUE, (Object)this.blockchainConfigurationProperties.getPolygonMeedAddress());
        BlockchainConfigurationProperties properties = new BlockchainConfigurationProperties(NETWORK_URL_VALUE, POLYGON_NETWORK_URL_VALUE, TENANT_PROVISIONING_ADDRESS_VALUE, TENANT_RENTING_ADDRESS_VALUE, DEED_ADDRESS_VALUE, MAINNET_MEED_ADDRESS_VALUE, POLYGON_MEED_ADDRESS_VALUE, X_MEED_ADDRESS_VALUE, TOKEN_FACTORY_ADDRESS_VALUE, SUSHI_PAIR_ADDRESS_VALUE, WOM_ADDRESS_VALUE, UEM_ADDRESS_VALUE);
        Assertions.assertEquals((Object)properties, (Object)this.blockchainConfigurationProperties);
        Assertions.assertEquals((int)properties.hashCode(), (int)this.blockchainConfigurationProperties.hashCode());
        Assertions.assertEquals((Object)properties.toString(), (Object)this.blockchainConfigurationProperties.toString());
    }
}

