/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.model.DeedCity;
import io.meeds.deeds.common.model.FundInfo;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.contract.Deed;
import io.meeds.deeds.contract.DeedRenting;
import io.meeds.deeds.contract.DeedTenantProvisioning;
import io.meeds.deeds.contract.ERC20;
import io.meeds.deeds.contract.MeedsToken;
import io.meeds.deeds.contract.TokenFactory;
import io.meeds.deeds.contract.UserEngagementMinting;
import io.meeds.deeds.contract.XMeedsNFTRewarding;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import io.meeds.wom.api.model.HubReport;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple10;
import org.web3j.tuples.generated.Tuple12;
import org.web3j.tuples.generated.Tuple4;
import org.web3j.tuples.generated.Tuple5;
import org.web3j.tuples.generated.Tuple9;

@SpringBootTest(classes={BlockchainService.class})
class BlockchainServiceTest {
    @MockBean(name="ethereumNetwork")
    private Web3j web3j;
    @MockBean(name="polygonNetwork")
    private Web3j polygonWeb3j;
    @MockBean
    private DeedTenantProvisioning deedTenantProvisioning;
    @MockBean
    private DeedRenting deedRenting;
    @MockBean
    private Deed deed;
    @MockBean(name="ethereumMeedToken")
    private MeedsToken ethereumToken;
    @MockBean(name="polygonMeedToken")
    private MeedsToken polygonToken;
    @MockBean
    private XMeedsNFTRewarding xMeedsToken;
    @MockBean
    private TokenFactory tokenFactory;
    @MockBean
    private UserEngagementMinting uemContract;
    @MockBean(name="sushiPairToken")
    private ERC20 sushiPairToken;
    @Autowired
    private BlockchainService blockchainService;
    private static MockedStatic<DeedRenting> mockDeedRentingContract = Mockito.mockStatic(DeedRenting.class);

    BlockchainServiceTest() {
    }

    @Test
    void testGetDeedCardType() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        Mockito.when((Object)this.deed.cardType((BigInteger)ArgumentMatchers.any())).thenAnswer(invocation -> {
            BigInteger argument = (BigInteger)invocation.getArgument(0, BigInteger.class);
            if (argument == null || argument.shortValue() > 1) {
                throw new IllegalStateException("execution reverted: nftId doesn't exist");
            }
            if (argument.shortValue() == 0) {
                throw new RuntimeException();
            }
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)BigInteger.TWO);
            return remoteFunctionCall;
        });
        Assertions.assertThrows(IllegalStateException.class, () -> this.blockchainService.getDeedCardType(0L));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.blockchainService.getDeedCardType(2L));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.blockchainService.getDeedCardType(500L));
        Assertions.assertEquals((int)2, (int)this.blockchainService.getDeedCardType(1L));
    }

    @Test
    void testGetDeedCityIndex() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        Mockito.when((Object)this.deed.cityIndex((BigInteger)ArgumentMatchers.any())).thenAnswer(invocation -> {
            BigInteger argument = (BigInteger)invocation.getArgument(0, BigInteger.class);
            if (argument == null || argument.shortValue() > 1) {
                throw new IllegalStateException("execution reverted: nftId doesn't exist");
            }
            if (argument.shortValue() == 0) {
                throw new RuntimeException();
            }
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)BigInteger.TWO);
            return remoteFunctionCall;
        });
        Assertions.assertThrows(IllegalStateException.class, () -> this.blockchainService.getDeedCityIndex(0L));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.blockchainService.getDeedCityIndex(2L));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.blockchainService.getDeedCityIndex(500L));
        Assertions.assertEquals((int)2, (int)this.blockchainService.getDeedCityIndex(1L));
    }

    @Test
    void testIsDeedProvisioningManager() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        String walletAddress = "0xa5ef66131fbd70a1ffa69a95aba172f0a0502e6a";
        Mockito.when((Object)this.deedTenantProvisioning.isProvisioningManager((String)ArgumentMatchers.any(), (BigInteger)ArgumentMatchers.any())).thenAnswer(invocation -> {
            String address = (String)invocation.getArgument(0, String.class);
            BigInteger nftId = (BigInteger)invocation.getArgument(1, BigInteger.class);
            if (nftId == null || nftId.shortValue() == 0 || !StringUtils.equals((CharSequence)address, (CharSequence)walletAddress)) {
                throw new RuntimeException();
            }
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((Boolean)remoteFunctionCall.send())).thenReturn((Object)(nftId.shortValue() == 1 ? 1 : 0));
            return remoteFunctionCall;
        });
        Assertions.assertThrows(RuntimeException.class, () -> this.blockchainService.isDeedProvisioningManager(walletAddress, 0L));
        Assertions.assertTrue((boolean)this.blockchainService.isDeedProvisioningManager(walletAddress, 1L));
        Assertions.assertFalse((boolean)this.blockchainService.isDeedProvisioningManager(walletAddress, 2L));
    }

    @Test
    void testMeedsTotalSupplyNoDecimals() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        BigInteger totalSupply = BigInteger.valueOf(12500L);
        Mockito.when((Object)this.ethereumToken.totalSupply()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)totalSupply);
            return remoteFunctionCall;
        });
        Assertions.assertEquals((Object)new BigDecimal(totalSupply).divide(BigDecimal.valueOf(10L).pow(18)), (Object)this.blockchainService.meedsTotalSupplyNoDecimals());
    }

    @Test
    void testXMeedsTotalSupply() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        BigInteger totalSupply = BigInteger.valueOf(12500L);
        Mockito.when((Object)this.xMeedsToken.totalSupply()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)totalSupply);
            return remoteFunctionCall;
        });
        Assertions.assertEquals((Object)totalSupply, (Object)this.blockchainService.xMeedsTotalSupply());
    }

    @Test
    void testSushiPairTotalSupply() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        BigInteger totalSupply = BigInteger.valueOf(12500L);
        Mockito.when((Object)this.sushiPairToken.totalSupply()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)totalSupply);
            return remoteFunctionCall;
        });
        Assertions.assertEquals((Object)totalSupply, (Object)this.blockchainService.sushiPairTotalSupply());
    }

    @Test
    void testTotalAllocationPoints() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        BigInteger totalAllocationPoints = BigInteger.valueOf(12500L);
        Mockito.when((Object)this.tokenFactory.totalAllocationPoints()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)totalAllocationPoints);
            return remoteFunctionCall;
        });
        Assertions.assertEquals((Object)totalAllocationPoints, (Object)this.blockchainService.totalAllocationPoints());
    }

    @Test
    void testTotalFixedPercentage() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        BigInteger totalFixedPercentage = BigInteger.valueOf(12500L);
        Mockito.when((Object)this.tokenFactory.totalFixedPercentage()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)totalFixedPercentage);
            return remoteFunctionCall;
        });
        Assertions.assertEquals((Object)totalFixedPercentage, (Object)this.blockchainService.totalFixedPercentage());
    }

    @Test
    void testSushiPairSymbol() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        String sushiPairSymbol = "SLP";
        Mockito.when((Object)this.sushiPairToken.symbol()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((String)remoteFunctionCall.send())).thenReturn((Object)sushiPairSymbol);
            return remoteFunctionCall;
        });
        Assertions.assertEquals((Object)sushiPairSymbol, (Object)this.blockchainService.sushiPairSymbol());
    }

    @Test
    void testSushiPairSymbolError() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        Mockito.when((Object)this.sushiPairToken.symbol()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((String)remoteFunctionCall.send())).thenThrow(Exception.class);
            return remoteFunctionCall;
        });
        Assertions.assertThrows(IllegalStateException.class, () -> this.blockchainService.sushiPairSymbol());
    }

    @Test
    void testGetCurrentCity() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        BigInteger currentCityIndex = BigInteger.ONE;
        Tuple4 cityInfo = new Tuple4((Object)"name", (Object)BigInteger.valueOf(2L), (Object)BigInteger.valueOf(3L), (Object)BigInteger.valueOf(4L));
        Mockito.when((Object)this.xMeedsToken.currentCityIndex()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)currentCityIndex);
            return remoteFunctionCall;
        });
        Mockito.when((Object)this.xMeedsToken.cityInfo(currentCityIndex)).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((Tuple4)remoteFunctionCall.send())).thenReturn((Object)cityInfo);
            return remoteFunctionCall;
        });
        DeedCity expectedCity = new DeedCity(currentCityIndex, (String)cityInfo.component1(), (BigInteger)cityInfo.component2(), (BigInteger)cityInfo.component3(), (BigInteger)cityInfo.component4());
        Assertions.assertEquals((Object)expectedCity, (Object)this.blockchainService.getCurrentCity());
        Assertions.assertEquals((int)expectedCity.hashCode(), (int)this.blockchainService.getCurrentCity().hashCode());
    }

    @Test
    void testGetXMeedFundInfo() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        BigInteger totalSupply = BigInteger.valueOf(12500L);
        BigInteger pendingReward = BigInteger.valueOf(120L);
        BigInteger meedBalance = BigInteger.valueOf(120L);
        String xMeedAddress = "xMeeedAddress";
        Tuple5 fundInfo = new Tuple5((Object)BigInteger.valueOf(2L), (Object)BigInteger.valueOf(3L), (Object)BigInteger.valueOf(4L), (Object)BigInteger.valueOf(5L), (Object)Boolean.FALSE);
        Mockito.when((Object)this.xMeedsToken.getContractAddress()).thenReturn((Object)xMeedAddress);
        Mockito.when((Object)this.tokenFactory.fundInfos(xMeedAddress)).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((Tuple5)remoteFunctionCall.send())).thenReturn((Object)fundInfo);
            return remoteFunctionCall;
        });
        Mockito.when((Object)this.xMeedsToken.totalSupply()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)totalSupply);
            return remoteFunctionCall;
        });
        Mockito.when((Object)this.tokenFactory.pendingRewardBalanceOf(xMeedAddress)).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)pendingReward);
            return remoteFunctionCall;
        });
        Mockito.when((Object)this.ethereumToken.balanceOf(xMeedAddress)).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)meedBalance);
            return remoteFunctionCall;
        });
        FundInfo expectedFundInfo = new FundInfo(xMeedAddress, (BigInteger)fundInfo.component1(), (BigInteger)fundInfo.component2(), (BigInteger)fundInfo.component3(), (BigInteger)fundInfo.component4(), (Boolean)fundInfo.component5());
        expectedFundInfo.setTotalSupply(totalSupply);
        expectedFundInfo.setXMeedPendingReward(pendingReward);
        expectedFundInfo.setMeedsBalance(meedBalance);
        Assertions.assertEquals((Object)expectedFundInfo, (Object)this.blockchainService.getXMeedFundInfo());
        Assertions.assertEquals((int)expectedFundInfo.hashCode(), (int)this.blockchainService.getXMeedFundInfo().hashCode());
    }

    @Test
    void testGetSushiPairFundInfo() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        BigInteger totalSupply = BigInteger.valueOf(12500L);
        BigInteger lpBalanceOfTokenFactory = BigInteger.valueOf(120L);
        BigInteger meedBalance = BigInteger.valueOf(120L);
        String sushiPairAddress = "sushiPairAddress";
        String tokenFactoryAddress = "tokenFactoryAddress";
        String sushiPairSymbol = "SLP";
        Tuple5 fundInfo = new Tuple5((Object)BigInteger.valueOf(2L), (Object)BigInteger.valueOf(3L), (Object)BigInteger.valueOf(4L), (Object)BigInteger.valueOf(5L), (Object)Boolean.TRUE);
        Mockito.when((Object)this.sushiPairToken.getContractAddress()).thenReturn((Object)sushiPairAddress);
        Mockito.when((Object)this.tokenFactory.getContractAddress()).thenReturn((Object)tokenFactoryAddress);
        Mockito.when((Object)this.tokenFactory.fundInfos(sushiPairAddress)).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((Tuple5)remoteFunctionCall.send())).thenReturn((Object)fundInfo);
            return remoteFunctionCall;
        });
        Mockito.when((Object)this.sushiPairToken.totalSupply()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)totalSupply);
            return remoteFunctionCall;
        });
        Mockito.when((Object)this.sushiPairToken.symbol()).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((String)remoteFunctionCall.send())).thenReturn((Object)sushiPairSymbol);
            return remoteFunctionCall;
        });
        Mockito.when((Object)this.sushiPairToken.balanceOf(tokenFactoryAddress)).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)lpBalanceOfTokenFactory);
            return remoteFunctionCall;
        });
        Mockito.when((Object)this.ethereumToken.balanceOf(sushiPairAddress)).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)meedBalance);
            return remoteFunctionCall;
        });
        FundInfo expectedFundInfo = new FundInfo(sushiPairAddress, (BigInteger)fundInfo.component1(), (BigInteger)fundInfo.component2(), (BigInteger)fundInfo.component3(), (BigInteger)fundInfo.component4(), (Boolean)fundInfo.component5());
        expectedFundInfo.setTotalSupply(totalSupply);
        expectedFundInfo.setLpBalanceOfTokenFactory(lpBalanceOfTokenFactory);
        expectedFundInfo.setSymbol(sushiPairSymbol);
        expectedFundInfo.setMeedsBalance(meedBalance);
        Assertions.assertEquals((Object)expectedFundInfo, (Object)this.blockchainService.getSushiPairFundInfo());
        Assertions.assertEquals((int)expectedFundInfo.hashCode(), (int)this.blockchainService.getSushiPairFundInfo().hashCode());
    }

    @Test
    void testBalanceOfOnPolygon() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        BigInteger balance = BigInteger.valueOf(12500L);
        String address = "0x6acA77CF3BaB0C4E8210A09B57B07854a995289a";
        Mockito.when((Object)this.polygonToken.balanceOf(address)).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)balance);
            return remoteFunctionCall;
        });
        Assertions.assertEquals((Object)new BigDecimal(balance).divide(BigDecimal.valueOf(10L).pow(18)), (Object)this.blockchainService.meedBalanceOfOnPolygon(address));
    }

    @Test
    void testBalanceOfOnEthereum() throws Exception {
        Assertions.assertNotNull((Object)this.blockchainService);
        BigInteger balance = BigInteger.valueOf(12500L);
        String address = "0x44D6d6aB50401Dd846336e9C706A492f06E1Bcd4";
        Mockito.when((Object)this.ethereumToken.balanceOf(address)).thenAnswer(invocation -> {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
            Mockito.when((Object)((BigInteger)remoteFunctionCall.send())).thenReturn((Object)balance);
            return remoteFunctionCall;
        });
        Assertions.assertEquals((Object)new BigDecimal(balance).divide(BigDecimal.valueOf(10L).pow(18)), (Object)this.blockchainService.meedBalanceOfNoDecimals(address));
    }

    @Test
    void testGetMinedTransferOwnershipDeedTransactions() throws Exception {
        long fromBlock = 15L;
        long toBlock = 20L;
        Request getLogsRequest = (Request)Mockito.mock(Request.class);
        EthLog ethLogs = (EthLog)Mockito.mock(EthLog.class);
        Mockito.when((Object)this.web3j.ethGetLogs((EthFilter)ArgumentMatchers.any())).thenReturn((Object)getLogsRequest);
        Mockito.when((Object)getLogsRequest.send()).thenReturn((Object)ethLogs);
        Set minedTransactions = this.blockchainService.getMinedTransferOwnershipDeedTransactions(fromBlock, toBlock);
        Assertions.assertNotNull((Object)minedTransactions);
        Assertions.assertTrue((boolean)minedTransactions.isEmpty());
        String transactionHash = "0xab5bc0ece5ef0995fac33c53f4b92d68da952552a73932e51b4c02933237e84f";
        EthLog.LogResult logResult = (EthLog.LogResult)Mockito.mock(EthLog.LogResult.class);
        EthLog.LogObject logObject = (EthLog.LogObject)Mockito.mock(EthLog.LogObject.class);
        Mockito.when((Object)logResult.get()).thenReturn((Object)logObject);
        Mockito.when((Object)ethLogs.getLogs()).thenReturn(Collections.singletonList(logResult));
        Mockito.when((Object)logObject.getTransactionHash()).thenReturn((Object)transactionHash);
        Request getTransactionReceiptRequest = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)this.web3j.ethGetTransactionReceipt(transactionHash)).thenReturn((Object)getTransactionReceiptRequest);
        EthGetTransactionReceipt ethGetTransactionReceipt = (EthGetTransactionReceipt)Mockito.mock(EthGetTransactionReceipt.class);
        Mockito.when((Object)getTransactionReceiptRequest.send()).thenReturn((Object)ethGetTransactionReceipt);
        TransactionReceipt transactionReceipt = (TransactionReceipt)Mockito.mock(TransactionReceipt.class);
        Mockito.when((Object)((TransactionReceipt)ethGetTransactionReceipt.getResult())).thenReturn((Object)transactionReceipt);
        Mockito.when((Object)transactionReceipt.isStatusOK()).thenReturn((Object)false);
        minedTransactions = this.blockchainService.getMinedTransferOwnershipDeedTransactions(fromBlock, toBlock);
        Assertions.assertNotNull((Object)minedTransactions);
        Assertions.assertTrue((boolean)minedTransactions.isEmpty());
        Mockito.when((Object)transactionReceipt.isStatusOK()).thenReturn((Object)true);
        MockedStatic mockDeedContract = Mockito.mockStatic(Deed.class);
        String fromAddress = "fromAddress";
        String toAddress = "toAddress";
        long nftId = 2L;
        mockDeedContract.when(() -> Deed.getTransferSingleEvents((TransactionReceipt)transactionReceipt)).thenReturn(Arrays.asList(this.newTransferSingleEvent(nftId, fromAddress, toAddress), this.newTransferSingleEvent(nftId, fromAddress, toAddress), this.newTransferSingleEvent(nftId, fromAddress, toAddress)));
        minedTransactions = this.blockchainService.getMinedTransferOwnershipDeedTransactions(fromBlock, toBlock);
        Assertions.assertNotNull((Object)minedTransactions);
        Assertions.assertEquals((int)1, (int)minedTransactions.size());
        mockDeedContract.when(() -> Deed.getTransferSingleEvents((TransactionReceipt)transactionReceipt)).thenReturn(Arrays.asList(this.newTransferSingleEvent(nftId, fromAddress, toAddress), this.newTransferSingleEvent(nftId + 1L, fromAddress, toAddress), this.newTransferSingleEvent(nftId + 2L, fromAddress, toAddress)));
        minedTransactions = this.blockchainService.getMinedTransferOwnershipDeedTransactions(fromBlock, toBlock);
        Assertions.assertNotNull((Object)minedTransactions);
        Assertions.assertEquals((int)3, (int)minedTransactions.size());
    }

    @Test
    void testGetCreatedOfferTransactionEvents() throws Exception {
        String transactionHash = "0xab5bc0ece5ef0995fac33c53f4b92d68da952552a73932e51b4c02933237e84f";
        Request getTransactionReceiptRequest = (Request)Mockito.mock(Request.class);
        EthGetTransactionReceipt ethGetTransactionReceipt = (EthGetTransactionReceipt)Mockito.mock(EthGetTransactionReceipt.class);
        Mockito.when((Object)this.web3j.ethGetTransactionReceipt(transactionHash)).thenReturn((Object)getTransactionReceiptRequest);
        Mockito.when((Object)getTransactionReceiptRequest.send()).thenReturn((Object)ethGetTransactionReceipt);
        TransactionReceipt transactionReceipt = (TransactionReceipt)Mockito.mock(TransactionReceipt.class);
        Mockito.when((Object)ethGetTransactionReceipt.getTransactionReceipt()).thenReturn(Optional.of(transactionReceipt));
        Mockito.when((Object)transactionReceipt.isStatusOK()).thenReturn((Object)false);
        Map offerTransactionEvents = this.blockchainService.getOfferTransactionEvents(transactionHash);
        Assertions.assertTrue((boolean)offerTransactionEvents.isEmpty());
        DeedRenting.OfferCreatedEventResponse offerCreateResponse = new DeedRenting.OfferCreatedEventResponse();
        offerCreateResponse.deedId = BigInteger.ONE;
        offerCreateResponse.id = BigInteger.TWO;
        offerCreateResponse.owner = "owner";
        mockDeedRentingContract.when(() -> DeedRenting.getOfferCreatedEvents((TransactionReceipt)transactionReceipt)).thenReturn(Collections.singletonList(offerCreateResponse));
        this.mockOffer(offerCreateResponse.id);
        Mockito.when((Object)transactionReceipt.isStatusOK()).thenReturn((Object)true);
        offerTransactionEvents = this.blockchainService.getOfferTransactionEvents(transactionHash);
        Assertions.assertFalse((boolean)offerTransactionEvents.isEmpty());
        Assertions.assertEquals((int)1, (int)offerTransactionEvents.size());
    }

    @Test
    void testGetDeletedOfferTransactionEvents() throws Exception {
        String transactionHash = "0xab5bc0ece5ef0995fac33c53f4b92d68da952552a73932e51b4c02933237e84f";
        Request getTransactionReceiptRequest = (Request)Mockito.mock(Request.class);
        EthGetTransactionReceipt ethGetTransactionReceipt = (EthGetTransactionReceipt)Mockito.mock(EthGetTransactionReceipt.class);
        Mockito.when((Object)this.web3j.ethGetTransactionReceipt(transactionHash)).thenReturn((Object)getTransactionReceiptRequest);
        Mockito.when((Object)getTransactionReceiptRequest.send()).thenReturn((Object)ethGetTransactionReceipt);
        TransactionReceipt transactionReceipt = (TransactionReceipt)Mockito.mock(TransactionReceipt.class);
        Mockito.when((Object)ethGetTransactionReceipt.getTransactionReceipt()).thenReturn(Optional.of(transactionReceipt));
        Mockito.when((Object)transactionReceipt.isStatusOK()).thenReturn((Object)false);
        Map offerTransactionEvents = this.blockchainService.getOfferTransactionEvents(transactionHash);
        Assertions.assertTrue((boolean)offerTransactionEvents.isEmpty());
        DeedRenting.OfferDeletedEventResponse offerDeleteResponse = new DeedRenting.OfferDeletedEventResponse();
        offerDeleteResponse.deedId = BigInteger.ONE;
        offerDeleteResponse.id = BigInteger.TWO;
        offerDeleteResponse.owner = "owner";
        mockDeedRentingContract.when(() -> DeedRenting.getOfferDeletedEvents((TransactionReceipt)transactionReceipt)).thenReturn(Collections.singletonList(offerDeleteResponse));
        Mockito.when((Object)transactionReceipt.isStatusOK()).thenReturn((Object)true);
        offerTransactionEvents = this.blockchainService.getOfferTransactionEvents(transactionHash);
        Assertions.assertFalse((boolean)offerTransactionEvents.isEmpty());
        Assertions.assertEquals((int)1, (int)offerTransactionEvents.size());
    }

    @Test
    void testGetPaidOfferTransactionEvents() throws Exception {
        String transactionHash = "0xab5bc0ece5ef0995fac33c53f4b92d68da952552a73932e51b4c02933237e84f";
        Request getTransactionReceiptRequest = (Request)Mockito.mock(Request.class);
        EthGetTransactionReceipt ethGetTransactionReceipt = (EthGetTransactionReceipt)Mockito.mock(EthGetTransactionReceipt.class);
        Mockito.when((Object)this.web3j.ethGetTransactionReceipt(transactionHash)).thenReturn((Object)getTransactionReceiptRequest);
        Mockito.when((Object)getTransactionReceiptRequest.send()).thenReturn((Object)ethGetTransactionReceipt);
        TransactionReceipt transactionReceipt = (TransactionReceipt)Mockito.mock(TransactionReceipt.class);
        Mockito.when((Object)ethGetTransactionReceipt.getTransactionReceipt()).thenReturn(Optional.of(transactionReceipt));
        Mockito.when((Object)transactionReceipt.isStatusOK()).thenReturn((Object)false);
        Map offerTransactionEvents = this.blockchainService.getOfferTransactionEvents(transactionHash);
        Assertions.assertTrue((boolean)offerTransactionEvents.isEmpty());
        DeedRenting.RentPaidEventResponse offerPaidResponse = new DeedRenting.RentPaidEventResponse();
        offerPaidResponse.deedId = BigInteger.ONE;
        offerPaidResponse.id = BigInteger.TWO;
        offerPaidResponse.owner = "owner";
        offerPaidResponse.firstRent = true;
        mockDeedRentingContract.when(() -> DeedRenting.getRentPaidEvents((TransactionReceipt)transactionReceipt)).thenReturn(Collections.singletonList(offerPaidResponse));
        this.mockOffer(offerPaidResponse.id);
        Mockito.when((Object)transactionReceipt.isStatusOK()).thenReturn((Object)true);
        offerTransactionEvents = this.blockchainService.getOfferTransactionEvents(transactionHash);
        Assertions.assertFalse((boolean)offerTransactionEvents.isEmpty());
        Assertions.assertEquals((int)1, (int)offerTransactionEvents.size());
    }

    @Test
    void retrieveReportProperties() throws Exception {
        long reportId = 2256889L;
        HubReport report = new HubReport();
        report.setReportId(reportId);
        RemoteFunctionCall remoteCallHubReport = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
        Mockito.when((Object)this.uemContract.hubReports(BigInteger.valueOf(reportId))).thenReturn((Object)remoteCallHubReport);
        String hubAddress = "hubAddress";
        BigInteger usersCount = BigInteger.valueOf(5L);
        BigInteger recipientsCount = BigInteger.valueOf(6L);
        BigInteger participantsCount = BigInteger.valueOf(7L);
        BigInteger achievementsCount = BigInteger.valueOf(8L);
        BigInteger amount = BigInteger.valueOf(9L);
        String tokenAddress = "tokenAddress";
        BigInteger tokenChainId = BigInteger.valueOf(10L);
        BigInteger fromDate = BigInteger.valueOf(11L);
        BigInteger toDate = BigInteger.valueOf(12L);
        Mockito.when((Object)((Tuple10)remoteCallHubReport.send())).thenReturn((Object)new Tuple10((Object)hubAddress, (Object)usersCount, (Object)recipientsCount, (Object)participantsCount, (Object)achievementsCount, (Object)amount, (Object)tokenAddress, (Object)tokenChainId, (Object)fromDate, (Object)toDate));
        RemoteFunctionCall remoteCallhubRewards = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
        Mockito.when((Object)this.uemContract.hubRewards(BigInteger.valueOf(reportId))).thenReturn((Object)remoteCallhubRewards);
        BigInteger rewardId = BigInteger.valueOf(13L);
        String owner = "Owner";
        String tenant = "Tenant";
        BigInteger fixedRewardIndex = BigInteger.valueOf(14L);
        BigInteger ownerFixedIndex = BigInteger.valueOf(15L);
        BigInteger tenantFixedIndex = BigInteger.valueOf(16L);
        BigInteger sentDate = BigInteger.valueOf(17L);
        BigInteger lastRewardedAmount = BigInteger.valueOf(18L);
        Mockito.when((Object)((Tuple9)remoteCallhubRewards.send())).thenReturn((Object)new Tuple9((Object)rewardId, (Object)owner, (Object)tenant, (Object)fixedRewardIndex, (Object)ownerFixedIndex, (Object)tenantFixedIndex, (Object)sentDate, (Object)true, (Object)lastRewardedAmount));
        RemoteFunctionCall remoteCallReportDeed = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
        Mockito.when((Object)this.uemContract.hubDeeds(BigInteger.valueOf(reportId))).thenReturn((Object)remoteCallReportDeed);
        BigInteger deedId = BigInteger.valueOf(19L);
        BigInteger city = BigInteger.valueOf(20L);
        BigInteger cardType = BigInteger.valueOf(21L);
        BigInteger mintingPower = BigInteger.valueOf(22L);
        BigInteger maxUsers = BigInteger.valueOf(23L);
        Mockito.when((Object)((Tuple5)remoteCallReportDeed.send())).thenReturn((Object)new Tuple5((Object)deedId, (Object)city, (Object)cardType, (Object)mintingPower, (Object)maxUsers));
        this.blockchainService.retrieveReportProperties(report);
        Assertions.assertEquals((Object)hubAddress.toLowerCase(), (Object)report.getHubAddress());
        Assertions.assertEquals((long)usersCount.longValue(), (long)report.getUsersCount());
        Assertions.assertEquals((long)recipientsCount.longValue(), (long)report.getRecipientsCount());
        Assertions.assertEquals((long)participantsCount.longValue(), (long)report.getParticipantsCount());
        Assertions.assertEquals((long)achievementsCount.longValue(), (long)report.getAchievementsCount());
        Assertions.assertEquals((double)new BigDecimal(amount).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue(), (double)report.getHubRewardAmount());
        Assertions.assertEquals((Object)tokenAddress.toLowerCase(), (Object)report.getRewardTokenAddress());
        Assertions.assertEquals((long)tokenChainId.longValue(), (long)report.getRewardTokenNetworkId());
        Assertions.assertEquals((long)fromDate.longValue(), (long)report.getFromDate().getEpochSecond());
        Assertions.assertEquals((long)toDate.longValue(), (long)report.getToDate().getEpochSecond());
        Assertions.assertEquals((long)rewardId.longValue(), (long)report.getRewardId());
        Assertions.assertEquals((Object)owner.toLowerCase(), (Object)report.getOwnerAddress());
        Assertions.assertEquals((Object)tenant.toLowerCase(), (Object)report.getDeedManagerAddress());
        Assertions.assertEquals((double)new BigDecimal(fixedRewardIndex).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue(), (double)report.getFixedRewardIndex());
        Assertions.assertEquals((double)new BigDecimal(ownerFixedIndex).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue(), (double)report.getOwnerFixedIndex());
        Assertions.assertEquals((double)new BigDecimal(tenantFixedIndex).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue(), (double)report.getTenantFixedIndex());
        Assertions.assertEquals((long)sentDate.longValue(), (long)report.getSentDate().getEpochSecond());
        Assertions.assertEquals((double)new BigDecimal(lastRewardedAmount).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue(), (double)report.getLastPeriodUemRewardAmount());
        Assertions.assertEquals((long)deedId.longValue(), (long)report.getDeedId());
        Assertions.assertEquals((short)city.shortValue(), (short)report.getCity());
        Assertions.assertEquals((short)cardType.shortValue(), (short)report.getCardType());
        Assertions.assertEquals((short)mintingPower.shortValue(), (short)report.getMintingPower());
        Assertions.assertEquals((long)maxUsers.longValue(), (long)report.getMaxUsers());
    }

    private void mockOffer(BigInteger offerId) throws Exception {
        Tuple12 tuple12 = new Tuple12((Object)BigInteger.valueOf(1L), (Object)BigInteger.valueOf(2L), (Object)BigInteger.valueOf(3L).toString(), (Object)BigInteger.valueOf(4L), (Object)BigInteger.valueOf(5L), (Object)BigInteger.valueOf(6L), (Object)BigInteger.valueOf(7L), (Object)BigInteger.valueOf(8L), (Object)BigInteger.valueOf(9L), (Object)BigInteger.valueOf(10L), (Object)BigInteger.valueOf(11L).toString(), (Object)BigInteger.valueOf(12L));
        RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)Mockito.mock(RemoteFunctionCall.class);
        Mockito.when((Object)((Tuple12)remoteFunctionCall.send())).thenReturn((Object)tuple12);
        Mockito.when((Object)this.deedRenting.deedOffers(offerId)).thenReturn((Object)remoteFunctionCall);
    }

    private Deed.TransferSingleEventResponse newTransferSingleEvent(long nftId, String fromAddress, String toAddress) {
        Deed.TransferSingleEventResponse eventResponse = new Deed.TransferSingleEventResponse();
        eventResponse._id = BigInteger.valueOf(nftId);
        eventResponse._from = fromAddress;
        eventResponse._to = toAddress;
        return eventResponse;
    }
}

