/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.constant.BlockchainLeaseStatus;
import io.meeds.deeds.common.constant.DeedCard;
import io.meeds.deeds.common.constant.DeedCity;
import io.meeds.deeds.common.constant.ExpirationDuration;
import io.meeds.deeds.common.constant.NoticePeriod;
import io.meeds.deeds.common.constant.OfferType;
import io.meeds.deeds.common.constant.RentalDuration;
import io.meeds.deeds.common.constant.RentalPaymentPeriodicity;
import io.meeds.deeds.common.constant.TransactionStatus;
import io.meeds.deeds.common.constant.UnauthorizedOperationException;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.elasticsearch.model.DeedTenantLease;
import io.meeds.deeds.common.elasticsearch.storage.LeaseRepository;
import io.meeds.deeds.common.model.DeedLeaseBlockchainState;
import io.meeds.deeds.common.model.DeedTenantLeaseDTO;
import io.meeds.deeds.common.model.DeedTenantOfferDTO;
import io.meeds.deeds.common.model.LeaseFilter;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.common.service.LeaseService;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.service.OfferService;
import io.meeds.deeds.common.service.TenantService;
import io.meeds.deeds.common.utils.DeedTenantLeaseMapper;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.Query;

@SpringBootTest(classes={LeaseService.class})
class LeaseServiceTest {
    @MockBean
    private LeaseRepository leaseRepository;
    @MockBean
    private ElasticsearchOperations elasticsearchOperations;
    @MockBean
    private BlockchainService blockchainService;
    @MockBean
    private TenantService tenantService;
    @MockBean
    private OfferService offerService;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private LeaseService leaseService;

    LeaseServiceTest() {
    }

    @Test
    void testGetLeasess() {
        long nftId = 2L;
        long leaseId = 3L;
        DeedTenantLease lease = this.newLease(leaseId, nftId);
        Pageable pageable = (Pageable)Mockito.mock(Pageable.class);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)((DeedTenantLease)searchHit.getContent())).thenReturn((Object)lease);
        SearchHits searchHits = (SearchHits)Mockito.mock(SearchHits.class);
        Mockito.when((Object)searchHits.getSearchHits()).thenReturn(Collections.singletonList(searchHit));
        Mockito.when((Object)searchHits.getTotalHits()).thenReturn((Object)1L);
        Mockito.when((Object)this.tenantService.isBlockchainNetworkValid(2L)).thenReturn((Object)true);
        this.assertElasticSearchQuery((SearchHits<DeedTenantLease>)searchHits, "nftId", "enabled", "endDate", "viewAddresses", "confirmed", "cardType", "transactionStatus", "owner");
        LeaseFilter leaseFilter = new LeaseFilter();
        leaseFilter.setNftId(nftId);
        leaseFilter.setExcludeNotConfirmed(true);
        leaseFilter.setCardTypes(Collections.singletonList(DeedCard.COMMON));
        leaseFilter.setTransactionStatus(Collections.singletonList(TransactionStatus.VALIDATED));
        leaseFilter.setOwner(Boolean.valueOf(true));
        Page result = this.leaseService.getLeases(leaseFilter, pageable);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.getSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)result.getTotalElements());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedTenantLeaseMapper.toDTO((DeedTenantLease)lease, null, null), result.get().findFirst().orElse(null));
    }

    @Test
    void testGetLease() throws Exception {
        long nftId = 2L;
        long leaseId = 3L;
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.leaseService.getLease(leaseId, null, false));
        DeedTenantLease lease = this.newLease(leaseId, nftId);
        Mockito.when((Object)this.leaseRepository.findById((Object)nftId)).thenReturn(Optional.of(lease));
        DeedTenantLeaseDTO leaseDTO = this.leaseService.getLease(leaseId, null, false);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)leaseDTO);
    }

    @Test
    void testGetLeaseWithBlockchainRefresh() throws Exception {
        long nftId = 2L;
        long leaseId = 3L;
        long lastBlockNumber = 12L;
        String tenant = "tenantAddress";
        String transactionHash = "transactionHash";
        DeedLeaseBlockchainState blockchainState = new DeedLeaseBlockchainState(BigInteger.valueOf(leaseId), BigInteger.valueOf(lastBlockNumber), BigInteger.valueOf(nftId), BigInteger.valueOf(1L), BigInteger.valueOf(2L), BigInteger.valueOf(3L), BigInteger.valueOf(4L), BigInteger.valueOf(5L), tenant, transactionHash);
        Mockito.when((Object)this.blockchainService.getLeaseById(BigInteger.valueOf(leaseId), BigInteger.valueOf(lastBlockNumber), null)).thenReturn((Object)blockchainState);
        Mockito.when((Object)this.blockchainService.getLastBlock()).thenReturn((Object)lastBlockNumber);
        DeedTenantOfferDTO offer = this.newOffer("offerId", nftId, leaseId);
        Mockito.when((Object)this.offerService.getOfferByBlockchainId(leaseId)).thenReturn((Object)offer);
        Mockito.when((Object)this.leaseRepository.save((Object)((DeedTenantLease)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            DeedTenantLease lease = (DeedTenantLease)invocation.getArgument(0, DeedTenantLease.class);
            Mockito.when((Object)this.leaseRepository.findById((Object)lease.getId())).thenReturn(Optional.of(lease));
            return lease;
        });
        DeedTenant deedTenant = new DeedTenant();
        deedTenant.setNftId(nftId);
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.eq((long)nftId)))).thenReturn((Object)deedTenant);
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.leaseService.getLease(leaseId, null, false));
        Mockito.when((Object)this.tenantService.saveDeedTenant((DeedTenant)ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        DeedTenantLeaseDTO leaseDTO = this.leaseService.getLease(leaseId, null, true);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)leaseDTO);
        ((TenantService)Mockito.verify((Object)this.tenantService, (VerificationMode)Mockito.times((int)1))).saveDeedTenant((DeedTenant)ArgumentMatchers.argThat(dt -> StringUtils.isNotBlank((CharSequence)dt.getOwnerAddress())));
    }

    @Test
    void testCreateLease() throws Exception {
        long nftId = 2L;
        long leaseId = 3L;
        String tenant = "tenantAddress";
        String transactionHash = "transactionHash";
        DeedTenantOfferDTO offer = this.newOffer("offerId", nftId, leaseId);
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.leaseService.createLease(tenant, null, offer.getId(), transactionHash));
        Mockito.when((Object)this.offerService.getOffer(offer.getId())).thenReturn((Object)offer);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.leaseService.createLease(null, null, offer.getId(), transactionHash));
        Mockito.when((Object)this.offerService.getOffer(offer.getId())).thenReturn((Object)offer);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.leaseService.createLease(tenant, null, offer.getId(), null));
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.leaseService.createLease(tenant, null, offer.getId(), transactionHash));
        Mockito.when((Object)this.tenantService.isDeedOwner(offer.getOwner(), nftId)).thenReturn((Object)true);
        DeedTenant deedTenant = new DeedTenant();
        deedTenant.setNftId(nftId);
        Mockito.when((Object)this.tenantService.saveDeedTenant((DeedTenant)ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.eq((long)nftId)))).thenReturn((Object)deedTenant);
        Mockito.when((Object)this.leaseRepository.save((Object)((DeedTenantLease)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            DeedTenantLease lease = (DeedTenantLease)invocation.getArgument(0, DeedTenantLease.class);
            Mockito.when((Object)this.leaseRepository.findById((Object)lease.getId())).thenReturn(Optional.of(lease));
            return lease;
        });
        DeedTenantLeaseDTO createdLease = this.leaseService.createLease(tenant, null, offer.getId(), transactionHash);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)createdLease);
        ((TenantService)Mockito.verify((Object)this.tenantService, (VerificationMode)Mockito.times((int)1))).saveDeedTenant((DeedTenant)ArgumentMatchers.argThat(dt -> StringUtils.isNotBlank((CharSequence)dt.getOwnerAddress())));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.leaseAcquired"), ArgumentMatchers.any());
    }

    @Test
    void testPayRents() throws Exception {
        long nftId = 2L;
        long leaseId = 3L;
        String tenant = "tenantAddress";
        String owner = "ownerAddress";
        String transactionHash = "transactionHash";
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.leaseService.payRents(tenant, owner, leaseId, 5, transactionHash));
        DeedTenantLease lease = this.newLease(leaseId, nftId);
        lease.setManager(tenant);
        Mockito.when((Object)this.leaseRepository.findById((Object)lease.getId())).thenReturn(Optional.of(lease));
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.leaseService.payRents("otherTenant", owner, leaseId, 5, transactionHash));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.leaseService.payRents(tenant, owner, leaseId, 5, null));
        Mockito.when((Object)this.leaseRepository.save((Object)((DeedTenantLease)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        Mockito.when((Object)this.tenantService.isDeedOwner(owner, lease.getNftId())).thenReturn((Object)true);
        DeedTenantLeaseDTO changedLease = this.leaseService.payRents(tenant, owner, leaseId, 5, transactionHash);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)changedLease);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)changedLease.getMonthPaymentInProgress());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TransactionStatus.IN_PROGRESS, (Object)changedLease.getTransactionStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)owner, (Object)changedLease.getOwnerAddress());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.leaseRentPayed"), ArgumentMatchers.any());
    }

    @Test
    void testEndLeaseByOwner() throws Exception {
        long nftId = 2L;
        long leaseId = 3L;
        String tenant = "tenantAddress";
        String owner = "ownerAddress";
        String transactionHash = "transactionHash";
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.leaseService.endLease(tenant, leaseId, transactionHash));
        DeedTenantLease lease = this.newLease(leaseId, nftId);
        lease.setManager(tenant);
        Mockito.when((Object)this.leaseRepository.findById((Object)lease.getId())).thenReturn(Optional.of(lease));
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.leaseService.endLease(tenant, leaseId, transactionHash));
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.leaseService.endLease(owner, leaseId, transactionHash));
        Mockito.when((Object)this.tenantService.isDeedManager(tenant, nftId)).thenReturn((Object)true);
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.leaseService.endLease(owner, leaseId, transactionHash));
        Mockito.when((Object)this.tenantService.isDeedOwner(owner, nftId)).thenReturn((Object)true);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.leaseService.endLease(owner, leaseId, null));
        Mockito.when((Object)this.leaseRepository.save((Object)((DeedTenantLease)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        DeedTenantLeaseDTO changedLease = this.leaseService.endLease(owner, leaseId, transactionHash);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)changedLease);
        org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.lowerCase((String)owner), (Object)changedLease.getEndingLeaseAddress());
        org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.lowerCase((String)owner), (Object)changedLease.getOwnerAddress());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)changedLease.isEndingLease());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.leaseTenantEvict"), ArgumentMatchers.any());
    }

    @Test
    void testEndLeaseByManager() throws Exception {
        long nftId = 2L;
        long leaseId = 3L;
        String tenant = "tenantAddress";
        String owner = "ownerAddress";
        String transactionHash = "transactionHash";
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.leaseService.endLease(tenant, leaseId, transactionHash));
        DeedTenantLease lease = this.newLease(leaseId, nftId);
        lease.setManager(tenant);
        Mockito.when((Object)this.leaseRepository.findById((Object)lease.getId())).thenReturn(Optional.of(lease));
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.leaseService.endLease(tenant, leaseId, transactionHash));
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.leaseService.endLease(owner, leaseId, transactionHash));
        Mockito.when((Object)this.tenantService.isDeedManager(tenant, nftId)).thenReturn((Object)true);
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.leaseService.endLease(owner, leaseId, transactionHash));
        Mockito.when((Object)this.tenantService.isDeedOwner(owner, nftId)).thenReturn((Object)true);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.leaseService.endLease(owner, leaseId, null));
        Mockito.when((Object)this.leaseRepository.save((Object)((DeedTenantLease)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        DeedTenantLeaseDTO changedLease = this.leaseService.endLease(tenant, leaseId, transactionHash);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)changedLease);
        org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.lowerCase((String)tenant), (Object)changedLease.getEndingLeaseAddress());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)changedLease.isEndingLease());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.leaseEndSent"), ArgumentMatchers.any());
    }

    @Test
    void testGetPendingTransactions() throws Exception {
        long nftId = 2L;
        long leaseId = 3L;
        DeedTenantLease lease = this.newLease(leaseId, nftId);
        Mockito.when((Object)this.leaseRepository.findByTransactionStatusInOrderByCreatedDateAsc(Arrays.asList(TransactionStatus.IN_PROGRESS))).thenReturn(Collections.singletonList(lease));
        List pendingTransactions = this.leaseService.getPendingTransactions();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)pendingTransactions);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pendingTransactions.size());
        DeedTenantLease pendingLease = (DeedTenantLease)pendingTransactions.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((long)lease.getId(), (long)pendingLease.getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)lease.getNftId(), (long)pendingLease.getNftId());
    }

    @Test
    void testUpdateLeaseStatusFromBlockchain() throws Exception {
        long nftId = 2L;
        long leaseId = 3L;
        String transactionHash = "transactionHash";
        long lastBlockNumber = 12L;
        String tenant = "tenantAddress";
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.leaseService.updateLeaseStatusFromBlockchain(leaseId, transactionHash, Collections.emptyMap()));
        Mockito.when((Object)this.leaseRepository.save((Object)((DeedTenantLease)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        final DeedTenantLease lease = this.newLease(leaseId, nftId);
        this.leaseService.updateLeaseStatusFromBlockchain(leaseId, transactionHash, Collections.emptyMap());
        ((LeaseRepository)Mockito.verify((Object)this.leaseRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenantLease)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenantLease>(){

            public boolean matches(DeedTenantLease persistedLease) {
                if (lease.getId() == persistedLease.getId()) {
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)persistedLease.getPendingTransactions().size());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)persistedLease.isEndingLease());
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)persistedLease.getMonthPaymentInProgress());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)persistedLease.isEnabled());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)TransactionStatus.ERROR, (Object)persistedLease.getTransactionStatus());
                    return true;
                }
                return false;
            }
        })));
        final long enabledLeaseId = 4L;
        DeedTenantLease enabledLease = this.newLease(enabledLeaseId, nftId);
        enabledLease.setEndingLease(true);
        enabledLease.setMonthPaymentInProgress(5);
        enabledLease.setConfirmed(true);
        DeedLeaseBlockchainState blockchainState = new DeedLeaseBlockchainState(BigInteger.valueOf(enabledLeaseId), BigInteger.valueOf(lastBlockNumber), BigInteger.valueOf(nftId), BigInteger.valueOf(1L), BigInteger.valueOf(2L), BigInteger.valueOf(3L), BigInteger.valueOf(4L), BigInteger.valueOf(5L), tenant, transactionHash);
        this.leaseService.updateLeaseStatusFromBlockchain(enabledLeaseId, transactionHash, Collections.singletonMap(BlockchainLeaseStatus.LEASE_PAYED, blockchainState));
        ((LeaseRepository)Mockito.verify((Object)this.leaseRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenantLease)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenantLease>(){

            public boolean matches(DeedTenantLease persistedLease) {
                if (enabledLeaseId == persistedLease.getId()) {
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)persistedLease.getPendingTransactions().size());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)persistedLease.isEndingLease());
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)persistedLease.getMonthPaymentInProgress());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)persistedLease.isEnabled());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)TransactionStatus.VALIDATED, (Object)persistedLease.getTransactionStatus());
                    return true;
                }
                return false;
            }
        })));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.leaseRentPaymentConfirmed"), ArgumentMatchers.any());
    }

    private DeedTenantLease newLease(long leaseId, long nftId) {
        DeedTenantLease lease = new DeedTenantLease();
        lease.setId(leaseId);
        lease.setNftId(nftId);
        lease.setCardType(DeedCard.UNCOMMON);
        lease.setCity(DeedCity.MELQART);
        lease.setOwner("otherWallet");
        lease.setAmount(12.0);
        lease.setMonths(6);
        lease.setPaymentPeriodicity(RentalPaymentPeriodicity.ONE_MONTH);
        lease.setOwnerMintingPercentage(50);
        lease.setMintingPower(DeedCard.UNCOMMON.getMintingPower());
        lease.setCreatedDate(Instant.now());
        lease.setPendingTransactions(Collections.singletonList(StringUtils.lowerCase((String)"TransactionHash")));
        lease.setEnabled(true);
        Mockito.lenient().when((Object)this.leaseRepository.findById((Object)lease.getId())).thenReturn(Optional.of(lease));
        return lease;
    }

    private DeedTenantOfferDTO newOffer(String id, long nftId, long offerId) {
        return new DeedTenantOfferDTO(id, offerId, nftId, DeedCity.ASHTARTE, DeedCard.UNCOMMON, "owner", null, "description", 5.0, 10.0, OfferType.RENTING, ExpirationDuration.ONE_DAY, ExpirationDuration.ONE_DAY.getDays(), RentalDuration.ONE_MONTH, RentalDuration.ONE_MONTH.getMonths(), NoticePeriod.ONE_MONTH, NoticePeriod.ONE_MONTH.getMonths(), RentalPaymentPeriodicity.ONE_YEAR, 1, 1.1, "0xTransaction", TransactionStatus.IN_PROGRESS, Instant.now(), Instant.now(), Instant.now(), Instant.now(), false, null, null, null, null);
    }

    private void assertElasticSearchQuery(SearchHits<DeedTenantLease> searchHits, final String ... filedNames) {
        Mockito.when((Object)this.elasticsearchOperations.search((Query)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Query>(){

            public boolean matches(Query query) {
                Arrays.stream(filedNames).forEach(filedName -> LeaseServiceTest.this.assertQueryCriteriaNotNull(query, (String)filedName));
                return true;
            }
        }), (Class)ArgumentMatchers.eq(DeedTenantLease.class))).thenReturn(searchHits);
    }

    private void assertQueryCriteriaNotNull(Query query, String filedName) {
        CriteriaQuery criteriaQuery = (CriteriaQuery)query;
        if (criteriaQuery == null) {
            Assertions.fail((String)("Criteria for Field " + filedName + " not found"));
        }
        Criteria criteria = criteriaQuery.getCriteria();
        List criteriaChain = criteria.getCriteriaChain();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)criteriaChain);
        for (Criteria subCriteria : criteriaChain) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)subCriteria);
            if (!StringUtils.equals((CharSequence)filedName, (CharSequence)subCriteria.getField().getName())) continue;
            return;
        }
        Assertions.fail((String)("Field " + filedName + " not found"));
    }
}

