/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.elasticsearch.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Document(indexName="deed_hub", createIndex=true)
@Setting(replicas=0, shards=1)
public class HubEntity {
    @Id
    @Field(type=FieldType.Keyword)
    private String address;
    @Field(type=FieldType.Long)
    private long nftId;
    @Field(type=FieldType.Short)
    private short city;
    @Field(type=FieldType.Short)
    private short type;
    @Field(type=FieldType.Keyword)
    private String hubOwnerAddress;
    @Field(type=FieldType.Keyword)
    private String deedOwnerAddress;
    @Field(type=FieldType.Keyword)
    private String deedManagerAddress;
    @Field(type=FieldType.Auto)
    private Map<String, String> name;
    @Field(type=FieldType.Auto)
    private Map<String, String> description;
    @Field(type=FieldType.Auto)
    private String url;
    @Field(type=FieldType.Keyword)
    private String color;
    @Field(type=FieldType.Keyword)
    private String avatarId;
    @Field(type=FieldType.Keyword)
    private String bannerId;
    @Field(type=FieldType.Long)
    private long usersCount;
    @Field(type=FieldType.Keyword)
    private String rewardsPeriodType;
    @Field(type=FieldType.Double)
    private double rewardsPerPeriod;
    @Field(type=FieldType.Boolean)
    private boolean enabled;
    @Field(type=FieldType.Double)
    private double ownerClaimableAmount;
    @Field(type=FieldType.Double)
    private double managerClaimableAmount;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    @CreatedDate
    private Instant createdDate = Instant.now();
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    @CreatedDate
    private Instant untilDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    @CreatedDate
    private Instant joinDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    @LastModifiedDate
    private Instant updatedDate = Instant.now();

    public void setAddress(String address) {
        this.address = StringUtils.lowerCase((String)address);
    }

    public void setHubOwnerAddress(String hubOwnerAddress) {
        this.hubOwnerAddress = StringUtils.lowerCase((String)hubOwnerAddress);
    }

    public void setDeedOwnerAddress(String deedOwnerAddress) {
        this.deedOwnerAddress = StringUtils.lowerCase((String)deedOwnerAddress);
    }

    public void setDeedManagerAddress(String deedManagerAddress) {
        this.deedManagerAddress = StringUtils.lowerCase((String)deedManagerAddress);
    }

    @Generated
    public HubEntity() {
    }

    @Generated
    public HubEntity(String address, long nftId, short city, short type, String hubOwnerAddress, String deedOwnerAddress, String deedManagerAddress, Map<String, String> name, Map<String, String> description, String url, String color, String avatarId, String bannerId, long usersCount, String rewardsPeriodType, double rewardsPerPeriod, boolean enabled, double ownerClaimableAmount, double managerClaimableAmount, Instant createdDate, Instant untilDate, Instant joinDate, Instant updatedDate) {
        this.address = address;
        this.nftId = nftId;
        this.city = city;
        this.type = type;
        this.hubOwnerAddress = hubOwnerAddress;
        this.deedOwnerAddress = deedOwnerAddress;
        this.deedManagerAddress = deedManagerAddress;
        this.name = name;
        this.description = description;
        this.url = url;
        this.color = color;
        this.avatarId = avatarId;
        this.bannerId = bannerId;
        this.usersCount = usersCount;
        this.rewardsPeriodType = rewardsPeriodType;
        this.rewardsPerPeriod = rewardsPerPeriod;
        this.enabled = enabled;
        this.ownerClaimableAmount = ownerClaimableAmount;
        this.managerClaimableAmount = managerClaimableAmount;
        this.createdDate = createdDate;
        this.untilDate = untilDate;
        this.joinDate = joinDate;
        this.updatedDate = updatedDate;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public long getNftId() {
        return this.nftId;
    }

    @Generated
    public void setNftId(long nftId) {
        this.nftId = nftId;
    }

    @Generated
    public short getCity() {
        return this.city;
    }

    @Generated
    public void setCity(short city) {
        this.city = city;
    }

    @Generated
    public short getType() {
        return this.type;
    }

    @Generated
    public void setType(short type) {
        this.type = type;
    }

    @Generated
    public String getHubOwnerAddress() {
        return this.hubOwnerAddress;
    }

    @Generated
    public String getDeedOwnerAddress() {
        return this.deedOwnerAddress;
    }

    @Generated
    public String getDeedManagerAddress() {
        return this.deedManagerAddress;
    }

    @Generated
    public Map<String, String> getName() {
        return this.name;
    }

    @Generated
    public void setName(Map<String, String> name) {
        this.name = name;
    }

    @Generated
    public Map<String, String> getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(Map<String, String> description) {
        this.description = description;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public void setColor(String color) {
        this.color = color;
    }

    @Generated
    public String getAvatarId() {
        return this.avatarId;
    }

    @Generated
    public void setAvatarId(String avatarId) {
        this.avatarId = avatarId;
    }

    @Generated
    public String getBannerId() {
        return this.bannerId;
    }

    @Generated
    public void setBannerId(String bannerId) {
        this.bannerId = bannerId;
    }

    @Generated
    public long getUsersCount() {
        return this.usersCount;
    }

    @Generated
    public void setUsersCount(long usersCount) {
        this.usersCount = usersCount;
    }

    @Generated
    public String getRewardsPeriodType() {
        return this.rewardsPeriodType;
    }

    @Generated
    public void setRewardsPeriodType(String rewardsPeriodType) {
        this.rewardsPeriodType = rewardsPeriodType;
    }

    @Generated
    public double getRewardsPerPeriod() {
        return this.rewardsPerPeriod;
    }

    @Generated
    public void setRewardsPerPeriod(double rewardsPerPeriod) {
        this.rewardsPerPeriod = rewardsPerPeriod;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public double getOwnerClaimableAmount() {
        return this.ownerClaimableAmount;
    }

    @Generated
    public void setOwnerClaimableAmount(double ownerClaimableAmount) {
        this.ownerClaimableAmount = ownerClaimableAmount;
    }

    @Generated
    public double getManagerClaimableAmount() {
        return this.managerClaimableAmount;
    }

    @Generated
    public void setManagerClaimableAmount(double managerClaimableAmount) {
        this.managerClaimableAmount = managerClaimableAmount;
    }

    @Generated
    public Instant getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public Instant getUntilDate() {
        return this.untilDate;
    }

    @Generated
    public void setUntilDate(Instant untilDate) {
        this.untilDate = untilDate;
    }

    @Generated
    public Instant getJoinDate() {
        return this.joinDate;
    }

    @Generated
    public void setJoinDate(Instant joinDate) {
        this.joinDate = joinDate;
    }

    @Generated
    public Instant getUpdatedDate() {
        return this.updatedDate;
    }

    @Generated
    public void setUpdatedDate(Instant updatedDate) {
        this.updatedDate = updatedDate;
    }
}

