/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.constant.TenantProvisioningStatus;
import io.meeds.deeds.common.constant.UnauthorizedOperationException;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.elasticsearch.storage.DeedTenantManagerRepository;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TenantService {
    private static final Logger LOG = LoggerFactory.getLogger(TenantService.class);
    @Autowired
    private DeedTenantManagerRepository deedTenantManagerRepository;
    @Autowired
    private BlockchainService blockchainService;
    @Autowired
    private ListenerService listenerService;

    public DeedTenant getDeedTenant(String address, long nftId) throws UnauthorizedOperationException {
        if (!this.isDeedManager(address, nftId) && !this.isDeedOwner(address, nftId)) {
            throw new UnauthorizedOperationException(this.getUnauthorizedMessage(address, nftId));
        }
        return this.getDeedTenant(nftId);
    }

    public short getCardType(long nftId) throws ObjectNotFoundException {
        DeedTenant deedTenant = this.getDeedTenantOrImport(nftId);
        return deedTenant.getCardType();
    }

    public DeedTenant getDeedTenant(long nftId) {
        return this.deedTenantManagerRepository.findById(nftId).orElse(null);
    }

    public List<DeedTenant> getDeedTenants(String ownerAddress) {
        return this.deedTenantManagerRepository.findByOwnerAddress(StringUtils.lowerCase((String)ownerAddress));
    }

    public void saveEmail(String managerAddress, long nftId, String email) throws UnauthorizedOperationException, ObjectNotFoundException {
        if (!this.isDeedManager(managerAddress, nftId)) {
            throw new UnauthorizedOperationException(this.getUnauthorizedMessage(managerAddress, nftId));
        }
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById(nftId).orElse(null);
        if (deedTenant == null) {
            deedTenant = this.buildDeedTenantFromBlockchain(nftId);
        } else {
            this.setDeedNftProperties(deedTenant);
        }
        deedTenant.setManagerAddress(managerAddress.toLowerCase());
        deedTenant.setManagerEmail(email);
        if (deedTenant.getDate() == null) {
            deedTenant.setDate(LocalDateTime.now(ZoneOffset.UTC));
        }
        deedTenant = this.saveDeedTenant(deedTenant);
        this.listenerService.publishEvent("deed.event.tenantEmailUpdated", deedTenant);
    }

    public DeedTenant getDeedTenantOrImport(String managerAddress, Long nftId, boolean refreshFromBlockchain) throws ObjectNotFoundException {
        DeedTenant deedTenant = this.getDeedTenantOrImport(managerAddress, nftId);
        if (refreshFromBlockchain && deedTenant != null) {
            boolean isPending;
            boolean bl = isPending = deedTenant.getTenantProvisioningStatus() != null && deedTenant.getTenantProvisioningStatus().isPending();
            if (isPending) {
                boolean started = this.blockchainService.isDeedStarted(deedTenant.getNftId());
                if (started && deedTenant.getTenantProvisioningStatus().isStart()) {
                    deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.START_CONFIRMED);
                } else if (!started && deedTenant.getTenantProvisioningStatus().isStop()) {
                    deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.STOP_CONFIRMED);
                }
            } else if (this.blockchainService.isDeedStarted(deedTenant.getNftId())) {
                if (StringUtils.isBlank((CharSequence)deedTenant.getStartupTransactionHash())) {
                    deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.START_CONFIRMED);
                } else {
                    deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.START_IN_PROGRESS);
                }
                this.saveDeedTenant(deedTenant);
                deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.START_CONFIRMED);
            } else {
                if (StringUtils.isBlank((CharSequence)deedTenant.getShutdownTransactionHash())) {
                    deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.STOP_CONFIRMED);
                } else {
                    deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.STOP_IN_PROGRESS);
                }
                this.saveDeedTenant(deedTenant);
                deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.STOP_CONFIRMED);
            }
        }
        return deedTenant;
    }

    public DeedTenant getDeedTenantOrImport(String managerAddress, Long nftId) throws ObjectNotFoundException {
        boolean changed;
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById(nftId).orElse(null);
        boolean bl = changed = deedTenant == null;
        if (deedTenant == null) {
            deedTenant = this.buildDeedTenantFromBlockchain(nftId);
            if (StringUtils.isBlank((CharSequence)deedTenant.getManagerAddress()) && this.isDeedManager(managerAddress, nftId)) {
                deedTenant.setManagerAddress(managerAddress.toLowerCase());
            }
            if (StringUtils.isBlank((CharSequence)deedTenant.getOwnerAddress()) && this.isDeedOwner(managerAddress, nftId)) {
                deedTenant.setOwnerAddress(managerAddress.toLowerCase());
            }
        } else if (StringUtils.isNotBlank((CharSequence)managerAddress) && !this.isProvisioningManager(managerAddress, deedTenant)) {
            String deedManager;
            String deedOwner;
            if (this.isDeedOwner(managerAddress, nftId)) {
                deedTenant.setOwnerAddress(managerAddress.toLowerCase());
                changed = true;
            } else if (StringUtils.isBlank((CharSequence)deedTenant.getOwnerAddress()) && StringUtils.isNotBlank((CharSequence)(deedOwner = this.blockchainService.getDeedOwner(nftId)))) {
                deedTenant.setOwnerAddress(deedOwner);
                changed = true;
            }
            if (this.isDeedManager(managerAddress, nftId)) {
                deedTenant.setManagerAddress(managerAddress.toLowerCase());
                changed = true;
            } else if (StringUtils.isBlank((CharSequence)deedTenant.getManagerAddress()) && StringUtils.isNotBlank((CharSequence)(deedManager = this.blockchainService.getDeedManager(nftId)))) {
                deedTenant.setManagerAddress(deedManager);
                changed = true;
            }
        }
        if (changed) {
            return this.saveDeedTenant(deedTenant);
        }
        return deedTenant;
    }

    public DeedTenant getDeedTenantOrImport(Long nftId) throws ObjectNotFoundException {
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById(nftId).orElse(null);
        if (deedTenant == null) {
            deedTenant = this.buildDeedTenantFromBlockchain(nftId);
            deedTenant = this.saveDeedTenant(deedTenant);
        }
        return deedTenant;
    }

    public void markDeedAsAcquired(long nftId, String newManager) throws ObjectNotFoundException, UnauthorizedOperationException {
        LOG.debug("Mark Tenant of {} as aqcuired by new Provisioning Manager: {}", (Object)nftId, (Object)newManager);
        DeedTenant deedTenant = this.getDeedTenantOrImport(newManager, nftId);
        if (!StringUtils.equalsIgnoreCase((CharSequence)deedTenant.getManagerAddress(), (CharSequence)newManager)) {
            throw new UnauthorizedOperationException(newManager + " address isn't the provisioning manager of Tenant in blockchain");
        }
    }

    public void startTenant(String managerAddress, String transactionHash, long nftId, String email) throws UnauthorizedOperationException, ObjectNotFoundException {
        if (!this.isDeedManager(managerAddress, nftId)) {
            throw new UnauthorizedOperationException(this.getUnauthorizedMessage(managerAddress, nftId));
        }
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById(nftId).orElse(null);
        if (deedTenant == null) {
            deedTenant = this.buildDeedTenantFromBlockchain(nftId);
            deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.START_IN_PROGRESS);
        } else {
            this.setDeedNftProperties(deedTenant);
        }
        deedTenant.setManagerAddress(managerAddress.toLowerCase());
        deedTenant.setManagerEmail(email);
        deedTenant.setDate(LocalDateTime.now(ZoneOffset.UTC));
        deedTenant.setStartupTransactionHash(transactionHash);
        deedTenant.setShutdownTransactionHash(null);
        deedTenant = this.saveDeedTenant(deedTenant);
        this.listenerService.publishEvent("deed.event.tenantStart", deedTenant);
    }

    public void stopTenant(String managerAddress, String transactionHash, long nftId) throws UnauthorizedOperationException, ObjectNotFoundException {
        if (!this.isDeedManager(managerAddress, nftId)) {
            throw new UnauthorizedOperationException(this.getUnauthorizedMessage(managerAddress, nftId));
        }
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById(nftId).orElse(null);
        if (deedTenant == null) {
            deedTenant = this.buildDeedTenantFromBlockchain(nftId);
            deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.STOP_IN_PROGRESS);
        } else {
            this.setDeedNftProperties(deedTenant);
        }
        deedTenant.setManagerAddress(managerAddress.toLowerCase());
        deedTenant.setStartupTransactionHash(null);
        deedTenant.setShutdownTransactionHash(transactionHash);
        deedTenant.setDate(LocalDateTime.now(ZoneOffset.UTC));
        this.saveDeedTenant(deedTenant);
        this.listenerService.publishEvent("deed.event.tenantStop", deedTenant);
    }

    public DeedTenant buildDeedTenantFromBlockchain(long nftId) throws ObjectNotFoundException {
        DeedTenant deedTenant = new DeedTenant();
        deedTenant.setNftId(nftId);
        this.setDeedNftProperties(deedTenant);
        deedTenant.setManagerAddress(StringUtils.lowerCase((String)this.blockchainService.getDeedManager(nftId)));
        deedTenant.setOwnerAddress(StringUtils.lowerCase((String)this.blockchainService.getDeedOwner(nftId)));
        if (this.blockchainService.isDeedStarted(deedTenant.getNftId())) {
            deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.START_CONFIRMED);
        } else {
            deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.STOP_CONFIRMED);
        }
        return deedTenant;
    }

    public boolean isDeedManager(String address, long nftId) {
        return this.blockchainService.isDeedProvisioningManager(address, nftId);
    }

    public boolean isDeedOwner(String address, long nftId) {
        return this.blockchainService.isDeedOwner(address, nftId);
    }

    public boolean isTenantCommandStop(long nftId) {
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById(nftId).orElse(null);
        return deedTenant == null || deedTenant.getTenantProvisioningStatus() == null || deedTenant.getTenantProvisioningStatus() == TenantProvisioningStatus.STOP_CONFIRMED;
    }

    public boolean isBlockchainNetworkValid(long networkId) {
        return networkId == this.getBlockchainNetworkId();
    }

    public long getBlockchainNetworkId() {
        try {
            return this.blockchainService.getNetworkId();
        }
        catch (Exception e) {
            LOG.warn("Error getting network id: {}", (Object)e.getMessage());
            return 1L;
        }
    }

    public DeedTenant saveDeedTenant(DeedTenant deedTenant) {
        return (DeedTenant)this.deedTenantManagerRepository.save(deedTenant);
    }

    private void setDeedNftProperties(DeedTenant deedTenant) throws ObjectNotFoundException {
        if (deedTenant.getCardType() < 0 || deedTenant.getCityIndex() < 0) {
            short cardType = this.blockchainService.getDeedCardType(deedTenant.getNftId());
            deedTenant.setCardType(cardType);
            short cityIndex = this.blockchainService.getDeedCityIndex(deedTenant.getNftId());
            deedTenant.setCityIndex(cityIndex);
        }
    }

    private String getUnauthorizedMessage(String managerAddress, long nftId) {
        return "User with address " + managerAddress + " isn't the manager of deed " + nftId;
    }

    private boolean isProvisioningManager(String managerAddress, DeedTenant deedTenant) {
        return StringUtils.equalsIgnoreCase((CharSequence)deedTenant.getManagerAddress(), (CharSequence)managerAddress) || StringUtils.equalsIgnoreCase((CharSequence)deedTenant.getOwnerAddress(), (CharSequence)managerAddress);
    }
}

