package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint32;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple4;
import org.web3j.tuples.generated.Tuple7;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 4.8.9.
 */
@SuppressWarnings("rawtypes")
public class XMeedsNFTRewarding extends Contract {
    public static final String BINARY = "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";

    public static final String FUNC_ALLOWANCE = "allowance";

    public static final String FUNC_APPROVE = "approve";

    public static final String FUNC_BALANCEOF = "balanceOf";

    public static final String FUNC_CARDTYPEINFO = "cardTypeInfo";

    public static final String FUNC_CITYINFO = "cityInfo";

    public static final String FUNC_CITYMINTINGSTARTDATE = "cityMintingStartDate";

    public static final String FUNC_CURRENTCITYINDEX = "currentCityIndex";

    public static final String FUNC_DECIMALS = "decimals";

    public static final String FUNC_DECREASEALLOWANCE = "decreaseAllowance";

    public static final String FUNC_EARNED = "earned";

    public static final String FUNC_EXIT = "exit";

    public static final String FUNC_INCREASEALLOWANCE = "increaseAllowance";

    public static final String FUNC_ISCURRENTCITYMINTABLE = "isCurrentCityMintable";

    public static final String FUNC_ISOWNER = "isOwner";

    public static final String FUNC_LASTCITYMINTINGCOMPLETEDATE = "lastCityMintingCompleteDate";

    public static final String FUNC_MEED = "meed";

    public static final String FUNC_NAME = "name";

    public static final String FUNC_NFT = "nft";

    public static final String FUNC_OWNER = "owner";

    public static final String FUNC_REDEEM = "redeem";

    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";

    public static final String FUNC_REWARDDISTRIBUTION = "rewardDistribution";

    public static final String FUNC_SETNFT = "setNFT";

    public static final String FUNC_STAKE = "stake";

    public static final String FUNC_STARTREWARDSTIME = "startRewardsTime";

    public static final String FUNC_SYMBOL = "symbol";

    public static final String FUNC_TOTALSUPPLY = "totalSupply";

    public static final String FUNC_TRANSFER = "transfer";

    public static final String FUNC_TRANSFERFROM = "transferFrom";

    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";

    public static final String FUNC_WITHDRAW = "withdraw";

    public static final Event APPROVAL_EVENT = new Event("Approval", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event NFTSET_EVENT = new Event("NFTSet", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}));
    ;

    public static final Event REDEEMED_EVENT = new Event("Redeemed", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Utf8String>() {}, new TypeReference<Utf8String>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event STAKED_EVENT = new Event("Staked", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event TRANSFER_EVENT = new Event("Transfer", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event WITHDRAWN_EVENT = new Event("Withdrawn", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    @Deprecated
    protected XMeedsNFTRewarding(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected XMeedsNFTRewarding(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected XMeedsNFTRewarding(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected XMeedsNFTRewarding(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.spender = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse.value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, ApprovalEventResponse>() {
            @Override
            public ApprovalEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(APPROVAL_EVENT, log);
                ApprovalEventResponse typedResponse = new ApprovalEventResponse();
                typedResponse.log = log;
                typedResponse.owner = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.spender = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse.value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(APPROVAL_EVENT));
        return approvalEventFlowable(filter);
    }

    public List<NFTSetEventResponse> getNFTSetEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(NFTSET_EVENT, transactionReceipt);
        ArrayList<NFTSetEventResponse> responses = new ArrayList<NFTSetEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NFTSetEventResponse typedResponse = new NFTSetEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newNFT = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<NFTSetEventResponse> nFTSetEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, NFTSetEventResponse>() {
            @Override
            public NFTSetEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(NFTSET_EVENT, log);
                NFTSetEventResponse typedResponse = new NFTSetEventResponse();
                typedResponse.log = log;
                typedResponse.newNFT = (String) eventValues.getIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<NFTSetEventResponse> nFTSetEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(NFTSET_EVENT));
        return nFTSetEventFlowable(filter);
    }

    public List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, OwnershipTransferredEventResponse>() {
            @Override
            public OwnershipTransferredEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, log);
                OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
                typedResponse.log = log;
                typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(OWNERSHIPTRANSFERRED_EVENT));
        return ownershipTransferredEventFlowable(filter);
    }

    public List<RedeemedEventResponse> getRedeemedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(REDEEMED_EVENT, transactionReceipt);
        ArrayList<RedeemedEventResponse> responses = new ArrayList<RedeemedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RedeemedEventResponse typedResponse = new RedeemedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.city = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.cardType = (String) eventValues.getNonIndexedValues().get(1).getValue();
            typedResponse.id = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<RedeemedEventResponse> redeemedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, RedeemedEventResponse>() {
            @Override
            public RedeemedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(REDEEMED_EVENT, log);
                RedeemedEventResponse typedResponse = new RedeemedEventResponse();
                typedResponse.log = log;
                typedResponse.user = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.city = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.cardType = (String) eventValues.getNonIndexedValues().get(1).getValue();
                typedResponse.id = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<RedeemedEventResponse> redeemedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(REDEEMED_EVENT));
        return redeemedEventFlowable(filter);
    }

    public List<StakedEventResponse> getStakedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(STAKED_EVENT, transactionReceipt);
        ArrayList<StakedEventResponse> responses = new ArrayList<StakedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            StakedEventResponse typedResponse = new StakedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<StakedEventResponse> stakedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, StakedEventResponse>() {
            @Override
            public StakedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(STAKED_EVENT, log);
                StakedEventResponse typedResponse = new StakedEventResponse();
                typedResponse.log = log;
                typedResponse.user = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<StakedEventResponse> stakedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(STAKED_EVENT));
        return stakedEventFlowable(filter);
    }

    public List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.to = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse.value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferEventResponse> transferEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, TransferEventResponse>() {
            @Override
            public TransferEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.to = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse.value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferEventResponse> transferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFER_EVENT));
        return transferEventFlowable(filter);
    }

    public List<WithdrawnEventResponse> getWithdrawnEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(WITHDRAWN_EVENT, transactionReceipt);
        ArrayList<WithdrawnEventResponse> responses = new ArrayList<WithdrawnEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            WithdrawnEventResponse typedResponse = new WithdrawnEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<WithdrawnEventResponse> withdrawnEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, WithdrawnEventResponse>() {
            @Override
            public WithdrawnEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(WITHDRAWN_EVENT, log);
                WithdrawnEventResponse typedResponse = new WithdrawnEventResponse();
                typedResponse.log = log;
                typedResponse.user = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<WithdrawnEventResponse> withdrawnEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(WITHDRAWN_EVENT));
        return withdrawnEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> allowance(String owner, String spender) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ALLOWANCE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, owner), 
                new org.web3j.abi.datatypes.Address(160, spender)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> approve(String spender, BigInteger amount) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_APPROVE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, spender), 
                new org.web3j.abi.datatypes.generated.Uint256(amount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Tuple7<String, String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>> cardTypeInfo(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CARDTYPEINFO, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}, new TypeReference<Utf8String>() {}, new TypeReference<Uint8>() {}, new TypeReference<Uint8>() {}, new TypeReference<Uint32>() {}, new TypeReference<Uint32>() {}, new TypeReference<Uint256>() {}));
        return new RemoteFunctionCall<Tuple7<String, String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>>(function,
                new Callable<Tuple7<String, String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>>() {
                    @Override
                    public Tuple7<String, String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple7<String, String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>(
                                (String) results.get(0).getValue(), 
                                (String) results.get(1).getValue(), 
                                (BigInteger) results.get(2).getValue(), 
                                (BigInteger) results.get(3).getValue(), 
                                (BigInteger) results.get(4).getValue(), 
                                (BigInteger) results.get(5).getValue(), 
                                (BigInteger) results.get(6).getValue());
                    }
                });
    }

    public RemoteFunctionCall<Tuple4<String, BigInteger, BigInteger, BigInteger>> cityInfo(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CITYINFO, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}, new TypeReference<Uint32>() {}, new TypeReference<Uint32>() {}, new TypeReference<Uint256>() {}));
        return new RemoteFunctionCall<Tuple4<String, BigInteger, BigInteger, BigInteger>>(function,
                new Callable<Tuple4<String, BigInteger, BigInteger, BigInteger>>() {
                    @Override
                    public Tuple4<String, BigInteger, BigInteger, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple4<String, BigInteger, BigInteger, BigInteger>(
                                (String) results.get(0).getValue(), 
                                (BigInteger) results.get(1).getValue(), 
                                (BigInteger) results.get(2).getValue(), 
                                (BigInteger) results.get(3).getValue());
                    }
                });
    }

    public RemoteFunctionCall<BigInteger> cityMintingStartDate() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CITYMINTINGSTARTDATE, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> currentCityIndex() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CURRENTCITYINDEX, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> decimals() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DECIMALS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> decreaseAllowance(String spender, BigInteger subtractedValue) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_DECREASEALLOWANCE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, spender), 
                new org.web3j.abi.datatypes.generated.Uint256(subtractedValue)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> earned(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_EARNED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> exit() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_EXIT, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> increaseAllowance(String spender, BigInteger addedValue) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_INCREASEALLOWANCE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, spender), 
                new org.web3j.abi.datatypes.generated.Uint256(addedValue)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isCurrentCityMintable() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISCURRENTCITYMINTABLE, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISOWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> lastCityMintingCompleteDate() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_LASTCITYMINTINGCOMPLETEDATE, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> meed() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MEED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> name() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NAME, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> nft() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NFT, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> owner() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> redeem(BigInteger cardTypeId) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_REDEEM, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint8(cardTypeId)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_RENOUNCEOWNERSHIP, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> rewardDistribution() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REWARDDISTRIBUTION, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> setNFT(String _nftAddress) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_SETNFT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _nftAddress)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> stake(BigInteger amount) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_STAKE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(amount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> startRewardsTime() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_STARTREWARDSTIME, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> symbol() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SYMBOL, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> totalSupply() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOTALSUPPLY, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transfer(String recipient, BigInteger amount) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_TRANSFER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, recipient), 
                new org.web3j.abi.datatypes.generated.Uint256(amount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferFrom(String sender, String recipient, BigInteger amount) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_TRANSFERFROM, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, sender), 
                new org.web3j.abi.datatypes.Address(160, recipient), 
                new org.web3j.abi.datatypes.generated.Uint256(amount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_TRANSFEROWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newOwner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> withdraw(BigInteger amount) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_WITHDRAW, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(amount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    @Deprecated
    public static XMeedsNFTRewarding load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new XMeedsNFTRewarding(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static XMeedsNFTRewarding load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new XMeedsNFTRewarding(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static XMeedsNFTRewarding load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new XMeedsNFTRewarding(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static XMeedsNFTRewarding load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new XMeedsNFTRewarding(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<XMeedsNFTRewarding> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _meed, String _rewardDistribution, String _nftAddress, BigInteger _startRewardsTime, List<String> _cityNames, List<String> _cardNames, List<BigInteger> _cardPrices, List<BigInteger> _cardSupply, List<String> _uris) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _meed), 
                new org.web3j.abi.datatypes.Address(160, _rewardDistribution), 
                new org.web3j.abi.datatypes.Address(160, _nftAddress), 
                new org.web3j.abi.datatypes.generated.Uint256(_startRewardsTime), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_cityNames, org.web3j.abi.datatypes.Utf8String.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_cardNames, org.web3j.abi.datatypes.Utf8String.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(_cardPrices, org.web3j.abi.datatypes.generated.Uint256.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint32>(
                        org.web3j.abi.datatypes.generated.Uint32.class,
                        org.web3j.abi.Utils.typeMap(_cardSupply, org.web3j.abi.datatypes.generated.Uint32.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_uris, org.web3j.abi.datatypes.Utf8String.class))));
        return deployRemoteCall(XMeedsNFTRewarding.class, web3j, credentials, contractGasProvider, BINARY, encodedConstructor);
    }

    public static RemoteCall<XMeedsNFTRewarding> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _meed, String _rewardDistribution, String _nftAddress, BigInteger _startRewardsTime, List<String> _cityNames, List<String> _cardNames, List<BigInteger> _cardPrices, List<BigInteger> _cardSupply, List<String> _uris) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _meed), 
                new org.web3j.abi.datatypes.Address(160, _rewardDistribution), 
                new org.web3j.abi.datatypes.Address(160, _nftAddress), 
                new org.web3j.abi.datatypes.generated.Uint256(_startRewardsTime), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_cityNames, org.web3j.abi.datatypes.Utf8String.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_cardNames, org.web3j.abi.datatypes.Utf8String.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(_cardPrices, org.web3j.abi.datatypes.generated.Uint256.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint32>(
                        org.web3j.abi.datatypes.generated.Uint32.class,
                        org.web3j.abi.Utils.typeMap(_cardSupply, org.web3j.abi.datatypes.generated.Uint32.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_uris, org.web3j.abi.datatypes.Utf8String.class))));
        return deployRemoteCall(XMeedsNFTRewarding.class, web3j, transactionManager, contractGasProvider, BINARY, encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<XMeedsNFTRewarding> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _meed, String _rewardDistribution, String _nftAddress, BigInteger _startRewardsTime, List<String> _cityNames, List<String> _cardNames, List<BigInteger> _cardPrices, List<BigInteger> _cardSupply, List<String> _uris) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _meed), 
                new org.web3j.abi.datatypes.Address(160, _rewardDistribution), 
                new org.web3j.abi.datatypes.Address(160, _nftAddress), 
                new org.web3j.abi.datatypes.generated.Uint256(_startRewardsTime), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_cityNames, org.web3j.abi.datatypes.Utf8String.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_cardNames, org.web3j.abi.datatypes.Utf8String.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(_cardPrices, org.web3j.abi.datatypes.generated.Uint256.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint32>(
                        org.web3j.abi.datatypes.generated.Uint32.class,
                        org.web3j.abi.Utils.typeMap(_cardSupply, org.web3j.abi.datatypes.generated.Uint32.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_uris, org.web3j.abi.datatypes.Utf8String.class))));
        return deployRemoteCall(XMeedsNFTRewarding.class, web3j, credentials, gasPrice, gasLimit, BINARY, encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<XMeedsNFTRewarding> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _meed, String _rewardDistribution, String _nftAddress, BigInteger _startRewardsTime, List<String> _cityNames, List<String> _cardNames, List<BigInteger> _cardPrices, List<BigInteger> _cardSupply, List<String> _uris) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _meed), 
                new org.web3j.abi.datatypes.Address(160, _rewardDistribution), 
                new org.web3j.abi.datatypes.Address(160, _nftAddress), 
                new org.web3j.abi.datatypes.generated.Uint256(_startRewardsTime), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_cityNames, org.web3j.abi.datatypes.Utf8String.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_cardNames, org.web3j.abi.datatypes.Utf8String.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(_cardPrices, org.web3j.abi.datatypes.generated.Uint256.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint32>(
                        org.web3j.abi.datatypes.generated.Uint32.class,
                        org.web3j.abi.Utils.typeMap(_cardSupply, org.web3j.abi.datatypes.generated.Uint32.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_uris, org.web3j.abi.datatypes.Utf8String.class))));
        return deployRemoteCall(XMeedsNFTRewarding.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, encodedConstructor);
    }

    public static class ApprovalEventResponse extends BaseEventResponse {
        public String owner;

        public String spender;

        public BigInteger value;
    }

    public static class NFTSetEventResponse extends BaseEventResponse {
        public String newNFT;
    }

    public static class OwnershipTransferredEventResponse extends BaseEventResponse {
        public String previousOwner;

        public String newOwner;
    }

    public static class RedeemedEventResponse extends BaseEventResponse {
        public String user;

        public String city;

        public String cardType;

        public BigInteger id;
    }

    public static class StakedEventResponse extends BaseEventResponse {
        public String user;

        public BigInteger amount;
    }

    public static class TransferEventResponse extends BaseEventResponse {
        public String from;

        public String to;

        public BigInteger value;
    }

    public static class WithdrawnEventResponse extends BaseEventResponse {
        public String user;

        public BigInteger amount;
    }
}
