/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class XMeedsToken
extends Contract {
    public static final String BINARY = "";
    public static final String FUNC_ALLOWANCE = "allowance";
    public static final String FUNC_APPROVE = "approve";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_DECIMALS = "decimals";
    public static final String FUNC_DECREASEALLOWANCE = "decreaseAllowance";
    public static final String FUNC_INCREASEALLOWANCE = "increaseAllowance";
    public static final String FUNC_ISOWNER = "isOwner";
    public static final String FUNC_MEED = "meed";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";
    public static final String FUNC_REWARDDISTRIBUTION = "rewardDistribution";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_TRANSFER = "transfer";
    public static final String FUNC_TRANSFERFROM = "transferFrom";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final Event APPROVAL_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));

    @Deprecated
    protected XMeedsToken(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected XMeedsToken(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected XMeedsToken(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected XMeedsToken(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovalEventResponse>(){

            public ApprovalEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = XMeedsToken.this.extractEventParametersWithLog(APPROVAL_EVENT, log);
                ApprovalEventResponse typedResponse = new ApprovalEventResponse();
                typedResponse.log = log;
                typedResponse.owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVAL_EVENT));
        return this.approvalEventFlowable(filter);
    }

    public List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, OwnershipTransferredEventResponse>(){

            public OwnershipTransferredEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = XMeedsToken.this.extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, log);
                OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
                typedResponse.log = log;
                typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OWNERSHIPTRANSFERRED_EVENT));
        return this.ownershipTransferredEventFlowable(filter);
    }

    public List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferEventResponse> transferEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferEventResponse>(){

            public TransferEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = XMeedsToken.this.extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferEventResponse> transferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFER_EVENT));
        return this.transferEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> allowance(String owner, String spender) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ALLOWANCE, Arrays.asList(new Address(160, owner), new Address(160, spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> approve(String spender, BigInteger amount) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_APPROVE, Arrays.asList(new Address(160, spender), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOF, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> decimals() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DECIMALS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> decreaseAllowance(String spender, BigInteger subtractedValue) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DECREASEALLOWANCE, Arrays.asList(new Address(160, spender), new Uint256(subtractedValue)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> increaseAllowance(String spender, BigInteger addedValue) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_INCREASEALLOWANCE, Arrays.asList(new Address(160, spender), new Uint256(addedValue)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISOWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> meed() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MEED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> name() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> owner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_RENOUNCEOWNERSHIP, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> rewardDistribution() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REWARDDISTRIBUTION, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> symbol() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> totalSupply() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOTALSUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transfer(String recipient, BigInteger amount) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFER, Arrays.asList(new Address(160, recipient), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferFrom(String sender, String recipient, BigInteger amount) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFERFROM, Arrays.asList(new Address(160, sender), new Address(160, recipient), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    @Deprecated
    public static XMeedsToken load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new XMeedsToken(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static XMeedsToken load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new XMeedsToken(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static XMeedsToken load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new XMeedsToken(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static XMeedsToken load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new XMeedsToken(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<XMeedsToken> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return XMeedsToken.deployRemoteCall(XMeedsToken.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)BINARY);
    }

    @Deprecated
    public static RemoteCall<XMeedsToken> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return XMeedsToken.deployRemoteCall(XMeedsToken.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)BINARY);
    }

    public static RemoteCall<XMeedsToken> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return XMeedsToken.deployRemoteCall(XMeedsToken.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)BINARY);
    }

    @Deprecated
    public static RemoteCall<XMeedsToken> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return XMeedsToken.deployRemoteCall(XMeedsToken.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)BINARY);
    }

    public static class TransferEventResponse
    extends BaseEventResponse {
        public String from;
        public String to;
        public BigInteger value;
    }

    public static class OwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class ApprovalEventResponse
    extends BaseEventResponse {
        public String owner;
        public String spender;
        public BigInteger value;
    }
}

