/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class ERC20
extends Contract {
    public static final String BINARY = "";
    public static final String FUNC_ALLOWANCE = "allowance";
    public static final String FUNC_APPROVE = "approve";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_DECIMALS = "decimals";
    public static final String FUNC_DECREASEALLOWANCE = "decreaseAllowance";
    public static final String FUNC_INCREASEALLOWANCE = "increaseAllowance";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_TRANSFER = "transfer";
    public static final String FUNC_TRANSFERFROM = "transferFrom";
    public static final Event APPROVAL_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));

    @Deprecated
    protected ERC20(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERC20(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERC20(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERC20(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List valueList = ERC20.staticExtractEventParametersWithLog((Event)APPROVAL_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovalEventResponse>(){

            public ApprovalEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERC20.this.extractEventParametersWithLog(APPROVAL_EVENT, log);
                ApprovalEventResponse typedResponse = new ApprovalEventResponse();
                typedResponse.log = log;
                typedResponse.owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVAL_EVENT));
        return this.approvalEventFlowable(filter);
    }

    public static List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List valueList = ERC20.staticExtractEventParametersWithLog((Event)TRANSFER_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferEventResponse> transferEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferEventResponse>(){

            public TransferEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERC20.this.extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferEventResponse> transferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFER_EVENT));
        return this.transferEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> allowance(String owner, String spender) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ALLOWANCE, Arrays.asList(new Address(160, owner), new Address(160, spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> approve(String spender, BigInteger amount) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_APPROVE, Arrays.asList(new Address(160, spender), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOF, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> decimals() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DECIMALS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> decreaseAllowance(String spender, BigInteger subtractedValue) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DECREASEALLOWANCE, Arrays.asList(new Address(160, spender), new Uint256(subtractedValue)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> increaseAllowance(String spender, BigInteger addedValue) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_INCREASEALLOWANCE, Arrays.asList(new Address(160, spender), new Uint256(addedValue)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> name() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> symbol() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> totalSupply() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOTALSUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transfer(String recipient, BigInteger amount) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFER, Arrays.asList(new Address(160, recipient), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferFrom(String sender, String recipient, BigInteger amount) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFERFROM, Arrays.asList(new Address(160, sender), new Address(160, recipient), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    @Deprecated
    public static ERC20 load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERC20(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERC20 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERC20(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERC20 load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERC20(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERC20 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERC20(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<ERC20> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return ERC20.deployRemoteCall(ERC20.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)BINARY);
    }

    @Deprecated
    public static RemoteCall<ERC20> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return ERC20.deployRemoteCall(ERC20.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)BINARY);
    }

    public static RemoteCall<ERC20> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return ERC20.deployRemoteCall(ERC20.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)BINARY);
    }

    @Deprecated
    public static RemoteCall<ERC20> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return ERC20.deployRemoteCall(ERC20.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)BINARY);
    }

    public static class ApprovalEventResponse
    extends BaseEventResponse {
        public String owner;
        public String spender;
        public BigInteger value;
    }

    public static class TransferEventResponse
    extends BaseEventResponse {
        public String from;
        public String to;
        public BigInteger value;
    }
}

