/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple2;
import org.web3j.tuples.generated.Tuple5;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class TokenFactory
extends Contract {
    public static final String BINARY = "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";
    public static final String FUNC_MAX_MEED_SUPPLY = "MAX_MEED_SUPPLY";
    public static final String FUNC_MEED_REWARDING_PRECISION = "MEED_REWARDING_PRECISION";
    public static final String FUNC_ADDFUND = "addFund";
    public static final String FUNC_ADDLPTOKEN = "addLPToken";
    public static final String FUNC_BATCHSENDREWARDS = "batchSendRewards";
    public static final String FUNC_DEPOSIT = "deposit";
    public static final String FUNC_EMERGENCYWITHDRAW = "emergencyWithdraw";
    public static final String FUNC_FUNDADDRESSES = "fundAddresses";
    public static final String FUNC_FUNDINFOS = "fundInfos";
    public static final String FUNC_FUNDSLENGTH = "fundsLength";
    public static final String FUNC_HARVEST = "harvest";
    public static final String FUNC_ISOWNER = "isOwner";
    public static final String FUNC_MEED = "meed";
    public static final String FUNC_MEEDPERMINUTE = "meedPerMinute";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_pendingRewardBalanceOf = "pendingRewardBalanceOf";
    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";
    public static final String FUNC_SENDALLREWARDS = "sendAllRewards";
    public static final String FUNC_SENDREWARD = "sendReward";
    public static final String FUNC_SETMEEDPERMINUTE = "setMeedPerMinute";
    public static final String FUNC_STARTREWARDSTIME = "startRewardsTime";
    public static final String FUNC_TOTALALLOCATIONPOINTS = "totalAllocationPoints";
    public static final String FUNC_TOTALFIXEDPERCENTAGE = "totalFixedPercentage";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_UPDATEALLOCATION = "updateAllocation";
    public static final String FUNC_USERLPINFOS = "userLpInfos";
    public static final String FUNC_WITHDRAW = "withdraw";
    public static final Event DEPOSIT_EVENT = new Event("Deposit", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event EMERGENCYWITHDRAW_EVENT = new Event("EmergencyWithdraw", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event FUNDADDED_EVENT = new Event("FundAdded", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}, new TypeReference<Bool>(){}, new TypeReference<Bool>(){}));
    public static final Event FUNDALLOCATIONCHANGED_EVENT = new Event("FundAllocationChanged", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}, new TypeReference<Bool>(){}));
    public static final Event HARVEST_EVENT = new Event("Harvest", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event MAXSUPPLYREACHED_EVENT = new Event("MaxSupplyReached", Arrays.asList(new TypeReference<Uint256>(){}));
    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));
    public static final Event WITHDRAW_EVENT = new Event("Withdraw", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));

    @Deprecated
    protected TokenFactory(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected TokenFactory(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected TokenFactory(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected TokenFactory(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<DepositEventResponse> getDepositEvents(TransactionReceipt transactionReceipt) {
        List valueList = TokenFactory.staticExtractEventParametersWithLog((Event)DEPOSIT_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<DepositEventResponse> responses = new ArrayList<DepositEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositEventResponse typedResponse = new DepositEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.lpAddress = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static DepositEventResponse getDepositEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TokenFactory.staticExtractEventParametersWithLog((Event)DEPOSIT_EVENT, (Log)log);
        DepositEventResponse typedResponse = new DepositEventResponse();
        typedResponse.log = log;
        typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.lpAddress = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<DepositEventResponse> depositEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TokenFactory.getDepositEventFromLog(log));
    }

    public Flowable<DepositEventResponse> depositEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DEPOSIT_EVENT));
        return this.depositEventFlowable(filter);
    }

    public static List<EmergencyWithdrawEventResponse> getEmergencyWithdrawEvents(TransactionReceipt transactionReceipt) {
        List valueList = TokenFactory.staticExtractEventParametersWithLog((Event)EMERGENCYWITHDRAW_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<EmergencyWithdrawEventResponse> responses = new ArrayList<EmergencyWithdrawEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            EmergencyWithdrawEventResponse typedResponse = new EmergencyWithdrawEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.lpAddress = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static EmergencyWithdrawEventResponse getEmergencyWithdrawEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TokenFactory.staticExtractEventParametersWithLog((Event)EMERGENCYWITHDRAW_EVENT, (Log)log);
        EmergencyWithdrawEventResponse typedResponse = new EmergencyWithdrawEventResponse();
        typedResponse.log = log;
        typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.lpAddress = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<EmergencyWithdrawEventResponse> emergencyWithdrawEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TokenFactory.getEmergencyWithdrawEventFromLog(log));
    }

    public Flowable<EmergencyWithdrawEventResponse> emergencyWithdrawEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)EMERGENCYWITHDRAW_EVENT));
        return this.emergencyWithdrawEventFlowable(filter);
    }

    public static List<FundAddedEventResponse> getFundAddedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TokenFactory.staticExtractEventParametersWithLog((Event)FUNDADDED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<FundAddedEventResponse> responses = new ArrayList<FundAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            FundAddedEventResponse typedResponse = new FundAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.fundAddress = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.allocation = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.fixedPercentage = (Boolean)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.isLPToken = (Boolean)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static FundAddedEventResponse getFundAddedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TokenFactory.staticExtractEventParametersWithLog((Event)FUNDADDED_EVENT, (Log)log);
        FundAddedEventResponse typedResponse = new FundAddedEventResponse();
        typedResponse.log = log;
        typedResponse.fundAddress = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.allocation = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        typedResponse.fixedPercentage = (Boolean)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
        typedResponse.isLPToken = (Boolean)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
        return typedResponse;
    }

    public Flowable<FundAddedEventResponse> fundAddedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TokenFactory.getFundAddedEventFromLog(log));
    }

    public Flowable<FundAddedEventResponse> fundAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)FUNDADDED_EVENT));
        return this.fundAddedEventFlowable(filter);
    }

    public static List<FundAllocationChangedEventResponse> getFundAllocationChangedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TokenFactory.staticExtractEventParametersWithLog((Event)FUNDALLOCATIONCHANGED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<FundAllocationChangedEventResponse> responses = new ArrayList<FundAllocationChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            FundAllocationChangedEventResponse typedResponse = new FundAllocationChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.fundAddress = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.allocation = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.fixedPercentage = (Boolean)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static FundAllocationChangedEventResponse getFundAllocationChangedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TokenFactory.staticExtractEventParametersWithLog((Event)FUNDALLOCATIONCHANGED_EVENT, (Log)log);
        FundAllocationChangedEventResponse typedResponse = new FundAllocationChangedEventResponse();
        typedResponse.log = log;
        typedResponse.fundAddress = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.allocation = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        typedResponse.fixedPercentage = (Boolean)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<FundAllocationChangedEventResponse> fundAllocationChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TokenFactory.getFundAllocationChangedEventFromLog(log));
    }

    public Flowable<FundAllocationChangedEventResponse> fundAllocationChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)FUNDALLOCATIONCHANGED_EVENT));
        return this.fundAllocationChangedEventFlowable(filter);
    }

    public static List<HarvestEventResponse> getHarvestEvents(TransactionReceipt transactionReceipt) {
        List valueList = TokenFactory.staticExtractEventParametersWithLog((Event)HARVEST_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<HarvestEventResponse> responses = new ArrayList<HarvestEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            HarvestEventResponse typedResponse = new HarvestEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.lpAddress = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static HarvestEventResponse getHarvestEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TokenFactory.staticExtractEventParametersWithLog((Event)HARVEST_EVENT, (Log)log);
        HarvestEventResponse typedResponse = new HarvestEventResponse();
        typedResponse.log = log;
        typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.lpAddress = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<HarvestEventResponse> harvestEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TokenFactory.getHarvestEventFromLog(log));
    }

    public Flowable<HarvestEventResponse> harvestEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)HARVEST_EVENT));
        return this.harvestEventFlowable(filter);
    }

    public static List<MaxSupplyReachedEventResponse> getMaxSupplyReachedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TokenFactory.staticExtractEventParametersWithLog((Event)MAXSUPPLYREACHED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<MaxSupplyReachedEventResponse> responses = new ArrayList<MaxSupplyReachedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MaxSupplyReachedEventResponse typedResponse = new MaxSupplyReachedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.timestamp = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static MaxSupplyReachedEventResponse getMaxSupplyReachedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TokenFactory.staticExtractEventParametersWithLog((Event)MAXSUPPLYREACHED_EVENT, (Log)log);
        MaxSupplyReachedEventResponse typedResponse = new MaxSupplyReachedEventResponse();
        typedResponse.log = log;
        typedResponse.timestamp = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<MaxSupplyReachedEventResponse> maxSupplyReachedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TokenFactory.getMaxSupplyReachedEventFromLog(log));
    }

    public Flowable<MaxSupplyReachedEventResponse> maxSupplyReachedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MAXSUPPLYREACHED_EVENT));
        return this.maxSupplyReachedEventFlowable(filter);
    }

    public static List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = TokenFactory.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OwnershipTransferredEventResponse getOwnershipTransferredEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TokenFactory.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (Log)log);
        OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
        typedResponse.log = log;
        typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TokenFactory.getOwnershipTransferredEventFromLog(log));
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OWNERSHIPTRANSFERRED_EVENT));
        return this.ownershipTransferredEventFlowable(filter);
    }

    public static List<WithdrawEventResponse> getWithdrawEvents(TransactionReceipt transactionReceipt) {
        List valueList = TokenFactory.staticExtractEventParametersWithLog((Event)WITHDRAW_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<WithdrawEventResponse> responses = new ArrayList<WithdrawEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            WithdrawEventResponse typedResponse = new WithdrawEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.lpAddress = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static WithdrawEventResponse getWithdrawEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TokenFactory.staticExtractEventParametersWithLog((Event)WITHDRAW_EVENT, (Log)log);
        WithdrawEventResponse typedResponse = new WithdrawEventResponse();
        typedResponse.log = log;
        typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.lpAddress = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<WithdrawEventResponse> withdrawEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TokenFactory.getWithdrawEventFromLog(log));
    }

    public Flowable<WithdrawEventResponse> withdrawEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)WITHDRAW_EVENT));
        return this.withdrawEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> MAX_MEED_SUPPLY() {
        Function function = new Function(FUNC_MAX_MEED_SUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> MEED_REWARDING_PRECISION() {
        Function function = new Function(FUNC_MEED_REWARDING_PRECISION, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> addFund(String _fundAddress, BigInteger _value, Boolean _isFixedPercentage) {
        Function function = new Function(FUNC_ADDFUND, Arrays.asList(new Address(160, _fundAddress), new Uint256(_value), new Bool(_isFixedPercentage)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> addLPToken(String _lpToken, BigInteger _value, Boolean _isFixedPercentage) {
        Function function = new Function(FUNC_ADDLPTOKEN, Arrays.asList(new Address(160, _lpToken), new Uint256(_value), new Bool(_isFixedPercentage)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> batchSendRewards(List<String> _fundAddresses) {
        Function function = new Function(FUNC_BATCHSENDREWARDS, Arrays.asList(new DynamicArray(Address.class, Utils.typeMap(_fundAddresses, Address.class))), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> deposit(String _lpToken, BigInteger _amount) {
        Function function = new Function(FUNC_DEPOSIT, Arrays.asList(new Address(160, _lpToken), new Uint256(_amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> emergencyWithdraw(String _lpToken) {
        Function function = new Function(FUNC_EMERGENCYWITHDRAW, Arrays.asList(new Address(160, _lpToken)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> fundAddresses(BigInteger param0) {
        Function function = new Function(FUNC_FUNDADDRESSES, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, Boolean>> fundInfos(String param0) {
        final Function function = new Function(FUNC_FUNDINFOS, Arrays.asList(new Address(160, param0)), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Bool>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, Boolean>>(){

            @Override
            public Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, Boolean> call() throws Exception {
                List results = TokenFactory.this.executeCallMultipleValueReturn(function);
                return new Tuple5((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()), (Object)((BigInteger)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()), (Object)((Boolean)((Type)results.get(4)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<BigInteger> fundsLength() {
        Function function = new Function(FUNC_FUNDSLENGTH, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> harvest(String _lpAddress) {
        Function function = new Function(FUNC_HARVEST, Arrays.asList(new Address(160, _lpAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        Function function = new Function(FUNC_ISOWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> meed() {
        Function function = new Function(FUNC_MEED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> meedPerMinute() {
        Function function = new Function(FUNC_MEEDPERMINUTE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> owner() {
        Function function = new Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> pendingRewardBalanceOf(String _fundAddress) {
        Function function = new Function(FUNC_pendingRewardBalanceOf, Arrays.asList(new Address(160, _fundAddress)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> pendingRewardBalanceOf(String _lpToken, String _user) {
        Function function = new Function(FUNC_pendingRewardBalanceOf, Arrays.asList(new Address(160, _lpToken), new Address(160, _user)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        Function function = new Function(FUNC_RENOUNCEOWNERSHIP, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> sendAllRewards() {
        Function function = new Function(FUNC_SENDALLREWARDS, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> sendReward(String _fundAddress) {
        Function function = new Function(FUNC_SENDREWARD, Arrays.asList(new Address(160, _fundAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setMeedPerMinute(BigInteger _meedPerMinute) {
        Function function = new Function(FUNC_SETMEEDPERMINUTE, Arrays.asList(new Uint256(_meedPerMinute)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> startRewardsTime() {
        Function function = new Function(FUNC_STARTREWARDSTIME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> totalAllocationPoints() {
        Function function = new Function(FUNC_TOTALALLOCATIONPOINTS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> totalFixedPercentage() {
        Function function = new Function(FUNC_TOTALFIXEDPERCENTAGE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        Function function = new Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateAllocation(String _fundAddress, BigInteger _value, Boolean _isFixedPercentage) {
        Function function = new Function(FUNC_UPDATEALLOCATION, Arrays.asList(new Address(160, _fundAddress), new Uint256(_value), new Bool(_isFixedPercentage)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Tuple2<BigInteger, BigInteger>> userLpInfos(String param0, String param1) {
        final Function function = new Function(FUNC_USERLPINFOS, Arrays.asList(new Address(160, param0), new Address(160, param1)), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple2<BigInteger, BigInteger>>(){

            @Override
            public Tuple2<BigInteger, BigInteger> call() throws Exception {
                List results = TokenFactory.this.executeCallMultipleValueReturn(function);
                return new Tuple2((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<TransactionReceipt> withdraw(String _lpToken, BigInteger _amount) {
        Function function = new Function(FUNC_WITHDRAW, Arrays.asList(new Address(160, _lpToken), new Uint256(_amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    @Deprecated
    public static TokenFactory load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new TokenFactory(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static TokenFactory load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new TokenFactory(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static TokenFactory load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new TokenFactory(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static TokenFactory load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new TokenFactory(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<TokenFactory> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _meed, BigInteger _meedPerMinute, BigInteger _startRewardsTime) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Uint256(_meedPerMinute), new Uint256(_startRewardsTime)));
        return TokenFactory.deployRemoteCall(TokenFactory.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    public static RemoteCall<TokenFactory> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _meed, BigInteger _meedPerMinute, BigInteger _startRewardsTime) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Uint256(_meedPerMinute), new Uint256(_startRewardsTime)));
        return TokenFactory.deployRemoteCall(TokenFactory.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<TokenFactory> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _meed, BigInteger _meedPerMinute, BigInteger _startRewardsTime) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Uint256(_meedPerMinute), new Uint256(_startRewardsTime)));
        return TokenFactory.deployRemoteCall(TokenFactory.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<TokenFactory> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _meed, BigInteger _meedPerMinute, BigInteger _startRewardsTime) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Uint256(_meedPerMinute), new Uint256(_startRewardsTime)));
        return TokenFactory.deployRemoteCall(TokenFactory.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    public static class DepositEventResponse
    extends BaseEventResponse {
        public String user;
        public String lpAddress;
        public BigInteger amount;
    }

    public static class EmergencyWithdrawEventResponse
    extends BaseEventResponse {
        public String user;
        public String lpAddress;
        public BigInteger amount;
    }

    public static class FundAddedEventResponse
    extends BaseEventResponse {
        public String fundAddress;
        public BigInteger allocation;
        public Boolean fixedPercentage;
        public Boolean isLPToken;
    }

    public static class FundAllocationChangedEventResponse
    extends BaseEventResponse {
        public String fundAddress;
        public BigInteger allocation;
        public Boolean fixedPercentage;
    }

    public static class HarvestEventResponse
    extends BaseEventResponse {
        public String user;
        public String lpAddress;
        public BigInteger amount;
    }

    public static class MaxSupplyReachedEventResponse
    extends BaseEventResponse {
        public BigInteger timestamp;
    }

    public static class OwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class WithdrawEventResponse
    extends BaseEventResponse {
        public String user;
        public String lpAddress;
        public BigInteger amount;
    }
}

