/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple12;
import org.web3j.tuples.generated.Tuple8;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class DeedRenting
extends Contract {
    public static final String BINARY = "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";
    public static final String FUNC_DAY_IN_SECONDS = "DAY_IN_SECONDS";
    public static final String FUNC_MONTH_IN_SECONDS = "MONTH_IN_SECONDS";
    public static final String FUNC_ACQUIRERENT = "acquireRent";
    public static final String FUNC_CREATEOFFER = "createOffer";
    public static final String FUNC_DEED = "deed";
    public static final String FUNC_DEEDLEASES = "deedLeases";
    public static final String FUNC_DEEDOFFERS = "deedOffers";
    public static final String FUNC_DELETEOFFER = "deleteOffer";
    public static final String FUNC_ENDLEASE = "endLease";
    public static final String FUNC_EVICTTENANT = "evictTenant";
    public static final String FUNC_INITIALIZE = "initialize";
    public static final String FUNC_ISOWNER = "isOwner";
    public static final String FUNC_ISPROVISIONINGMANAGER = "isProvisioningManager";
    public static final String FUNC_LEASES = "leases";
    public static final String FUNC_MEED = "meed";
    public static final String FUNC_OFFERSCOUNT = "offersCount";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_PAYRENT = "payRent";
    public static final String FUNC_PROXIABLEUUID = "proxiableUUID";
    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";
    public static final String FUNC_TENANTPROVISIONING = "tenantProvisioning";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_UPDATEOFFER = "updateOffer";
    public static final String FUNC_UPGRADETO = "upgradeTo";
    public static final String FUNC_UPGRADETOANDCALL = "upgradeToAndCall";
    public static final Event ADMINCHANGED_EVENT = new Event("AdminChanged", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Address>(){}));
    public static final Event BEACONUPGRADED_EVENT = new Event("BeaconUpgraded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event INITIALIZED_EVENT = new Event("Initialized", Arrays.asList(new TypeReference<Uint8>(){}));
    public static final Event LEASEENDED_EVENT = new Event("LeaseEnded", Arrays.asList(new TypeReference<Uint256>(true){}, new TypeReference<Uint256>(true){}, new TypeReference<Address>(){}, new TypeReference<Uint16>(){}));
    public static final Event OFFERCREATED_EVENT = new Event("OfferCreated", Arrays.asList(new TypeReference<Uint256>(true){}, new TypeReference<Uint256>(true){}, new TypeReference<Address>(){}));
    public static final Event OFFERDELETED_EVENT = new Event("OfferDeleted", Arrays.asList(new TypeReference<Uint256>(true){}, new TypeReference<Uint256>(true){}, new TypeReference<Address>(){}));
    public static final Event OFFERUPDATED_EVENT = new Event("OfferUpdated", Arrays.asList(new TypeReference<Uint256>(true){}, new TypeReference<Uint256>(true){}, new TypeReference<Address>(){}));
    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));
    public static final Event RENTPAID_EVENT = new Event("RentPaid", Arrays.asList(new TypeReference<Uint256>(true){}, new TypeReference<Uint256>(true){}, new TypeReference<Address>(){}, new TypeReference<Address>(){}, new TypeReference<Uint16>(){}, new TypeReference<Bool>(){}));
    public static final Event TENANTEVICTED_EVENT = new Event("TenantEvicted", Arrays.asList(new TypeReference<Uint256>(true){}, new TypeReference<Uint256>(true){}, new TypeReference<Address>(){}, new TypeReference<Address>(){}, new TypeReference<Uint16>(){}));
    public static final Event UPGRADED_EVENT = new Event("Upgraded", Arrays.asList(new TypeReference<Address>(true){}));

    @Deprecated
    protected DeedRenting(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected DeedRenting(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected DeedRenting(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected DeedRenting(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<AdminChangedEventResponse> getAdminChangedEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)ADMINCHANGED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<AdminChangedEventResponse> responses = new ArrayList<AdminChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousAdmin = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.newAdmin = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static AdminChangedEventResponse getAdminChangedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)ADMINCHANGED_EVENT, (Log)log);
        AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
        typedResponse.log = log;
        typedResponse.previousAdmin = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        typedResponse.newAdmin = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getAdminChangedEventFromLog(log));
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ADMINCHANGED_EVENT));
        return this.adminChangedEventFlowable(filter);
    }

    public static List<BeaconUpgradedEventResponse> getBeaconUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)BEACONUPGRADED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<BeaconUpgradedEventResponse> responses = new ArrayList<BeaconUpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.beacon = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static BeaconUpgradedEventResponse getBeaconUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)BEACONUPGRADED_EVENT, (Log)log);
        BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.beacon = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getBeaconUpgradedEventFromLog(log));
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)BEACONUPGRADED_EVENT));
        return this.beaconUpgradedEventFlowable(filter);
    }

    public static List<InitializedEventResponse> getInitializedEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)INITIALIZED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<InitializedEventResponse> responses = new ArrayList<InitializedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            InitializedEventResponse typedResponse = new InitializedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.version = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static InitializedEventResponse getInitializedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)INITIALIZED_EVENT, (Log)log);
        InitializedEventResponse typedResponse = new InitializedEventResponse();
        typedResponse.log = log;
        typedResponse.version = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getInitializedEventFromLog(log));
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)INITIALIZED_EVENT));
        return this.initializedEventFlowable(filter);
    }

    public static List<LeaseEndedEventResponse> getLeaseEndedEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)LEASEENDED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<LeaseEndedEventResponse> responses = new ArrayList<LeaseEndedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            LeaseEndedEventResponse typedResponse = new LeaseEndedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.tenant = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.leaseRemainingMonths = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static LeaseEndedEventResponse getLeaseEndedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)LEASEENDED_EVENT, (Log)log);
        LeaseEndedEventResponse typedResponse = new LeaseEndedEventResponse();
        typedResponse.log = log;
        typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.tenant = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        typedResponse.leaseRemainingMonths = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<LeaseEndedEventResponse> leaseEndedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getLeaseEndedEventFromLog(log));
    }

    public Flowable<LeaseEndedEventResponse> leaseEndedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)LEASEENDED_EVENT));
        return this.leaseEndedEventFlowable(filter);
    }

    public static List<OfferCreatedEventResponse> getOfferCreatedEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)OFFERCREATED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<OfferCreatedEventResponse> responses = new ArrayList<OfferCreatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OfferCreatedEventResponse typedResponse = new OfferCreatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.owner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OfferCreatedEventResponse getOfferCreatedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)OFFERCREATED_EVENT, (Log)log);
        OfferCreatedEventResponse typedResponse = new OfferCreatedEventResponse();
        typedResponse.log = log;
        typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.owner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<OfferCreatedEventResponse> offerCreatedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getOfferCreatedEventFromLog(log));
    }

    public Flowable<OfferCreatedEventResponse> offerCreatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OFFERCREATED_EVENT));
        return this.offerCreatedEventFlowable(filter);
    }

    public static List<OfferDeletedEventResponse> getOfferDeletedEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)OFFERDELETED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<OfferDeletedEventResponse> responses = new ArrayList<OfferDeletedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OfferDeletedEventResponse typedResponse = new OfferDeletedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.owner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OfferDeletedEventResponse getOfferDeletedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)OFFERDELETED_EVENT, (Log)log);
        OfferDeletedEventResponse typedResponse = new OfferDeletedEventResponse();
        typedResponse.log = log;
        typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.owner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<OfferDeletedEventResponse> offerDeletedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getOfferDeletedEventFromLog(log));
    }

    public Flowable<OfferDeletedEventResponse> offerDeletedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OFFERDELETED_EVENT));
        return this.offerDeletedEventFlowable(filter);
    }

    public static List<OfferUpdatedEventResponse> getOfferUpdatedEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)OFFERUPDATED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<OfferUpdatedEventResponse> responses = new ArrayList<OfferUpdatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OfferUpdatedEventResponse typedResponse = new OfferUpdatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.owner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OfferUpdatedEventResponse getOfferUpdatedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)OFFERUPDATED_EVENT, (Log)log);
        OfferUpdatedEventResponse typedResponse = new OfferUpdatedEventResponse();
        typedResponse.log = log;
        typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.owner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<OfferUpdatedEventResponse> offerUpdatedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getOfferUpdatedEventFromLog(log));
    }

    public Flowable<OfferUpdatedEventResponse> offerUpdatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OFFERUPDATED_EVENT));
        return this.offerUpdatedEventFlowable(filter);
    }

    public static List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OwnershipTransferredEventResponse getOwnershipTransferredEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (Log)log);
        OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
        typedResponse.log = log;
        typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getOwnershipTransferredEventFromLog(log));
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OWNERSHIPTRANSFERRED_EVENT));
        return this.ownershipTransferredEventFlowable(filter);
    }

    public static List<RentPaidEventResponse> getRentPaidEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)RENTPAID_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<RentPaidEventResponse> responses = new ArrayList<RentPaidEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RentPaidEventResponse typedResponse = new RentPaidEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.tenant = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.owner = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.paidMonths = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            typedResponse.firstRent = (Boolean)((Type)eventValues.getNonIndexedValues().get(3)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static RentPaidEventResponse getRentPaidEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)RENTPAID_EVENT, (Log)log);
        RentPaidEventResponse typedResponse = new RentPaidEventResponse();
        typedResponse.log = log;
        typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.tenant = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        typedResponse.owner = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
        typedResponse.paidMonths = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
        typedResponse.firstRent = (Boolean)((Type)eventValues.getNonIndexedValues().get(3)).getValue();
        return typedResponse;
    }

    public Flowable<RentPaidEventResponse> rentPaidEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getRentPaidEventFromLog(log));
    }

    public Flowable<RentPaidEventResponse> rentPaidEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)RENTPAID_EVENT));
        return this.rentPaidEventFlowable(filter);
    }

    public static List<TenantEvictedEventResponse> getTenantEvictedEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)TENANTEVICTED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<TenantEvictedEventResponse> responses = new ArrayList<TenantEvictedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TenantEvictedEventResponse typedResponse = new TenantEvictedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.tenant = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.owner = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.leaseRemainingMonths = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static TenantEvictedEventResponse getTenantEvictedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)TENANTEVICTED_EVENT, (Log)log);
        TenantEvictedEventResponse typedResponse = new TenantEvictedEventResponse();
        typedResponse.log = log;
        typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.deedId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.tenant = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        typedResponse.owner = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
        typedResponse.leaseRemainingMonths = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
        return typedResponse;
    }

    public Flowable<TenantEvictedEventResponse> tenantEvictedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getTenantEvictedEventFromLog(log));
    }

    public Flowable<TenantEvictedEventResponse> tenantEvictedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TENANTEVICTED_EVENT));
        return this.tenantEvictedEventFlowable(filter);
    }

    public static List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = DeedRenting.staticExtractEventParametersWithLog((Event)UPGRADED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementation = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static UpgradedEventResponse getUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = DeedRenting.staticExtractEventParametersWithLog((Event)UPGRADED_EVENT, (Log)log);
        UpgradedEventResponse typedResponse = new UpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.implementation = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> DeedRenting.getUpgradedEventFromLog(log));
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADED_EVENT));
        return this.upgradedEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> DAY_IN_SECONDS() {
        Function function = new Function(FUNC_DAY_IN_SECONDS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> MONTH_IN_SECONDS() {
        Function function = new Function(FUNC_MONTH_IN_SECONDS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> acquireRent(BigInteger _id, BigInteger _monthsToPay) {
        Function function = new Function(FUNC_ACQUIRERENT, Arrays.asList(new Uint256(_id), new Uint8(_monthsToPay)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> createOffer(DeedOffer _offer) {
        Function function = new Function(FUNC_CREATEOFFER, Arrays.asList(new Type[]{_offer}), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> deed() {
        Function function = new Function(FUNC_DEED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<Tuple8<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String>> deedLeases(BigInteger param0) {
        final Function function = new Function(FUNC_DEEDLEASES, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint16>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Address>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple8<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String>>(){

            @Override
            public Tuple8<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String> call() throws Exception {
                List results = DeedRenting.this.executeCallMultipleValueReturn(function);
                return new Tuple8((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()), (Object)((BigInteger)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()), (Object)((BigInteger)((Type)results.get(4)).getValue()), (Object)((BigInteger)((Type)results.get(5)).getValue()), (Object)((BigInteger)((Type)results.get(6)).getValue()), (Object)((String)((Type)results.get(7)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<Tuple12<BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger>> deedOffers(BigInteger param0) {
        final Function function = new Function(FUNC_DEEDOFFERS, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Address>(){}, new TypeReference<Uint16>(){}, new TypeReference<Uint8>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint8>(){}, new TypeReference<Address>(){}, new TypeReference<Uint8>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple12<BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger>>(){

            @Override
            public Tuple12<BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger> call() throws Exception {
                List results = DeedRenting.this.executeCallMultipleValueReturn(function);
                return new Tuple12((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()), (Object)((String)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()), (Object)((BigInteger)((Type)results.get(4)).getValue()), (Object)((BigInteger)((Type)results.get(5)).getValue()), (Object)((BigInteger)((Type)results.get(6)).getValue()), (Object)((BigInteger)((Type)results.get(7)).getValue()), (Object)((BigInteger)((Type)results.get(8)).getValue()), (Object)((BigInteger)((Type)results.get(9)).getValue()), (Object)((String)((Type)results.get(10)).getValue()), (Object)((BigInteger)((Type)results.get(11)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<TransactionReceipt> deleteOffer(BigInteger _id) {
        Function function = new Function(FUNC_DELETEOFFER, Arrays.asList(new Uint256(_id)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> endLease(BigInteger _id) {
        Function function = new Function(FUNC_ENDLEASE, Arrays.asList(new Uint256(_id)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> evictTenant(BigInteger _id) {
        Function function = new Function(FUNC_EVICTTENANT, Arrays.asList(new Uint256(_id)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> initialize(String _meed, String _deed, String _tenantProvisioning) {
        Function function = new Function(FUNC_INITIALIZE, Arrays.asList(new Address(160, _meed), new Address(160, _deed), new Address(160, _tenantProvisioning)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        Function function = new Function(FUNC_ISOWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isProvisioningManager(String _address, BigInteger _deedId) {
        Function function = new Function(FUNC_ISPROVISIONINGMANAGER, Arrays.asList(new Address(160, _address), new Uint256(_deedId)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> leases(BigInteger param0, BigInteger param1) {
        Function function = new Function(FUNC_LEASES, Arrays.asList(new Uint256(param0), new Uint256(param1)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> meed() {
        Function function = new Function(FUNC_MEED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> offersCount() {
        Function function = new Function(FUNC_OFFERSCOUNT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> owner() {
        Function function = new Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> payRent(BigInteger _id, String _deedOwner, BigInteger _monthsToPay) {
        Function function = new Function(FUNC_PAYRENT, Arrays.asList(new Uint256(_id), new Address(160, _deedOwner), new Uint8(_monthsToPay)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<byte[]> proxiableUUID() {
        Function function = new Function(FUNC_PROXIABLEUUID, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bytes32>(){}));
        return this.executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        Function function = new Function(FUNC_RENOUNCEOWNERSHIP, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> tenantProvisioning() {
        Function function = new Function(FUNC_TENANTPROVISIONING, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        Function function = new Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateOffer(DeedOffer _offer) {
        Function function = new Function(FUNC_UPDATEOFFER, Arrays.asList(new Type[]{_offer}), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeTo(String newImplementation) {
        Function function = new Function(FUNC_UPGRADETO, Arrays.asList(new Address(160, newImplementation)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeToAndCall(String newImplementation, byte[] data, BigInteger weiValue) {
        Function function = new Function(FUNC_UPGRADETOANDCALL, Arrays.asList(new Address(160, newImplementation), new DynamicBytes(data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function, weiValue);
    }

    @Deprecated
    public static DeedRenting load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new DeedRenting(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static DeedRenting load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new DeedRenting(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static DeedRenting load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new DeedRenting(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static DeedRenting load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new DeedRenting(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<DeedRenting> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return DeedRenting.deployRemoteCall(DeedRenting.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<DeedRenting> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return DeedRenting.deployRemoteCall(DeedRenting.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public static RemoteCall<DeedRenting> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return DeedRenting.deployRemoteCall(DeedRenting.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<DeedRenting> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return DeedRenting.deployRemoteCall(DeedRenting.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public static class AdminChangedEventResponse
    extends BaseEventResponse {
        public String previousAdmin;
        public String newAdmin;
    }

    public static class BeaconUpgradedEventResponse
    extends BaseEventResponse {
        public String beacon;
    }

    public static class InitializedEventResponse
    extends BaseEventResponse {
        public BigInteger version;
    }

    public static class LeaseEndedEventResponse
    extends BaseEventResponse {
        public BigInteger id;
        public BigInteger deedId;
        public String tenant;
        public BigInteger leaseRemainingMonths;
    }

    public static class OfferCreatedEventResponse
    extends BaseEventResponse {
        public BigInteger id;
        public BigInteger deedId;
        public String owner;
    }

    public static class OfferDeletedEventResponse
    extends BaseEventResponse {
        public BigInteger id;
        public BigInteger deedId;
        public String owner;
    }

    public static class OfferUpdatedEventResponse
    extends BaseEventResponse {
        public BigInteger id;
        public BigInteger deedId;
        public String owner;
    }

    public static class OwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class RentPaidEventResponse
    extends BaseEventResponse {
        public BigInteger id;
        public BigInteger deedId;
        public String tenant;
        public String owner;
        public BigInteger paidMonths;
        public Boolean firstRent;
    }

    public static class TenantEvictedEventResponse
    extends BaseEventResponse {
        public BigInteger id;
        public BigInteger deedId;
        public String tenant;
        public String owner;
        public BigInteger leaseRemainingMonths;
    }

    public static class UpgradedEventResponse
    extends BaseEventResponse {
        public String implementation;
    }

    public static class DeedOffer
    extends StaticStruct {
        public BigInteger id;
        public BigInteger deedId;
        public String creator;
        public BigInteger months;
        public BigInteger noticePeriod;
        public BigInteger price;
        public BigInteger allDurationPrice;
        public BigInteger offerStartDate;
        public BigInteger offerExpirationDate;
        public BigInteger offerExpirationDays;
        public String authorizedTenant;
        public BigInteger ownerMintingPercentage;

        public DeedOffer(BigInteger id, BigInteger deedId, String creator, BigInteger months, BigInteger noticePeriod, BigInteger price, BigInteger allDurationPrice, BigInteger offerStartDate, BigInteger offerExpirationDate, BigInteger offerExpirationDays, String authorizedTenant, BigInteger ownerMintingPercentage) {
            super(new Type[]{new Uint256(id), new Uint256(deedId), new Address(160, creator), new Uint16(months), new Uint8(noticePeriod), new Uint256(price), new Uint256(allDurationPrice), new Uint256(offerStartDate), new Uint256(offerExpirationDate), new Uint8(offerExpirationDays), new Address(160, authorizedTenant), new Uint8(ownerMintingPercentage)});
            this.id = id;
            this.deedId = deedId;
            this.creator = creator;
            this.months = months;
            this.noticePeriod = noticePeriod;
            this.price = price;
            this.allDurationPrice = allDurationPrice;
            this.offerStartDate = offerStartDate;
            this.offerExpirationDate = offerExpirationDate;
            this.offerExpirationDays = offerExpirationDays;
            this.authorizedTenant = authorizedTenant;
            this.ownerMintingPercentage = ownerMintingPercentage;
        }

        public DeedOffer(Uint256 id, Uint256 deedId, Address creator, Uint16 months, Uint8 noticePeriod, Uint256 price, Uint256 allDurationPrice, Uint256 offerStartDate, Uint256 offerExpirationDate, Uint8 offerExpirationDays, Address authorizedTenant, Uint8 ownerMintingPercentage) {
            super(new Type[]{id, deedId, creator, months, noticePeriod, price, allDurationPrice, offerStartDate, offerExpirationDate, offerExpirationDays, authorizedTenant, ownerMintingPercentage});
            this.id = id.getValue();
            this.deedId = deedId.getValue();
            this.creator = creator.getValue();
            this.months = months.getValue();
            this.noticePeriod = noticePeriod.getValue();
            this.price = price.getValue();
            this.allDurationPrice = allDurationPrice.getValue();
            this.offerStartDate = offerStartDate.getValue();
            this.offerExpirationDate = offerExpirationDate.getValue();
            this.offerExpirationDays = offerExpirationDays.getValue();
            this.authorizedTenant = authorizedTenant.getValue();
            this.ownerMintingPercentage = ownerMintingPercentage.getValue();
        }
    }
}

