/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.service;

import io.meeds.dapp.constant.Currency;
import io.meeds.dapp.elasticsearch.model.MeedTokenMetric;
import io.meeds.dapp.service.ExchangeService;
import io.meeds.dapp.storage.MeedTokenMetricsRepository;
import io.meeds.deeds.common.service.BlockchainService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MeedTokenMetricService {
    @Value(value="#{'${meeds.blockchain.reserveValueEthereumAddresses:0xBa5e4D55CA96bf25c35Fc65D9251355Dcd120655,0x8f4660498E79c771f93316f09da98E1eBF94c576,0x70CAd5d439591Ea7f496B69DcB22521685015853}'.split(',')}")
    private List<String> reserveEthereumAddresses;
    @Value(value="#{'${meeds.blockchain.reserveValuePolygonAddresses:}'.split(',')}")
    private List<String> reservePolygonAddresses;
    @Value(value="#{'${meeds.blockchain.lockedValueEthereumAddresses:0x44D6d6aB50401Dd846336e9C706A492f06E1Bcd4,0x960Bd61D0b960B107fF5309A2DCceD4705567070}'.split(',')}")
    private List<String> lockedEthereumAddresses;
    @Value(value="#{'${meeds.blockchain.lockedValuePolygonAddresses:0x6acA77CF3BaB0C4E8210A09B57B07854a995289a}'.split(',')}")
    private List<String> lockedPolygonAddresses;
    @Autowired
    private BlockchainService blockchainService;
    @Autowired
    private MeedTokenMetricsRepository meedTokenMetricsRepository;
    private MeedTokenMetric recentMetric;
    @Autowired
    private ExchangeService exchangeService;

    public BigDecimal getCirculatingSupply() {
        MeedTokenMetric lastMetric = this.getLastMetric(null);
        return lastMetric.getCirculatingSupply();
    }

    public BigDecimal getTotalSupply() {
        MeedTokenMetric lastMetric = this.getLastMetric(null);
        return lastMetric.getTotalSupply();
    }

    public BigDecimal getMarketCapitalization(Currency currency) {
        MeedTokenMetric lastMetric = this.getLastMetric(currency);
        return lastMetric.getMarketCapitalization();
    }

    public BigDecimal getTotalValueLocked(Currency currency) {
        MeedTokenMetric lastMetric = this.getLastMetric(currency);
        return lastMetric.getTotalValuelocked();
    }

    public void computeTokenMetrics() {
        MeedTokenMetric metric = this.getTodayMetric();
        if (metric == null) {
            metric = new MeedTokenMetric(this.getTodayId());
        }
        BigDecimal totalSupply = this.blockchainService.meedsTotalSupplyNoDecimals();
        metric.setTotalSupply(totalSupply);
        Map<String, BigDecimal> reserveBalances = this.getReserveBalances();
        metric.setReserveBalances(reserveBalances);
        Map<String, BigDecimal> lockedBalances = this.getLockedBalances();
        metric.setLockedBalances(lockedBalances);
        BigDecimal meedUsdValue = this.exchangeService.getMeedUsdPrice();
        metric.setMeedUsdPrice(meedUsdValue);
        BigDecimal totalLockedBalance = this.getTotalLockedBalance(lockedBalances);
        BigDecimal totalLockedValue = meedUsdValue.multiply(totalLockedBalance);
        metric.setTotalValuelocked(totalLockedValue);
        BigDecimal totalReserveBalance = this.getTotalReserveBalance(reserveBalances);
        BigDecimal circulatingSupply = totalSupply.subtract(totalReserveBalance).subtract(totalLockedBalance);
        metric.setCirculatingSupply(circulatingSupply);
        BigDecimal marketCapitalization = meedUsdValue.multiply(circulatingSupply);
        metric.setMarketCapitalization(marketCapitalization);
        this.meedTokenMetricsRepository.save(metric);
        this.recentMetric = metric;
    }

    public Map<String, BigDecimal> getReserveBalances() {
        HashMap<String, BigDecimal> reserveBalances = new HashMap<String, BigDecimal>();
        this.reserveEthereumAddresses.stream().filter(StringUtils::isNotBlank).forEach(address -> {
            BigDecimal balance = this.blockchainService.meedBalanceOfNoDecimals(address);
            reserveBalances.put(address.toLowerCase(), balance);
        });
        this.reservePolygonAddresses.stream().filter(StringUtils::isNotBlank).forEach(address -> {
            BigDecimal balance = this.blockchainService.meedBalanceOfOnPolygon(address);
            reserveBalances.put(address.toLowerCase(), balance);
        });
        return reserveBalances;
    }

    public Map<String, BigDecimal> getLockedBalances() {
        HashMap<String, BigDecimal> lockedBalances = new HashMap<String, BigDecimal>();
        this.lockedEthereumAddresses.stream().filter(StringUtils::isNotBlank).forEach(address -> {
            BigDecimal balance = this.blockchainService.meedBalanceOfNoDecimals(address);
            lockedBalances.put(address.toLowerCase(), balance);
        });
        this.lockedPolygonAddresses.stream().filter(StringUtils::isNotBlank).forEach(address -> {
            BigDecimal balance = this.blockchainService.meedBalanceOfOnPolygon(address);
            lockedBalances.put(address.toLowerCase(), balance);
        });
        return lockedBalances;
    }

    private BigDecimal getTotalLockedBalance(Map<String, BigDecimal> lockedBalances) {
        return lockedBalances.values().stream().filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.valueOf(0L));
    }

    private BigDecimal getTotalReserveBalance(Map<String, BigDecimal> reserveBalances) {
        return reserveBalances.values().stream().filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.valueOf(0L));
    }

    public MeedTokenMetric getLastMetric(Currency currency) {
        if (this.recentMetric == null) {
            this.recentMetric = this.getTodayMetric();
            if (this.recentMetric == null) {
                this.computeTokenMetrics();
            }
        }
        return this.toCurrency(this.recentMetric, currency);
    }

    private MeedTokenMetric getTodayMetric() {
        return this.meedTokenMetricsRepository.findById(this.getTodayId()).orElse(null);
    }

    private LocalDate getTodayId() {
        return LocalDate.now(ZoneOffset.UTC);
    }

    private MeedTokenMetric toCurrency(MeedTokenMetric metric, Currency currency) {
        BigDecimal usdRate = this.exchangeService.getExchangeRate(currency);
        if (BigDecimal.ONE.equals(usdRate)) {
            return metric;
        }
        return new MeedTokenMetric(metric.getDate(), metric.getTotalSupply(), metric.getLockedBalances() == null ? Collections.emptyMap() : new HashMap<String, BigDecimal>(metric.getLockedBalances()), metric.getReserveBalances() == null ? Collections.emptyMap() : new HashMap<String, BigDecimal>(metric.getReserveBalances()), metric.getCirculatingSupply(), metric.getMarketCapitalization().multiply(usdRate), metric.getTotalValuelocked().multiply(usdRate), metric.getMeedUsdPrice().multiply(usdRate));
    }

    public List<String> getReserveEthereumAddresses() {
        return this.reserveEthereumAddresses;
    }

    public List<String> getReservePolygonAddresses() {
        return this.reservePolygonAddresses;
    }

    public List<String> getLockedEthereumAddresses() {
        return this.lockedEthereumAddresses;
    }

    public List<String> getLockedPolygonAddresses() {
        return this.lockedPolygonAddresses;
    }

    public MeedTokenMetric getRecentMetric() {
        return this.recentMetric;
    }

    public void setRecentMetric(MeedTokenMetric recentMetric) {
        this.recentMetric = recentMetric;
    }
}

