/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.utils;

import io.meeds.deeds.common.constant.ExpirationDuration;
import io.meeds.deeds.common.constant.NoticePeriod;
import io.meeds.deeds.common.constant.OfferType;
import io.meeds.deeds.common.constant.RentalDuration;
import io.meeds.deeds.common.constant.RentalPaymentPeriodicity;
import io.meeds.deeds.common.constant.TransactionStatus;
import io.meeds.deeds.common.elasticsearch.model.DeedTenantOffer;
import io.meeds.deeds.common.model.DeedTenantOfferDTO;
import java.time.Instant;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class DeedTenantOfferMapper {
    public static final Instant MAX_DATE_VALUE = Instant.ofEpochSecond(165241780471L);
    public static final String EVERYONE = "ALL";

    private DeedTenantOfferMapper() {
    }

    public static DeedTenantOfferDTO toDTO(DeedTenantOffer deedTenantOffer) {
        if (deedTenantOffer == null) {
            return null;
        }
        ExpirationDuration expirationDuration = ExpirationDuration.fromDays(deedTenantOffer.getExpirationDays());
        RentalDuration duration = RentalDuration.fromMonths(deedTenantOffer.getMonths());
        NoticePeriod noticePeriod = NoticePeriod.fromMonths(deedTenantOffer.getNoticePeriod());
        RentalPaymentPeriodicity paymentPeriodicity = deedTenantOffer.getPaymentPeriodicity();
        Instant expirationDate = expirationDuration == null || MAX_DATE_VALUE.equals(deedTenantOffer.getExpirationDate()) ? null : deedTenantOffer.getExpirationDate();
        return new DeedTenantOfferDTO(deedTenantOffer.getId(), deedTenantOffer.getOfferId(), deedTenantOffer.getNftId(), deedTenantOffer.getCity(), deedTenantOffer.getCardType(), deedTenantOffer.getOwner(), deedTenantOffer.getHostAddress(), deedTenantOffer.getDescription(), deedTenantOffer.getAmount(), deedTenantOffer.getAllDurationAmount(), deedTenantOffer.getOfferType(), expirationDuration, deedTenantOffer.getExpirationDays(), duration, deedTenantOffer.getMonths(), noticePeriod, deedTenantOffer.getNoticePeriod(), paymentPeriodicity, deedTenantOffer.getOwnerMintingPercentage(), deedTenantOffer.getMintingPower(), deedTenantOffer.getOfferTransactionHash(), deedTenantOffer.getOfferTransactionStatus(), deedTenantOffer.getStartDate(), expirationDate, deedTenantOffer.getCreatedDate(), deedTenantOffer.getModifiedDate(), deedTenantOffer.isEnabled(), deedTenantOffer.getParentId(), deedTenantOffer.getAcquisitionIds(), deedTenantOffer.getUpdateId(), deedTenantOffer.getDeleteId());
    }

    public static DeedTenantOffer fromDTO(DeedTenantOfferDTO deedTenantOfferDTO) {
        if (deedTenantOfferDTO == null) {
            return null;
        }
        NoticePeriod noticePeriod = deedTenantOfferDTO.getNoticePeriod();
        RentalDuration rentalDuration = deedTenantOfferDTO.getDuration();
        ExpirationDuration expirationDuration = deedTenantOfferDTO.getExpirationDuration();
        Instant now = Instant.now();
        DeedTenantOffer newOffer = new DeedTenantOffer();
        newOffer.setOfferId(deedTenantOfferDTO.getOfferId());
        newOffer.setNftId(deedTenantOfferDTO.getNftId());
        newOffer.setCity(deedTenantOfferDTO.getCity());
        newOffer.setCardType(deedTenantOfferDTO.getCardType());
        newOffer.setMintingPower(deedTenantOfferDTO.getMintingPower());
        newOffer.setOfferType(OfferType.RENTING);
        newOffer.setHostAddress(StringUtils.lowerCase((String)deedTenantOfferDTO.getHostAddress()));
        newOffer.setOwner(StringUtils.lowerCase((String)deedTenantOfferDTO.getOwner()));
        newOffer.setViewAddresses(Collections.singletonList(StringUtils.lowerCase((String)deedTenantOfferDTO.getOwner())));
        newOffer.setOfferTransactionHash(StringUtils.lowerCase((String)deedTenantOfferDTO.getOfferTransactionHash()));
        newOffer.setOfferTransactionStatus(TransactionStatus.IN_PROGRESS);
        newOffer.setDescription(deedTenantOfferDTO.getDescription());
        newOffer.setAmount(deedTenantOfferDTO.getAmount());
        newOffer.setAllDurationAmount(deedTenantOfferDTO.getAllDurationAmount());
        newOffer.setMonths(rentalDuration == null ? 0 : rentalDuration.getMonths());
        newOffer.setExpirationDays(expirationDuration == null ? 0 : expirationDuration.getDays());
        newOffer.setNoticePeriod(noticePeriod == null ? 0 : noticePeriod.getMonths());
        newOffer.setPaymentPeriodicity(deedTenantOfferDTO.getPaymentPeriodicity());
        newOffer.setOwnerMintingPercentage(deedTenantOfferDTO.getOwnerMintingPercentage());
        newOffer.setExpirationDate(MAX_DATE_VALUE);
        newOffer.setCreatedDate(now);
        newOffer.setModifiedDate(now);
        newOffer.setEnabled(true);
        return newOffer;
    }

    public static DeedTenantOffer toOfferUpdateChangeLog(DeedTenantOfferDTO deedTenantOfferDTO, DeedTenantOffer existingDeedTenantOffer) {
        if (deedTenantOfferDTO == null) {
            return null;
        }
        RentalDuration rentalDuration = deedTenantOfferDTO.getDuration();
        ExpirationDuration expirationDuration = deedTenantOfferDTO.getExpirationDuration();
        NoticePeriod noticePeriod = deedTenantOfferDTO.getNoticePeriod();
        DeedTenantOffer changeLogOffer = DeedTenantOfferMapper.toOfferChangeLog(existingDeedTenantOffer, deedTenantOfferDTO.getOfferTransactionHash());
        changeLogOffer.setHostAddress(StringUtils.lowerCase((String)deedTenantOfferDTO.getHostAddress()));
        changeLogOffer.setDescription(deedTenantOfferDTO.getDescription());
        changeLogOffer.setAmount(deedTenantOfferDTO.getAmount());
        changeLogOffer.setAllDurationAmount(deedTenantOfferDTO.getAllDurationAmount());
        changeLogOffer.setMonths(rentalDuration == null ? 0 : rentalDuration.getMonths());
        changeLogOffer.setExpirationDays(expirationDuration == null ? 0 : expirationDuration.getDays());
        changeLogOffer.setNoticePeriod(noticePeriod == null ? 0 : noticePeriod.getMonths());
        changeLogOffer.setPaymentPeriodicity(deedTenantOfferDTO.getPaymentPeriodicity());
        changeLogOffer.setOwnerMintingPercentage(deedTenantOfferDTO.getOwnerMintingPercentage());
        return changeLogOffer;
    }

    public static DeedTenantOffer toOfferChangeLog(DeedTenantOffer existingDeedTenantOffer, String transactionHash) {
        DeedTenantOffer changeLogOffer = existingDeedTenantOffer.clone();
        changeLogOffer.setId(null);
        changeLogOffer.setViewAddresses(Collections.emptyList());
        changeLogOffer.setOfferTransactionHash(StringUtils.lowerCase((String)transactionHash));
        changeLogOffer.setOfferTransactionStatus(TransactionStatus.IN_PROGRESS);
        changeLogOffer.setParentId(existingDeedTenantOffer.getId());
        changeLogOffer.setDeleteId(null);
        changeLogOffer.setUpdateId(null);
        changeLogOffer.setAcquisitionIds(Collections.emptySet());
        changeLogOffer.setCreatedDate(Instant.now());
        changeLogOffer.setModifiedDate(changeLogOffer.getCreatedDate());
        return changeLogOffer;
    }
}

