/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.security;

import io.meeds.dapp.web.security.DeedAccessDeniedHandler;
import io.meeds.dapp.web.security.DeedAuthenticationProvider;
import io.meeds.dapp.web.security.GrantedAuthorityDefaults;
import io.meeds.dapp.web.utils.Utils;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.context.ServletContextAware;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
public class WebSecurityConfig
implements ServletContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(WebSecurityConfig.class);
    private ServletContext servletContext;

    @Bean
    public static GrantedAuthorityDefaults grantedAuthorityDefaults() {
        return new GrantedAuthorityDefaults();
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, DeedAuthenticationProvider authProvider, DeedAccessDeniedHandler deedAccessDeniedHandler) throws Exception {
        http.authenticationProvider((AuthenticationProvider)authProvider).jee(SecurityConfigurerAdapter::and).csrf(AbstractHttpConfigurer::disable).headers(headers -> {
            headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable);
            headers.xssProtection(HeadersConfigurer.XXssConfig::disable);
            headers.contentTypeOptions(HeadersConfigurer.ContentTypeOptionsConfig::disable);
        }).authorizeHttpRequests(customizer -> {
            try {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{this.staticResourcesRequestMatcher()})).permitAll().requestMatchers(new RequestMatcher[]{this.apiRequestMatcher()})).access(this.requestAuthorizationManager()).anyRequest()).permitAll();
            }
            catch (Exception e) {
                LOG.error("Error configuring REST endpoints security manager", (Throwable)e);
            }
        }).formLogin(formLogin -> ((FormLoginConfigurer)((FormLoginConfigurer)formLogin.loginProcessingUrl("/login")).successHandler((request, response, authentication) -> response.setStatus(200))).failureHandler((request, response, authentication) -> response.setStatus(403))).logout(logout -> logout.logoutUrl("/logout").logoutSuccessHandler((request, response, authentication) -> this.handleLogout(request, response))).exceptionHandling(exceptionHandling -> exceptionHandling.accessDeniedHandler((AccessDeniedHandler)deedAccessDeniedHandler));
        return (SecurityFilterChain)http.build();
    }

    private AuthorizationManager<RequestAuthorizationContext> requestAuthorizationManager() {
        return (authentication, context) -> {
            Authentication userAuthentication = (Authentication)authentication.get();
            return userAuthentication.isAuthenticated() ? new AuthorizationDecision(true) : new AuthorizationDecision(false);
        };
    }

    private RequestMatcher apiRequestMatcher() {
        return request -> StringUtils.startsWith((CharSequence)request.getRequestURI(), (CharSequence)(this.servletContext.getContextPath() + "/api/"));
    }

    private RequestMatcher staticResourcesRequestMatcher() {
        return request -> !StringUtils.startsWith((CharSequence)request.getRequestURI(), (CharSequence)(this.servletContext.getContextPath() + "/api/")) || StringUtils.startsWith((CharSequence)request.getRequestURI(), (CharSequence)(this.servletContext.getContextPath() + "/api/deeds/")) || StringUtils.startsWith((CharSequence)request.getRequestURI(), (CharSequence)(this.servletContext.getContextPath() + "/api/hubs/")) || StringUtils.startsWith((CharSequence)request.getRequestURI(), (CharSequence)(this.servletContext.getContextPath() + "/api/hub/"));
    }

    private void handleLogout(HttpServletRequest request, HttpServletResponse response) {
        String loginMessage = Utils.generateLoginMessage(request.getSession(true));
        try {
            response.setContentType("text/plain; charset=UTF-8");
            response.getWriter().append(loginMessage);
            response.getWriter().close();
            response.setStatus(200);
        }
        catch (IOException e) {
            LOG.warn("Error while generating Login Password for user to sign by his wallet", (Throwable)e);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

