/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.service;

import io.meeds.dapp.service.DeedMetadataService$AjcClosure1;
import io.meeds.deeds.common.constant.DeedCard;
import io.meeds.deeds.common.constant.DeedCity;
import io.meeds.deeds.common.elasticsearch.model.DeedMetadata;
import io.meeds.deeds.common.elasticsearch.storage.DeedMetadataRepository;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import io.meeds.wom.api.utils.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.net.URL;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.aspectj.AnnotationCacheAspect;
import org.springframework.stereotype.Component;

@Component
public class DeedMetadataService {
    private static final String DAPP_IMAGE_SERVER_BASE = "${DAPP_SERVER_BASE}";
    private static final Logger LOG;
    @Autowired
    private DeedMetadataRepository deedMetadataRepository;
    @Autowired
    private BlockchainService blockchainService;
    @Value(value="${meeds.deed.metadatas.path:metadatas.json}")
    private String metadatasFilePath;
    @Value(value="${meeds.deed.contract.metadatas.path:deedCollection.json}")
    private String deedCollectionMetadataFilePath;
    @Value(value="${meeds.deed.metadata.serverBase:}")
    private String imageServerBase;
    private Map<String, DeedMetadata> deedMetadatas;
    private DeedMetadata contractMetadata;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        try {
            URL deedMetadatasResource = this.getClass().getClassLoader().getResource(this.metadatasFilePath);
            this.deedMetadatas = (Map)JsonUtils.OBJECT_MAPPER.readerForMapOf(DeedMetadata.class).readValue(deedMetadatasResource);
            this.deedMetadatas.values().forEach(deedMetadata -> deedMetadata.setImageUrl(deedMetadata.getImageUrl().replace(DAPP_IMAGE_SERVER_BASE, this.imageServerBase)));
            URL contractMetadataResource = this.getClass().getClassLoader().getResource(this.deedCollectionMetadataFilePath);
            this.contractMetadata = (DeedMetadata)JsonUtils.OBJECT_MAPPER.readerFor(DeedMetadata.class).readValue(contractMetadataResource);
            this.contractMetadata.setImageUrl(this.contractMetadata.getImageUrl().replace(DAPP_IMAGE_SERVER_BASE, this.imageServerBase));
        }
        catch (Exception e) {
            LOG.error("Error reading Default NFT mappings", (Throwable)e);
        }
    }

    @Cacheable(cacheNames={"deedMetadata"})
    public DeedMetadata getDeedMetadata(Long nftId) {
        Long l = nftId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)l);
        Object[] objectArray = new Object[]{this, l, joinPoint};
        return (DeedMetadata)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new DeedMetadataService$AjcClosure1(objectArray), joinPoint);
    }

    public DeedMetadata getDeedMetadataOfCard(int cityIndex, int cardTypeIndex) {
        if (cityIndex >= DeedCity.values().length || cardTypeIndex >= DeedCard.values().length) {
            return null;
        }
        DeedCity deedCity = DeedCity.values()[cityIndex];
        DeedCard cardType = DeedCard.values()[cardTypeIndex];
        String key = deedCity.name() + "-" + cardType.name();
        return this.deedMetadatas.get(key).clone();
    }

    public DeedMetadata getContractMetadata() {
        return this.contractMetadata.clone();
    }

    private DeedMetadata buildDeedMetadata(long nftId) {
        try {
            short cityIndex = this.blockchainService.getDeedCityIndex(nftId);
            short cardTypeIndex = this.blockchainService.getDeedCardType(nftId);
            DeedCity deedCity = DeedCity.values()[cityIndex];
            DeedCard cardType = DeedCard.values()[cardTypeIndex];
            String key = deedCity.name() + "-" + cardType.name();
            DeedMetadata deedMetadata = this.deedMetadatas.get(key).clone();
            deedMetadata.setNftId(nftId);
            return deedMetadata;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    static {
        DeedMetadataService.ajc$preClinit();
        LOG = LoggerFactory.getLogger(DeedMetadataService.class);
    }

    static /* synthetic */ DeedMetadata getDeedMetadata_aroundBody0(DeedMetadataService ajc$this, Long nftId, JoinPoint joinPoint) {
        return ajc$this.deedMetadataRepository.findById((Object)nftId).orElseGet(() -> this.buildDeedMetadata(nftId));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeedMetadataService.java", DeedMetadataService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDeedMetadata", "io.meeds.dapp.service.DeedMetadataService", "java.lang.Long", "nftId", "", "io.meeds.deeds.common.elasticsearch.model.DeedMetadata"), 93);
    }
}

