/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.security;

import io.meeds.dapp.web.utils.Utils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

@Component
public class DeedAuthenticationProvider
implements AuthenticationProvider {
    public static final String USER_ROLE_NAME = "USER";

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String walletAddress = authentication.getName();
        String encryptedMessage = authentication.getCredentials().toString();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        String message = request.getParameter("message");
        HttpSession session = request.getSession(false);
        String loginMessage = Utils.getLoginMessage(session);
        try {
            if (!StringUtils.contains((CharSequence)message, (CharSequence)loginMessage)) {
                throw new BadCredentialsException("Flat message signed by user doesn't have the corresponding Token");
            }
            if (this.validateSignedMessage(walletAddress, message, encryptedMessage)) {
                return new UsernamePasswordAuthenticationToken((Object)walletAddress, null, Collections.singleton(new SimpleGrantedAuthority(USER_ROLE_NAME)));
            }
            throw new BadCredentialsException("Can't decrypt wallet message");
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("An unknown error is encountered while authenticating user", (Throwable)e);
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }

    public boolean validateSignedMessage(String walletAddress, String rawMessage, String signedMessage) throws UnsupportedEncodingException, SignatureException {
        String recoveredAddress;
        BigInteger publicKey;
        if (StringUtils.isBlank((CharSequence)walletAddress) || StringUtils.isBlank((CharSequence)rawMessage) || StringUtils.isBlank((CharSequence)signedMessage)) {
            return false;
        }
        byte[] signatureBytes = Numeric.hexStringToByteArray((String)signedMessage);
        byte[] r = Arrays.copyOfRange(signatureBytes, 0, 32);
        byte[] s = Arrays.copyOfRange(signatureBytes, 32, 64);
        byte v = signatureBytes[64];
        if (v < 27) {
            v = (byte)(v + 27);
        }
        return (publicKey = Sign.signedPrefixedMessageToKey((byte[])rawMessage.getBytes(), (Sign.SignatureData)new Sign.SignatureData(v, r, s))) != null && (recoveredAddress = "0x" + Keys.getAddress((BigInteger)publicKey)).equalsIgnoreCase(walletAddress);
    }
}

