/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.blockchain;

import io.meeds.deeds.common.blockchain.BlockchainConfigurationProperties;
import io.meeds.deeds.common.blockchain.PolygonTransactionManagerProxy;
import io.meeds.deeds.common.blockchain.PolygonWomContractGasProvider;
import io.meeds.deeds.contract.Deed;
import io.meeds.deeds.contract.DeedRenting;
import io.meeds.deeds.contract.DeedTenantProvisioning;
import io.meeds.deeds.contract.ERC20;
import io.meeds.deeds.contract.MeedsToken;
import io.meeds.deeds.contract.TokenFactory;
import io.meeds.deeds.contract.UserEngagementMinting;
import io.meeds.deeds.contract.WoM;
import io.meeds.deeds.contract.XMeedsNFTRewarding;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.web3j.abi.datatypes.Address;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;

@Configuration
public class BlockchainConfiguration {
    private static final BigInteger GAS_PRICE = BigInteger.valueOf(20000000000L);
    private static final BigInteger GAS_LIMIT = BigInteger.valueOf(300000L);
    private static final StaticGasProvider CONTRACT_GAS_PROVIDER = new StaticGasProvider(GAS_PRICE, GAS_LIMIT);
    @Autowired
    private BlockchainConfigurationProperties properties;

    @Bean(value={"ethereumNetwork"})
    public Web3j getMainnetNetworkWeb3j() {
        return Web3j.build((Web3jService)new HttpService(this.properties.getNetworkUrl()));
    }

    @Bean(value={"polygonNetwork"})
    public Web3j getPolygonNetworkWeb3j() {
        return Web3j.build((Web3jService)new HttpService(this.properties.getPolygonNetworkUrl()));
    }

    @Bean
    public DeedTenantProvisioning getDeedTenantProvisioning(@Qualifier(value="ethereumNetwork") Web3j web3j) {
        return DeedTenantProvisioning.load((String)this.properties.getTenantProvisioningAddress(), (Web3j)web3j, (TransactionManager)this.getReadOnlyTransactionManager(web3j), (ContractGasProvider)CONTRACT_GAS_PROVIDER);
    }

    @Bean
    public DeedRenting getDeedRenting(@Qualifier(value="ethereumNetwork") Web3j web3j) {
        return DeedRenting.load((String)this.properties.getTenantRentingAddress(), (Web3j)web3j, (TransactionManager)this.getReadOnlyTransactionManager(web3j), (ContractGasProvider)CONTRACT_GAS_PROVIDER);
    }

    @Bean
    public Deed getDeed(@Qualifier(value="ethereumNetwork") Web3j web3j) {
        return Deed.load((String)this.properties.getDeedAddress(), (Web3j)web3j, (TransactionManager)this.getReadOnlyTransactionManager(web3j), (ContractGasProvider)CONTRACT_GAS_PROVIDER);
    }

    @Bean
    public TokenFactory getTokenFactory(@Qualifier(value="ethereumNetwork") Web3j web3j) {
        return TokenFactory.load((String)this.properties.getTokenFactoryAddress(), (Web3j)web3j, (TransactionManager)this.getReadOnlyTransactionManager(web3j), (ContractGasProvider)CONTRACT_GAS_PROVIDER);
    }

    @Bean
    public XMeedsNFTRewarding getXMeedsNFTRewarding(@Qualifier(value="ethereumNetwork") Web3j web3j) {
        return XMeedsNFTRewarding.load((String)this.properties.getXMeedAddress(), (Web3j)web3j, (TransactionManager)this.getReadOnlyTransactionManager(web3j), (ContractGasProvider)CONTRACT_GAS_PROVIDER);
    }

    @Bean(value={"sushiPairToken"})
    public ERC20 getSushiPairToken(@Qualifier(value="ethereumNetwork") Web3j web3j) {
        return ERC20.load((String)this.properties.getSushiPairAddress(), (Web3j)web3j, (TransactionManager)this.getReadOnlyTransactionManager(web3j), (ContractGasProvider)CONTRACT_GAS_PROVIDER);
    }

    @Bean(value={"ethereumMeedToken"})
    public MeedsToken getMainnetMeedToken(@Qualifier(value="ethereumNetwork") Web3j web3j) {
        return MeedsToken.load((String)this.properties.getMeedAddress(), (Web3j)web3j, (TransactionManager)this.getReadOnlyTransactionManager(web3j), (ContractGasProvider)CONTRACT_GAS_PROVIDER);
    }

    @Bean(value={"polygonMeedToken"})
    public MeedsToken getPolygonMeedToken(@Qualifier(value="polygonNetwork") Web3j web3j) {
        return MeedsToken.load((String)this.properties.getPolygonMeedAddress(), (Web3j)web3j, (TransactionManager)this.getReadOnlyTransactionManager(web3j), (ContractGasProvider)CONTRACT_GAS_PROVIDER);
    }

    @Bean
    public UserEngagementMinting getUserEngagementMinting(@Qualifier(value="polygonNetwork") Web3j web3j) {
        if (StringUtils.isBlank((CharSequence)this.properties.getUemAddress())) {
            return null;
        }
        return UserEngagementMinting.load((String)this.properties.getUemAddress(), (Web3j)web3j, (TransactionManager)this.getReadOnlyTransactionManager(web3j), (ContractGasProvider)CONTRACT_GAS_PROVIDER);
    }

    @Bean(value={"womContractReadOnly"})
    public WoM getWomReadOnly(@Qualifier(value="polygonNetwork") Web3j web3j) {
        if (StringUtils.isBlank((CharSequence)this.properties.getWomAddress())) {
            return null;
        }
        return WoM.load((String)this.properties.getWomAddress(), (Web3j)web3j, (TransactionManager)this.getReadOnlyTransactionManager(web3j), (ContractGasProvider)CONTRACT_GAS_PROVIDER);
    }

    @Bean(value={"womContractReadWrite"})
    public WoM getWomReadWrite(@Qualifier(value="polygonNetwork") Web3j web3j) {
        if (StringUtils.isBlank((CharSequence)this.properties.getWomAddress())) {
            return null;
        }
        PolygonTransactionManagerProxy.setWeb3j(web3j);
        return WoM.load((String)this.properties.getWomAddress(), (Web3j)web3j, (TransactionManager)new PolygonTransactionManagerProxy(), (ContractGasProvider)new PolygonWomContractGasProvider(web3j));
    }

    private ReadonlyTransactionManager getReadOnlyTransactionManager(Web3j web3j) {
        return new ReadonlyTransactionManager(web3j, Address.DEFAULT.toString());
    }
}

