/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.model;

import io.meeds.deeds.constant.Currency;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@Document(indexName="currency_exchange_rate", createIndex=true)
@Setting(sortFields={"date"}, sortOrders={Setting.SortOrder.desc}, replicas=0, shards=1)
public class CurrencyExchangeRate {
    @Id
    @Field(type=FieldType.Date, format={DateFormat.year_month_day})
    private LocalDate date;
    @Field(type=FieldType.Keyword)
    private Currency currency;
    private BigDecimal rate;

    public LocalDate getDate() {
        return this.date;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CurrencyExchangeRate)) {
            return false;
        }
        CurrencyExchangeRate other = (CurrencyExchangeRate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !((Object)((Object)this$currency)).equals((Object)other$currency)) {
            return false;
        }
        BigDecimal this$rate = this.getRate();
        BigDecimal other$rate = other.getRate();
        return !(this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CurrencyExchangeRate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : ((Object)((Object)$currency)).hashCode());
        BigDecimal $rate = this.getRate();
        result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
        return result;
    }

    public String toString() {
        return "CurrencyExchangeRate(date=" + this.getDate() + ", currency=" + this.getCurrency() + ", rate=" + this.getRate() + ")";
    }

    public CurrencyExchangeRate(LocalDate date, Currency currency, BigDecimal rate) {
        this.date = date;
        this.currency = currency;
        this.rate = rate;
    }

    public CurrencyExchangeRate() {
    }
}

