/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.service;

import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.contract.Deed;
import io.meeds.deeds.contract.TenantProvisioningStrategy;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlockchainService {
    @Autowired
    private TenantProvisioningStrategy tenantProvisioningStrategy;
    @Autowired
    private Deed deed;

    public boolean isDeedProvisioningManager(String address, long nftId) {
        try {
            return (Boolean)this.tenantProvisioningStrategy.isProvisioningManager(address, BigInteger.valueOf(nftId)).send();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving information 'isTenantProvisioningManager' from Blockchain", e);
        }
    }

    public short getDeedCardType(long nftId) throws ObjectNotFoundException {
        try {
            return ((BigInteger)this.deed.cardType(BigInteger.valueOf(nftId)).send()).shortValue();
        }
        catch (Exception e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"execution reverted")) {
                throw new ObjectNotFoundException(e.getMessage());
            }
            throw new IllegalStateException("Error retrieving information 'getDeedCardType' from Blockchain", e);
        }
    }

    public short getDeedCityIndex(long nftId) throws ObjectNotFoundException {
        try {
            return ((BigInteger)this.deed.cityIndex(BigInteger.valueOf(nftId)).send()).shortValue();
        }
        catch (Exception e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"execution reverted")) {
                throw new ObjectNotFoundException(e.getMessage());
            }
            throw new IllegalStateException("Error retrieving information 'getDeedCityIndex' from Blockchain", e);
        }
    }
}

