/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.service;

import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.constant.UnauthorizedOperationException;
import io.meeds.deeds.model.DeedTenant;
import io.meeds.deeds.service.BlockchainService;
import io.meeds.deeds.service.ListenerService;
import io.meeds.deeds.storage.DeedTenantManagerRepository;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TenantService {
    @Autowired(required=false)
    private DeedTenantManagerRepository deedTenantManagerRepository;
    @Autowired
    private BlockchainService blockchainService;
    @Autowired
    private ListenerService listenerService;

    public String getLastTenantCommand(String managerAddress, long nftId) throws UnauthorizedOperationException {
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById(nftId).orElse(null);
        if (deedTenant != null) {
            if (!StringUtils.equals((CharSequence)managerAddress, (CharSequence)deedTenant.getManagerAddress())) {
                throw new UnauthorizedOperationException(this.getUnauthorizedMessage(managerAddress, nftId));
            }
            if (StringUtils.isNotBlank((CharSequence)deedTenant.getStartupTransactionHash())) {
                return "START";
            }
            if (StringUtils.isNotBlank((CharSequence)deedTenant.getShutdownTransactionHash())) {
                return "STOP";
            }
        }
        return "";
    }

    public void saveEmail(String managerAddress, long nftId, String email) throws UnauthorizedOperationException, ObjectNotFoundException {
        if (!this.isDeedManager(managerAddress, nftId)) {
            throw new UnauthorizedOperationException(this.getUnauthorizedMessage(managerAddress, nftId));
        }
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById(nftId).orElse(new DeedTenant());
        deedTenant.setNftId(nftId);
        deedTenant.setManagerAddress(managerAddress.toLowerCase());
        deedTenant.setManagerEmail(email);
        deedTenant.setDate(LocalDateTime.now(ZoneOffset.UTC));
        this.setDeedNftProperties(deedTenant);
        this.deedTenantManagerRepository.save(deedTenant);
        this.listenerService.publishEvent("deed.event.tenantEmailUpdated", (Object)deedTenant);
    }

    public void startTenant(String managerAddress, String transactionHash, long nftId, String email) throws UnauthorizedOperationException, ObjectNotFoundException {
        if (!this.isDeedManager(managerAddress, nftId)) {
            throw new UnauthorizedOperationException(this.getUnauthorizedMessage(managerAddress, nftId));
        }
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById(nftId).orElse(new DeedTenant());
        deedTenant.setNftId(nftId);
        deedTenant.setManagerAddress(managerAddress.toLowerCase());
        deedTenant.setManagerEmail(email);
        deedTenant.setStartupTransactionHash(transactionHash);
        deedTenant.setShutdownTransactionHash(null);
        deedTenant.setDate(LocalDateTime.now(ZoneOffset.UTC));
        this.setDeedNftProperties(deedTenant);
        this.deedTenantManagerRepository.save(deedTenant);
        this.listenerService.publishEvent("deed.event.tenantStart", (Object)deedTenant);
    }

    public void stopTenant(String managerAddress, String transactionHash, long nftId) throws UnauthorizedOperationException, ObjectNotFoundException {
        if (!this.isDeedManager(managerAddress, nftId)) {
            throw new UnauthorizedOperationException(this.getUnauthorizedMessage(managerAddress, nftId));
        }
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById(nftId).orElse(new DeedTenant());
        deedTenant.setNftId(nftId);
        deedTenant.setManagerAddress(managerAddress.toLowerCase());
        deedTenant.setStartupTransactionHash(null);
        deedTenant.setShutdownTransactionHash(transactionHash);
        deedTenant.setDate(LocalDateTime.now(ZoneOffset.UTC));
        this.setDeedNftProperties(deedTenant);
        this.deedTenantManagerRepository.save(deedTenant);
        this.listenerService.publishEvent("deed.event.tenantStop", (Object)deedTenant);
    }

    public boolean isDeedManager(String address, long nftId) {
        return this.blockchainService.isDeedProvisioningManager(address, nftId);
    }

    private void setDeedNftProperties(DeedTenant deedTenant) throws ObjectNotFoundException {
        if (deedTenant.getCardType() < 0 || deedTenant.getCityIndex() < 0) {
            short cardType = this.blockchainService.getDeedCardType(deedTenant.getNftId());
            deedTenant.setCardType(cardType);
            short cityIndex = this.blockchainService.getDeedCityIndex(deedTenant.getNftId());
            deedTenant.setCityIndex(cityIndex);
        }
    }

    private String getUnauthorizedMessage(String managerAddress, long nftId) {
        return "User with address " + managerAddress + " isn't the manager of deed " + nftId;
    }
}

