/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.scheduling.task;

import io.meeds.deeds.service.MeedTokenMetricService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class MeedTokenMetricTask {
    private static final Logger LOG = LoggerFactory.getLogger(MeedTokenMetricTask.class);
    @Autowired
    private MeedTokenMetricService meedTokenMetricService;

    @Scheduled(cron="0 0/30 * * * *")
    public void computeMeedTokenMetrics() {
        LOG.info("Start Computing circulating supply");
        long start = System.currentTimeMillis();
        try {
            this.meedTokenMetricService.computeTokenMetrics();
            LOG.info("End Computing circulating supply in {}ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            LOG.warn("An error occurred while computing circulating supply", (Throwable)e);
        }
    }
}

