/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.security;

import io.meeds.deeds.web.security.DeedAuthenticationProvider;
import io.meeds.deeds.web.utils.Utils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig {
    private static final Logger LOG = LoggerFactory.getLogger(WebSecurityConfig.class);
    private CookieCsrfTokenRepository csrfTokenRepository = new CookieCsrfTokenRepository();

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, DeedAuthenticationProvider authProvider) throws Exception {
        http.authorizeRequests(authorizeRequests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorizeRequests.antMatchers(new String[]{"/static/**", "/api/deeds/**"})).permitAll()).authenticationProvider((AuthenticationProvider)authProvider).csrf(csrf -> {
            this.csrfTokenRepository.setCookiePath("/");
            this.csrfTokenRepository.setCookieHttpOnly(false);
            csrf.csrfTokenRepository((CsrfTokenRepository)this.csrfTokenRepository);
            csrf.ignoringAntMatchers(new String[]{"/static/**", "/api/deeds/**"});
        }).headers(headers -> {
            headers.frameOptions().disable();
            headers.xssProtection().disable();
            headers.contentTypeOptions().disable();
        }).formLogin(formLogin -> ((FormLoginConfigurer)((FormLoginConfigurer)formLogin.loginProcessingUrl("/login")).successHandler((request, response, authentication) -> response.setStatus(200))).failureHandler((request, response, authentication) -> response.setStatus(403))).logout(logout -> logout.logoutUrl("/logout").logoutSuccessHandler((request, response, authentication) -> this.handleLogout(request, response)));
        return (SecurityFilterChain)http.build();
    }

    private void handleLogout(HttpServletRequest request, HttpServletResponse response) {
        CsrfToken csrfToken = this.csrfTokenRepository.generateToken(request);
        this.csrfTokenRepository.saveToken(csrfToken, request, response);
        String loginMessage = Utils.generateLoginMessage(request.getSession(true));
        try {
            response.setContentType("text/plain; charset=UTF-8");
            response.getWriter().append(loginMessage);
            response.getWriter().close();
            response.setStatus(200);
        }
        catch (IOException e) {
            LOG.warn("Error while generating Login Password for user to sign by his wallet", (Throwable)e);
        }
    }
}

