/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.listener;

import io.meeds.deeds.constant.CommonConstants;
import io.meeds.deeds.listener.EventListener;
import io.meeds.deeds.service.OfferService;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfferDeedOwnershipTransferredListener
implements EventListener<CommonConstants.DeedOwnershipTransferEvent> {
    public static final String LISTENER_NAME = "DeedOwnershipTransferredOfferListener";
    private static final List<String> SUPPORTED_EVENTS = Collections.singletonList("deed.event.transferOwnershipFromDeedTenant");
    @Autowired
    private OfferService offerService;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    public void onEvent(String eventName, CommonConstants.DeedOwnershipTransferEvent ownershipTransferEvent) {
        String newOnwer;
        String oldOwner = ownershipTransferEvent.getFrom();
        if (StringUtils.equalsIgnoreCase((CharSequence)oldOwner, (CharSequence)(newOnwer = ownershipTransferEvent.getTo()))) {
            return;
        }
        long nftId = ownershipTransferEvent.getNftId();
        this.offerService.cancelOffers(newOnwer, nftId);
    }
}

