/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.filter;

import io.meeds.deeds.constant.DeedCity;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.service.TenantService;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Component(value="tenantPlaceholderRequestDispatcherFilter")
public class TenantPlaceholderRequestDispatcherFilter
extends HttpFilter {
    private static final long serialVersionUID = 8971410534107824567L;
    private static final Pattern SERVER_HOST_PATTERN = Pattern.compile("(tanit|reshef|ashtarte|melqart|eshmun|kushor|hammon)-([\\d]+)\\.wom\\.meeds\\.io");
    protected TenantService tenantService;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.tenantService = (TenantService)ctx.getBean(TenantService.class);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        long nftId = this.getDeedId(request);
        if (nftId > 0L && !this.tenantService.isTenantCommandStop(nftId) && this.isDeedCity(request, nftId)) {
            response.setContentType("text/html; charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            RequestDispatcher dispatcher = request.getRequestDispatcher("/WEB-INF/jsp/placeholder.jsp");
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        } else {
            response.setStatus(404);
        }
    }

    private long getDeedId(HttpServletRequest request) {
        Matcher matcher;
        String nftId = request.getParameter("nftId");
        if (StringUtils.isBlank((CharSequence)nftId) && StringUtils.isNotBlank((CharSequence)request.getRequestURL()) && (matcher = SERVER_HOST_PATTERN.matcher(request.getRequestURL())).find()) {
            nftId = matcher.group(2);
        }
        if (StringUtils.isNotBlank((CharSequence)nftId)) {
            return Long.parseLong(nftId);
        }
        return -1L;
    }

    private boolean isDeedCity(HttpServletRequest request, long nftId) {
        int deedCityIndex = this.getDeedCityIndex(request);
        if (deedCityIndex >= 0) {
            DeedTenant deedTenant = this.tenantService.getDeedTenant(nftId);
            return deedTenant == null || deedTenant.getCityIndex() == deedCityIndex;
        }
        return true;
    }

    private int getDeedCityIndex(HttpServletRequest request) {
        String cityName = request.getParameter("cityName");
        if (StringUtils.isBlank((CharSequence)cityName)) {
            Matcher matcher = SERVER_HOST_PATTERN.matcher(request.getRequestURL());
            if (matcher.find()) {
                return DeedCity.valueOf((String)matcher.group(1).toUpperCase()).ordinal();
            }
            return -1;
        }
        return DeedCity.valueOf((String)cityName.toUpperCase()).ordinal();
    }
}

