/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.utils;

import io.meeds.deeds.web.utils.EnvironmentService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Random;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final String EXTENDED_HTML_CONTENT_PATH_PARAM = "meeds.deed.extendedHtmlContent.path";
    private static final String APPLICATION_BUILD_NUMBER_PARAM = "application.buildNumber";
    private static final String LOGIN_MESSAGE_ATTRIBUTE_NAME = "login_message";
    private static final Random RANDOM = new Random();
    private static String buildNumber;
    private static String extendedHtmlContent;

    private Utils() {
    }

    public static String generateLoginMessage(HttpSession session) {
        Object token = Utils.getLoginMessage(session);
        if (token == null) {
            token = RANDOM.nextLong() + "-" + RANDOM.nextLong() + "-" + RANDOM.nextLong();
            session.setAttribute(LOGIN_MESSAGE_ATTRIBUTE_NAME, token);
        }
        return token;
    }

    public static String getLoginMessage(HttpSession session) {
        return session == null ? null : (String)session.getAttribute(LOGIN_MESSAGE_ATTRIBUTE_NAME);
    }

    public static String getApplicationBuildNumber() {
        if (StringUtils.isBlank((CharSequence)buildNumber)) {
            buildNumber = EnvironmentService.getEnvironment().getProperty(APPLICATION_BUILD_NUMBER_PARAM, "");
        }
        return buildNumber;
    }

    public static String getExtendedHtmlContent() {
        String extFilePath;
        if (extendedHtmlContent == null && StringUtils.isNotBlank((CharSequence)(extFilePath = EnvironmentService.getEnvironment().getProperty(EXTENDED_HTML_CONTENT_PATH_PARAM, ""))) && Files.exists(Paths.get(extFilePath, new String[0]), new LinkOption[0])) {
            try {
                extendedHtmlContent = Files.readString(Paths.get(extFilePath, new String[0]));
            }
            catch (IOException e) {
                extendedHtmlContent = "";
                LOG.warn("Can't read extended content to include in static HTML page from file {}", (Object)extFilePath, (Object)e);
            }
        }
        return extendedHtmlContent;
    }
}

