/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.filter;

import io.meeds.dapp.web.filter.TenantPlaceholderRequestDispatcherFilter;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.service.TenantService;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={TenantPlaceholderRequestDispatcherFilter.class})
class TenantPlaceholderRequestDispatcherFilterTest {
    @MockBean
    private TenantService tenantServiceMock;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private RequestDispatcher dispatcher;
    private TenantPlaceholderRequestDispatcherFilter dispatcherFilter;

    TenantPlaceholderRequestDispatcherFilterTest() {
    }

    @BeforeEach
    void before() throws ServletException {
        this.dispatcherFilter = new TenantPlaceholderRequestDispatcherFilter(){
            private static final long serialVersionUID = 4367082767921658504L;

            public void init(FilterConfig filterConfig) throws ServletException {
                this.tenantService = TenantPlaceholderRequestDispatcherFilterTest.this.tenantServiceMock;
            }
        };
        this.dispatcherFilter.init(null);
        Mockito.when((Object)this.request.getRequestDispatcher(ArgumentMatchers.anyString())).thenReturn((Object)this.dispatcher);
    }

    @Test
    void testReturnNotFoundResponseWhenNoDeedIdIdentified() throws Exception {
        this.verifyNotFound();
    }

    @Test
    void testReturnNotFoundResponseWhenNoDeedIdIdentifiedWithSimilarURL() throws Exception {
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)new StringBuffer("http://tanit-test.meeds.io/test"));
        this.verifyNotFound();
    }

    @Test
    void testReturnNotFoundResponseWhenDeedIdInHostNameNotStopped() throws Exception {
        long nftId = 1L;
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)new StringBuffer("http://tanit-").append(nftId).append(".meeds.io/test"));
        Mockito.when((Object)this.tenantServiceMock.isTenantCommandStop(nftId)).thenReturn((Object)true);
        this.verifyNotFound();
    }

    @Test
    void testReturnNotFoundResponseWhenDeedIdInParamNotStopped() throws Exception {
        long nftId = 1L;
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)new StringBuffer("http://test/test?nftId=").append(nftId));
        Mockito.when((Object)this.tenantServiceMock.isTenantCommandStop(nftId)).thenReturn((Object)true);
        this.verifyNotFound();
    }

    @Test
    void testForwardResponseWhenDeedIdInHostNameNotStopped() throws Exception {
        long nftId = 1L;
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)new StringBuffer("http://tanit-").append(nftId).append(".meeds.io/test"));
        this.verifyForwarded();
    }

    @Test
    void testForwardResponseWhenDeedIdInParamNotStopped() throws Exception {
        long nftId = 1L;
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)new StringBuffer("http://test/test"));
        Mockito.when((Object)this.request.getParameter("nftId")).thenReturn((Object)String.valueOf(nftId));
        this.verifyForwarded();
    }

    @Test
    void testNotFoundResponseWhenDeedCityInHostNameNotMatching() throws Exception {
        long nftId = 1L;
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)new StringBuffer("http://tanit-").append(nftId).append(".meeds.io/test"));
        DeedTenant deedTenant = new DeedTenant();
        deedTenant.setCityIndex((short)1);
        Mockito.when((Object)this.tenantServiceMock.getDeedTenant(nftId)).thenReturn((Object)deedTenant);
        this.verifyNotFound();
    }

    @Test
    void testNotFoundResponseWhenDeedCityInParameterNameNotMatching() throws IOException, ServletException {
        long nftId = 1L;
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)new StringBuffer("http://test/test"));
        Mockito.when((Object)this.request.getParameter("nftId")).thenReturn((Object)String.valueOf(nftId));
        Mockito.when((Object)this.request.getParameter("cityName")).thenReturn((Object)"tanit");
        DeedTenant deedTenant = new DeedTenant();
        deedTenant.setCityIndex((short)1);
        Mockito.when((Object)this.tenantServiceMock.getDeedTenant(nftId)).thenReturn((Object)deedTenant);
        this.verifyNotFound();
    }

    private void verifyForwarded() throws IOException, ServletException {
        this.dispatcherFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, null);
        ((RequestDispatcher)Mockito.verify((Object)this.dispatcher, (VerificationMode)Mockito.times((int)1))).include((ServletRequest)this.request, (ServletResponse)this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).setStatus(ArgumentMatchers.anyInt());
    }

    private void verifyNotFound() throws IOException, ServletException {
        this.dispatcherFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, null);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(404);
        ((RequestDispatcher)Mockito.verify((Object)this.dispatcher, (VerificationMode)Mockito.never())).include((ServletRequest)this.request, (ServletResponse)this.response);
    }
}

