/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.rest;

import io.meeds.dapp.web.rest.TenantController;
import io.meeds.dapp.web.security.DeedAccessDeniedHandler;
import io.meeds.dapp.web.security.DeedAuthenticationProvider;
import io.meeds.dapp.web.security.WebSecurityConfig;
import io.meeds.deeds.common.constant.TenantProvisioningStatus;
import io.meeds.deeds.common.constant.TenantStatus;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.service.TenantService;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.security.test.context.support.WithAnonymousUser;
import org.springframework.security.test.context.support.WithMockUser;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={TenantController.class, DeedAuthenticationProvider.class, DeedAccessDeniedHandler.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ContextConfiguration(classes={WebSecurityConfig.class})
class TenantControllerTest {
    private static final long NFT_ID = 3L;
    private static final String USERNAME = "testuser";
    @MockBean
    private TenantService tenantService;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    TenantControllerTest() {
    }

    @BeforeEach
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).apply(SecurityMockMvcConfigurers.springSecurity())).build();
    }

    @Test
    @WithAnonymousUser
    void whenAnonymousGetDeedTenant_thenOk() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/tenants/3", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithMockUser(username="testuser", authorities={"USER"})
    void whenAuthenticatedGetDeedTenant_thenNOk() throws Exception {
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(USERNAME, Long.valueOf(3L), false)).thenReturn((Object)new DeedTenant());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/tenants/3", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/tenants/4", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void whenAnonymousGetDeedTenantStartTile_thenNOk() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/tenants/3/startDate", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(""));
        DeedTenant deedTenant = new DeedTenant();
        deedTenant.setTenantStatus(TenantStatus.DEPLOYED);
        deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.START_CONFIRMED);
        LocalDateTime date = LocalDateTime.now(ZoneOffset.UTC);
        deedTenant.setDate(date);
        Mockito.when((Object)this.tenantService.getDeedTenant(3L)).thenReturn((Object)deedTenant);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/tenants/3/startDate", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(CoreMatchers.containsString((String)String.valueOf(date.toEpochSecond(ZoneOffset.UTC)))));
        deedTenant.setTenantStatus(TenantStatus.UNDEPLOYED);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/tenants/3/startDate", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(""));
        deedTenant.setTenantStatus(TenantStatus.DEPLOYED);
        deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.STOP_CONFIRMED);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/tenants/3/startDate", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(""));
    }
}

