/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.service;

import io.meeds.dapp.service.MeedAssetsMetricsService;
import io.meeds.deeds.common.model.DeedCity;
import io.meeds.deeds.common.model.FundInfo;
import io.meeds.deeds.common.service.BlockchainService;
import java.math.BigInteger;
import java.util.Collection;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.util.CollectionUtils;

@SpringBootTest(classes={MeedAssetsMetricsService.class})
class MeedAssetsMetricsServiceTest {
    @MockBean
    private BlockchainService blockchainService;
    @Autowired
    private MeedAssetsMetricsService meedAssetsMetricsService;

    MeedAssetsMetricsServiceTest() {
    }

    @BeforeEach
    void init() {
        Mockito.reset((Object[])new BlockchainService[]{this.blockchainService});
        this.meedAssetsMetricsService.meedAssetsMetrics = null;
    }

    @Test
    void testGetMeedAssetsMetrics() {
        this.testEmptyMetrics();
        BigInteger expectedTotalAllocationPoints = BigInteger.ONE;
        BigInteger expectedTotalFixedPercentage = BigInteger.TWO;
        DeedCity expectedCity = new DeedCity(BigInteger.valueOf(3L), "Tanit", BigInteger.valueOf(4L), BigInteger.valueOf(5L), BigInteger.valueOf(6L));
        FundInfo expectedXMeedFund = new FundInfo("address", BigInteger.valueOf(3L), BigInteger.valueOf(4L), BigInteger.valueOf(5L), BigInteger.valueOf(6L), Boolean.valueOf(false));
        FundInfo expectedSushiPool = new FundInfo("poolAddress", BigInteger.valueOf(30L), BigInteger.valueOf(40L), BigInteger.valueOf(50L), BigInteger.valueOf(60L), Boolean.valueOf(true));
        Mockito.when((Object)this.blockchainService.totalAllocationPoints()).thenReturn((Object)expectedTotalAllocationPoints);
        Mockito.when((Object)this.blockchainService.totalFixedPercentage()).thenReturn((Object)expectedTotalFixedPercentage);
        Mockito.when((Object)this.blockchainService.getCurrentCity()).thenReturn((Object)expectedCity);
        Mockito.when((Object)this.blockchainService.getXMeedFundInfo()).thenReturn((Object)expectedXMeedFund);
        Mockito.when((Object)this.blockchainService.getSushiPairFundInfo()).thenReturn((Object)expectedSushiPool);
        this.testEmptyMetrics();
        Assertions.assertWith((Object)this.meedAssetsMetricsService.getMeedAssetsMetrics(true), (Consumer[])new Consumer[]{meedAssetsMetrics -> {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)meedAssetsMetrics);
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedCity, (Object)meedAssetsMetrics.getCurrentCity());
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTotalAllocationPoints, (Object)meedAssetsMetrics.getTotalAllocationPoints());
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTotalFixedPercentage, (Object)meedAssetsMetrics.getTotalFixedPercentage());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)meedAssetsMetrics.getPools().size());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)meedAssetsMetrics.getPools().stream().anyMatch(fund -> fund.equals((Object)expectedXMeedFund)));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)meedAssetsMetrics.getPools().stream().anyMatch(fund -> fund.equals((Object)expectedSushiPool)));
        }});
    }

    private void testEmptyMetrics() {
        Assertions.assertWith((Object)this.meedAssetsMetricsService.getMeedAssetsMetrics(false), (Consumer[])new Consumer[]{meedAssetsMetrics -> {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)meedAssetsMetrics);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)CollectionUtils.isEmpty((Collection)meedAssetsMetrics.getPools()));
            org.junit.jupiter.api.Assertions.assertNull((Object)meedAssetsMetrics.getCurrentCity());
            org.junit.jupiter.api.Assertions.assertNull((Object)meedAssetsMetrics.getTotalAllocationPoints());
            org.junit.jupiter.api.Assertions.assertNull((Object)meedAssetsMetrics.getTotalFixedPercentage());
        }});
    }
}

